/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class MolleweideProjection
extends PseudoCylindricalProjection {
    public static final int MOLLEWEIDE = 0;
    public static final int WAGNER4 = 1;
    public static final int WAGNER5 = 2;
    private static final int MAX_ITER = 10;
    private static final double TOLERANCE = 1.0E-7;
    private int type = 0;
    private double cx;
    private double cy;
    private double cp;

    public MolleweideProjection() {
        this(1.5707963267948966);
    }

    public MolleweideProjection(int n) {
        this.type = n;
        switch (n) {
            case 0: {
                this.init(1.5707963267948966);
                break;
            }
            case 1: {
                this.init(1.0471975511965976);
                break;
            }
            case 2: {
                this.init(1.5707963267948966);
                this.cx = 0.90977;
                this.cy = 1.65014;
                this.cp = 3.00896;
            }
        }
    }

    public MolleweideProjection(double d) {
        this.init(d);
    }

    public void init(double d) {
        double d2 = d + d;
        double d3 = Math.sin(d);
        double d4 = Math.sqrt(Math.PI * 2 * d3 / (d2 + Math.sin(d2)));
        this.cx = 2.0 * d4 / Math.PI;
        this.cy = d4 / d3;
        this.cp = d2 + Math.sin(d2);
    }

    public MolleweideProjection(double d, double d2, double d3) {
        this.cx = d;
        this.cy = d2;
        this.cp = d3;
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = this.cp * Math.sin(d2);
        for (n = 10; n != 0; --n) {
            double d4 = (d2 + Math.sin(d2) - d3) / (1.0 + Math.cos(d2));
            d2 -= d4;
            if (Math.abs(d4) < 1.0E-7) break;
        }
        d2 = n == 0 ? (d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : (d2 *= 0.5);
        projCoordinate.x = this.cx * d * Math.cos(d2);
        projCoordinate.y = this.cy * Math.sin(d2);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.asin(d2 / this.cy);
        double d4 = d / (this.cx * Math.cos(d3));
        d3 += d3;
        d3 = Math.asin((d3 + Math.sin(d3)) / this.cp);
        projCoordinate.x = d4;
        projCoordinate.y = d3;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case 1: {
                return "Wagner IV";
            }
            case 2: {
                return "Wagner V";
            }
        }
        return "Molleweide";
    }
}

