/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import public_transport.StopImporterAction;
import public_transport.WaypointTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaypointsEnableCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private WaypointTableModel waypointTM = null;
    private String type = null;

    public WaypointsEnableCommand(StopImporterAction controller) {
        int i;
        this.waypointTM = controller.getWaypointTableModel();
        this.type = controller.getDialog().getStoptype();
        this.workingLines = new Vector();
        int[] selectedLines = controller.getDialog().getWaypointsTable().getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            for (i = 0; i < selectedLines.length; ++i) {
                consideredLines.add(selectedLines[i]);
            }
        } else {
            for (i = 0; i < this.waypointTM.getRowCount(); ++i) {
                consideredLines.add(new Integer(i));
            }
        }
        for (i = 0; i < consideredLines.size(); ++i) {
            if (this.waypointTM.nodes.elementAt((Integer)consideredLines.elementAt(i)) != null) continue;
            this.workingLines.add((Integer)consideredLines.elementAt(i));
        }
    }

    public boolean executeCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = StopImporterAction.createNode(this.waypointTM.coors.elementAt(j), this.type, (String)this.waypointTM.getValueAt(j, 1));
            if ("".equals((String)this.waypointTM.getValueAt(j, 2))) {
                node.put("shelter", null);
            } else {
                node.put("shelter", (String)this.waypointTM.getValueAt(j, 2));
            }
            this.waypointTM.nodes.set(j, node);
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.waypointTM.nodes.elementAt(j);
            this.waypointTM.nodes.set(j, null);
            if (node == null) continue;
            Main.main.getCurrentDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public JLabel getDescription() {
        return new JLabel("public_transport.Waypoints.Enable");
    }
}

