/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import public_transport.StopImporterAction;
import public_transport.TrackReference;
import public_transport.WaypointTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsStoptypeCommand
extends Command {
    private Vector<HighwayRailway> oldStrings = null;
    private WaypointTableModel waypointTM = null;
    private DefaultListModel tracksListModel = null;
    private String type = null;

    public SettingsStoptypeCommand(StopImporterAction controller) {
        this.waypointTM = controller.getWaypointTableModel();
        this.tracksListModel = controller.getTracksListModel();
        this.type = controller.getDialog().getStoptype();
        this.oldStrings = new Vector();
    }

    public boolean executeCommand() {
        this.oldStrings.clear();
        for (int i = 0; i < this.waypointTM.getRowCount(); ++i) {
            if (this.waypointTM.nodes.elementAt(i) == null) continue;
            Node node = this.waypointTM.nodes.elementAt(i);
            this.oldStrings.add(new HighwayRailway(node));
            StopImporterAction.setTagsWrtType(node, this.type);
        }
        for (int j = 0; j < this.tracksListModel.size(); ++j) {
            TrackReference track = (TrackReference)this.tracksListModel.elementAt(j);
            for (int i = 0; i < track.stoplistTM.getRowCount(); ++i) {
                if (track.stoplistTM.nodeAt(i) == null) continue;
                Node node = track.stoplistTM.nodeAt(i);
                this.oldStrings.add(new HighwayRailway(node));
                StopImporterAction.setTagsWrtType(node, this.type);
            }
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.oldStrings.size(); ++i) {
            HighwayRailway hr = this.oldStrings.elementAt(i);
            hr.node.put("highway", hr.highway);
            hr.node.put("railway", hr.railway);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public JLabel getDescription() {
        return new JLabel("public_transport.Settings.ChangeStoptype");
    }

    private class HighwayRailway {
        public Node node;
        public String highway;
        public String railway;

        public HighwayRailway(Node node) {
            this.node = node;
            this.highway = node.get("highway");
            this.railway = node.get("railway");
        }
    }
}

