/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineSelectionDialog;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptEditorModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class ScriptingEningeInfoPanel
extends JPanel
implements PropertyChangeListener,
HyperlinkListener {
    private static final Logger logger = Logger.getLogger(ScriptingEningeInfoPanel.class.getName());
    private JEditorPane jepInfo;
    private ScriptEditorModel model;

    public ScriptingEningeInfoPanel(ScriptEditorModel model) {
        CheckParameterUtil.ensureParameterNotNull((Object)model);
        model.addPropertyChangeListener(this);
        this.model = model;
        this.build();
        this.refreshInfo(model.getScriptEngineFactory());
    }

    protected void build() {
        this.jepInfo = new JEditorPane("text/html", "");
        this.jepInfo.setOpaque(false);
        this.jepInfo.setEditable(false);
        this.jepInfo.addHyperlinkListener(this);
        Font f = UIManager.getFont("Label.font");
        StyleSheet ss = new StyleSheet();
        String rule = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), f.isBold() ? "bold" : "normal", f.isItalic() ? "italic" : "normal");
        rule = "body {" + rule + "}";
        rule = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), "bold", f.isItalic() ? "italic" : "normal");
        rule = "strong {" + rule + "}";
        ss.addRule(rule);
        ss.addRule("a {text-decoration: underline; color: blue}");
        HTMLEditorKit kit = new HTMLEditorKit();
        kit.setStyleSheet(ss);
        this.jepInfo.setEditorKit(kit);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jepInfo, "Center");
    }

    public ScriptingEningeInfoPanel() {
        this.build();
    }

    protected void refreshInfo(ScriptEngineFactory factory) {
        StringBuffer sb = new StringBuffer();
        if (factory == null) {
            sb.append("<html>");
            sb.append(I18n.tr((String)"No script engine selected.")).append(" ");
            sb.append("<a href=\"urn:select-script-engine\">").append(I18n.tr((String)"Select...")).append("</a>");
            sb.append("<html>");
        } else {
            sb.append("<html>");
            sb.append(I18n.tr((String)"Executing scripts in language <strong>{0}</strong> using engine <strong>{1}</strong>.", (Object[])new Object[]{factory.getLanguageName(), factory.getEngineName()}));
            sb.append(" ");
            sb.append("<a href=\"urn:change-script-engine\">").append(I18n.tr((String)"Change...")).append("</a>");
            sb.append("</html>");
        }
        this.jepInfo.setText(sb.toString());
    }

    protected void promptForScriptEngine() {
        ScriptEngine se = ScriptEngineSelectionDialog.select(this, this.model.getScriptEngineFactory());
        if (se != null) {
            this.model.setScriptEngineFactory(se.getFactory());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ScriptEditorModel.PROP_SCRIPT_ENGINE_FACTORY)) {
            return;
        }
        this.refreshInfo((ScriptEngineFactory)evt.getNewValue());
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            this.promptForScriptEngine();
        }
    }
}

