/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.plugins.scripting.ui.console.CloseAction;
import org.openstreetmap.josm.plugins.scripting.ui.console.OpenAction;
import org.openstreetmap.josm.plugins.scripting.ui.console.SaveAction;
import org.openstreetmap.josm.plugins.scripting.ui.console.SaveAsAction;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptEditorModel;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptingConsolePanel;
import org.openstreetmap.josm.plugins.scripting.util.Assert;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ScriptingConsole
extends JFrame {
    private static final Logger logger = Logger.getLogger(ScriptingConsole.class.getName());
    public static final BooleanProperty PREF_ALWAYS_ON_TOP = new BooleanProperty(ScriptingConsole.class.getName() + ".alwaysOnTop", true);
    private JCheckBox cbAlwaysOnTop;
    private static ScriptingConsole instance = null;
    private ScriptingConsolePanel pnlScriptingConsole = null;
    private static final CopyOnWriteArrayList<ScriptingConsoleListener> listeners = new CopyOnWriteArrayList();

    public static ScriptingConsole getScriptingConsole() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showScriptingConsole() {
        Class<ScriptingConsole> clazz = ScriptingConsole.class;
        synchronized (ScriptingConsole.class) {
            if (instance == null) {
                instance = new ScriptingConsole();
                instance.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ScriptingConsole old = instance;
                        instance = null;
                        ScriptingConsole.fireScriptingConsoleChanged(old, instance);
                    }
                });
            }
            instance.setVisible(true);
            instance.toFront();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hideScriptingConsole() {
        Class<ScriptingConsole> clazz = ScriptingConsole.class;
        synchronized (ScriptingConsole.class) {
            if (instance != null) {
                WindowEvent wev = new WindowEvent(instance, 201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void toggleScriptingConsole() {
        if (instance == null) {
            ScriptingConsole.showScriptingConsole();
        } else {
            ScriptingConsole.hideScriptingConsole();
        }
    }

    private ScriptingConsole() {
        super(I18n.tr((String)"Scripting Console"));
        this.build();
    }

    protected JMenuBar buildMenuBar() {
        JMenu mnuFile = new JMenu(I18n.tr((String)"File"));
        mnuFile.add(new OpenAction());
        SaveAction act = new SaveAction();
        this.getScriptEditorModel().addPropertyChangeListener(act);
        mnuFile.add(act);
        mnuFile.add(new SaveAsAction());
        mnuFile.addSeparator();
        mnuFile.add(new CloseAction());
        JMenu mnuEdit = new JMenu(I18n.tr((String)"Edit"));
        mnuEdit.add(this.pnlScriptingConsole.getScriptLog().getClearAction());
        JMenuBar bar = new JMenuBar();
        bar.add(mnuFile);
        bar.add(mnuEdit);
        return bar;
    }

    protected JPanel buildControlPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        this.cbAlwaysOnTop = new JCheckBox(new ToggleAlwaysOnTopAction());
        this.cbAlwaysOnTop.setFont(UIManager.getFont("Label.font").deriveFont(10));
        pnl.add(this.cbAlwaysOnTop);
        return pnl;
    }

    protected void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.pnlScriptingConsole = new ScriptingConsolePanel();
        c.add((Component)this.pnlScriptingConsole, "Center");
        c.add((Component)this.buildControlPanel(), "South");
        this.setJMenuBar(this.buildMenuBar());
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(ScriptingConsole.class.getName() + ".geometry", WindowGeometry.centerInWindow((Component)this, (Dimension)new Dimension(500, 800))).applySafe((Window)this);
        } else {
            new WindowGeometry((Window)this).remember(ScriptingConsole.class.getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void open(File file) {
        Assert.assertArgNotNull(file, "file");
        Assert.assertArg(file.isFile(), "Expected a file, got a directory. File is: {0}", file);
        Assert.assertArg(file.canRead(), "Expected a readable file, but can''t read file. File is: {0}", file);
        this.pnlScriptingConsole.open(file);
    }

    public void save(File file) {
        Assert.assertArgNotNull(file, "file");
        this.pnlScriptingConsole.save(file);
    }

    public void save() {
        this.pnlScriptingConsole.save();
    }

    public ScriptEditorModel getScriptEditorModel() {
        return this.pnlScriptingConsole.getScriptEditorModel();
    }

    public static void addScriptingConsoleListener(ScriptingConsoleListener l) {
        if (l == null) {
            return;
        }
        listeners.addIfAbsent(l);
    }

    public static void removeScriptingConsoleListener(ScriptingConsoleListener l) {
        if (l == null) {
            return;
        }
        listeners.remove(l);
    }

    protected static void fireScriptingConsoleChanged(ScriptingConsole oldValue, ScriptingConsole newValue) {
        for (ScriptingConsoleListener l : listeners) {
            l.scriptingConsoleChanged(oldValue, newValue);
        }
    }

    public static interface ScriptingConsoleListener {
        public void scriptingConsoleChanged(ScriptingConsole var1, ScriptingConsole var2);
    }

    private class ToggleAlwaysOnTopAction
    extends AbstractAction {
        public ToggleAlwaysOnTopAction() {
            this.putValue("Name", I18n.tr((String)"Always on top"));
            this.putValue("SwingSelectedKey", PREF_ALWAYS_ON_TOP.get());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptingConsole.this.setAlwaysOnTop(ScriptingConsole.this.cbAlwaysOnTop.isSelected());
        }
    }
}

