/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.script.ScriptEngineFactory;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineProvider;

public class ScriptEditorModel {
    public static final StringProperty PREF_SCRIPT_ENGINE_NAME = new StringProperty(ScriptEditorModel.class.getName() + ".scriptEngineName", null);
    public static final String PROP_SCRIPT_ENGINE_FACTORY = ScriptEditorModel.class.getName() + ".scriptEngineFactory";
    public static final String PROP_SCRIPT_FILE = ScriptEditorModel.class.getName() + ".scriptFile";
    private ScriptEngineFactory factory = null;
    private File scriptFile = null;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    protected void restoreFromPreferences() {
        String name = PREF_SCRIPT_ENGINE_NAME.get();
        this.factory = name == null ? null : ScriptEngineProvider.getInstance().getScriptFactoryByName(name);
    }

    protected void saveToPreferences() {
        if (this.factory == null) {
            PREF_SCRIPT_ENGINE_NAME.put(null);
        } else {
            PREF_SCRIPT_ENGINE_NAME.put(this.factory.getEngineName());
        }
    }

    public ScriptEditorModel() {
        this.restoreFromPreferences();
    }

    public ScriptEngineFactory getScriptEngineFactory() {
        return this.factory;
    }

    public void setScriptEngineFactory(ScriptEngineFactory factory) {
        if (this.factory == factory) {
            return;
        }
        ScriptEngineFactory oldValue = this.factory;
        this.factory = factory;
        this.support.firePropertyChange(PROP_SCRIPT_ENGINE_FACTORY, oldValue, this.factory);
        this.saveToPreferences();
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        if (this.scriptFile == scriptFile) {
            return;
        }
        if (this.scriptFile != null && this.scriptFile.equals(scriptFile)) {
            return;
        }
        File oldValue = this.scriptFile;
        this.scriptFile = scriptFile;
        this.support.firePropertyChange(PROP_SCRIPT_FILE, oldValue, this.scriptFile);
    }
}

