/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptingConsole;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SaveAsAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(SaveAsAction.class.getName());

    protected File askFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(I18n.tr((String)"Select a script"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        int ret = chooser.showSaveDialog(ScriptingConsole.getScriptingConsole());
        if (ret != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public SaveAsAction() {
        this.putValue("Name", I18n.tr((String)"Save as ..."));
        this.putValue("ShortDescription", I18n.tr((String)"Save to a script file"));
        this.putValue("SmallIcon", ImageProvider.get((String)"save_as"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File f = this.askFile();
        if (f == null) {
            return;
        }
        ScriptingConsole.getScriptingConsole().save(f);
    }
}

