/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.util.TableCellEditorSupport;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineProvider;
import org.openstreetmap.josm.plugins.scripting.preferences.ScriptEngineJarInfo;
import org.openstreetmap.josm.plugins.scripting.preferences.ScriptEngineJarTableModel;
import org.openstreetmap.josm.plugins.scripting.ui.ScriptEngineCellRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScriptEnginesConfigurationPanel
extends VerticallyScrollablePanel {
    private ScriptEngineJarTableModel model;
    private JTable tblJarFiles;
    private RemoveJarAction actDelete;

    public ScriptEnginesConfigurationPanel() {
        this.build();
        this.model.restoreFromPreferences();
    }

    protected JPanel buildScriptEnginesInfoPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JList lstEngines = new JList(ScriptEngineProvider.getInstance());
        lstEngines.setCellRenderer(new ScriptEngineCellRenderer());
        lstEngines.setVisibleRowCount(3);
        pnl.add(lstEngines, "Center");
        lstEngines.setSelectionMode(0);
        return pnl;
    }

    protected JPanel buildScriptEngineJarsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(I18n.tr((String)"JAR files"))));
        GridBagConstraints gc = new GridBagConstraints();
        HtmlPanel info = new HtmlPanel();
        info.setText("<html>" + I18n.tr((String)"Enter additional JAR files which provide script engines.") + "</html>");
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 1;
        pnl.add((Component)info, gc);
        this.model = new ScriptEngineJarTableModel();
        this.tblJarFiles = new JTable(this.model, new ColumnModel());
        this.tblJarFiles.setSelectionModel(this.model.getSelectionModel());
        this.tblJarFiles.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblJarFiles.setRowHeight(new JButton((String)"...").getPreferredSize().height);
        JScrollPane jp = new JScrollPane(this.tblJarFiles);
        jp.setHorizontalScrollBarPolicy(31);
        jp.setVerticalScrollBarPolicy(20);
        jp.setMinimumSize(new Dimension(0, 100));
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)jp, gc);
        JPanel ctrlPanel = new JPanel(new FlowLayout(0));
        AddJarAction actAdd = new AddJarAction();
        ctrlPanel.add(new JButton(actAdd));
        this.actDelete = new RemoveJarAction();
        ctrlPanel.add(new JButton(this.actDelete));
        this.model.getSelectionModel().addListSelectionListener(this.actDelete);
        this.tblJarFiles.getActionMap().put("deleteSelection", this.actDelete);
        this.tblJarFiles.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "deleteSelection");
        this.tblJarFiles.getActionMap().put("insertRow", actAdd);
        this.tblJarFiles.getInputMap(0).put(KeyStroke.getKeyStroke(155, 0), "insertRow");
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        pnl.add((Component)ctrlPanel, gc);
        return pnl;
    }

    protected JPanel buildScriptEnginesPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(I18n.tr((String)"Available script engines"))));
        GridBagConstraints gc = new GridBagConstraints();
        HtmlPanel info = new HtmlPanel();
        info.setText("<html>" + I18n.tr((String)"JOSM currently supports the following script engines:") + "</html>");
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        gc.insets = new Insets(3, 3, 3, 3);
        pnl.add((Component)info, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets = new Insets(3, 3, 3, 3);
        pnl.add((Component)this.buildScriptEnginesInfoPanel(), gc);
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        this.add(this.buildScriptEnginesPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        this.add(this.buildScriptEngineJarsPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add(new JPanel(), gc);
    }

    public void persistToPreferences() {
        this.model.persistToPreferences();
    }

    public void restoreFromPreferences() {
        this.model.restoreFromPreferences();
    }

    private static class JarFileNameEditor
    extends JPanel
    implements TableCellEditor {
        private static final Logger logger = Logger.getLogger(JarFileNameEditor.class.getName());
        private JTextField tfJarFile;
        private JButton btnLauchFileChooser;
        private TableCellEditorSupport tableCellEditorSupport = new TableCellEditorSupport((Object)this);
        private ScriptEngineJarInfo info;

        public JarFileNameEditor() {
            this.build();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.fill = 1;
            this.tfJarFile = new JTextField();
            this.add((Component)this.tfJarFile, gc);
            SelectAllOnFocusGainedDecorator.decorate((JTextComponent)this.tfJarFile);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
            gc.fill = 3;
            this.btnLauchFileChooser = new JButton(new LaunchFileChooserAction());
            this.add((Component)this.btnLauchFileChooser, gc);
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.tableCellEditorSupport.addCellEditorListener(l);
        }

        @Override
        public void cancelCellEditing() {
            this.tfJarFile.setText(this.info.getJarFilePath());
            this.tableCellEditorSupport.fireEditingCanceled();
        }

        @Override
        public Object getCellEditorValue() {
            return this.tfJarFile.getText();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() == 2;
            }
            return false;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.tableCellEditorSupport.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.tableCellEditorSupport.fireEditingStopped();
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.info = (ScriptEngineJarInfo)value;
            this.tfJarFile.setText(this.info.getJarFilePath());
            this.tfJarFile.selectAll();
            return this;
        }

        private class LaunchFileChooserAction
        extends AbstractAction {
            public LaunchFileChooserAction() {
                this.putValue("Name", "...");
                this.putValue("ShortDescription", I18n.tr((String)"Launch file chooser"));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int ret;
                String fileName = JarFileNameEditor.this.tfJarFile.getText().trim();
                File currentFile = null;
                if (!fileName.isEmpty()) {
                    currentFile = new File(fileName);
                }
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n.tr((String)"Select a jar file"));
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(false);
                if (currentFile != null) {
                    chooser.setCurrentDirectory(currentFile);
                    chooser.setSelectedFile(currentFile);
                }
                if ((ret = chooser.showOpenDialog(JarFileNameEditor.this.btnLauchFileChooser)) == 0) {
                    currentFile = chooser.getSelectedFile();
                    JarFileNameEditor.this.tfJarFile.setText(currentFile.toString());
                    JarFileNameEditor.this.stopCellEditing();
                } else {
                    JarFileNameEditor.this.tfJarFile.requestFocusInWindow();
                }
            }
        }
    }

    private class AddJarAction
    extends AbstractAction {
        public AddJarAction() {
            this.putValue("Name", I18n.tr((String)"Add"));
            this.putValue("ShortDescription", I18n.tr((String)"Add a jar file providing a script engine"));
            this.putValue("SmallIcon", ImageProvider.get((String)"add"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEnginesConfigurationPanel.this.model.addNew();
            ScriptEnginesConfigurationPanel.this.tblJarFiles.editCellAt(ScriptEnginesConfigurationPanel.this.tblJarFiles.getRowCount() - 1, 1);
        }
    }

    private class RemoveJarAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveJarAction() {
            this.putValue("Name", I18n.tr((String)"Remove"));
            this.putValue("ShortDescription", I18n.tr((String)"Remove the selected jar files"));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"delete"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEnginesConfigurationPanel.this.model.deleteSelected();
        }

        public void updateEnabledState() {
            this.setEnabled(!ScriptEnginesConfigurationPanel.this.model.getSelectionModel().isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    private static class ScriptEngineJarCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public ScriptEngineJarCellRenderer() {
            this.setOpaque(true);
        }

        protected void reset() {
            this.setIcon(null);
            this.setText("");
            this.setForeground(UIManager.getColor("Table.foreground"));
            this.setBackground(UIManager.getColor("Table.background"));
            this.setHorizontalAlignment(2);
        }

        protected void renderColors(boolean selected) {
            if (!selected) {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            } else {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            }
        }

        protected void renderJarName(ScriptEngineJarInfo jar) {
            String fileName = jar.getJarFilePath();
            File f = new File(fileName.trim());
            File parent = f.getParentFile();
            if (parent != null) {
                String parentName = parent.getName();
                if (parentName.length() > 15) {
                    this.setText(parentName.substring(0, 10) + "..." + File.pathSeparator + f.getName());
                } else {
                    this.setText(f.toString());
                }
            } else {
                this.setText(f.toString());
            }
        }

        protected void renderJarStatus(ScriptEngineJarInfo jar) {
            this.setHorizontalAlignment(0);
            String msg = jar.getStatusMessage();
            if (jar.getJarFilePath().trim().isEmpty()) {
                this.setIcon(null);
                this.setToolTipText("");
            } else if (msg.equals("OK")) {
                this.setIcon(ImageProvider.get((String)"valid"));
                this.setToolTipText("");
            } else {
                this.setIcon(ImageProvider.get((String)"error"));
                this.setToolTipText(msg);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ScriptEngineJarInfo jar = (ScriptEngineJarInfo)value;
            this.reset();
            switch (column) {
                case 0: {
                    this.renderJarStatus(jar);
                    break;
                }
                case 1: {
                    this.renderColors(isSelected);
                    this.renderJarName(jar);
                }
            }
            return this;
        }
    }

    private static class ColumnModel
    extends DefaultTableColumnModel {
        public ColumnModel() {
            ScriptEngineJarCellRenderer renderer = new ScriptEngineJarCellRenderer();
            TableColumn tc = new TableColumn(0);
            tc.setHeaderValue("");
            tc.setMaxWidth(30);
            tc.setPreferredWidth(30);
            tc.setMinWidth(30);
            tc.setResizable(false);
            tc.setCellRenderer(renderer);
            this.addColumn(tc);
            tc = new TableColumn(1);
            tc.setHeaderValue(I18n.tr((String)"JAR file"));
            tc.setCellRenderer(renderer);
            tc.setCellEditor(new JarFileNameEditor());
            tc.setResizable(true);
            this.addColumn(tc);
        }
    }
}

