/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.preferences;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.openstreetmap.josm.tools.I18n;

public class ScriptEngineJarInfo
implements Comparable<ScriptEngineJarInfo> {
    public static final String OK_MESSAGE = "OK";
    private String jarFilePath;
    private String statusMessage = null;

    public void analyse() {
        File jar = null;
        jar = new File(this.jarFilePath);
        if (!jar.exists()) {
            this.statusMessage = I18n.tr((String)"''{0}'' doesn''t exist.", (Object[])new Object[]{jar});
            return;
        }
        if (!jar.isFile()) {
            this.statusMessage = I18n.tr((String)"''{0}'' is a directory. Expecting a jar file instead.", (Object[])new Object[]{jar});
            return;
        }
        if (!jar.canRead()) {
            this.statusMessage = I18n.tr((String)"''{0}'' isn''t readable. Can''t load a script engine from this file.", (Object[])new Object[]{jar});
            return;
        }
        JarFile jf = null;
        try {
            jf = new JarFile(jar);
        }
        catch (IOException e) {
            this.statusMessage = I18n.tr((String)"Failed to open file ''{0}'' as jar file. Can''t load a script engine from this file.", (Object[])new Object[]{jar});
            return;
        }
        ZipEntry ze = jf.getEntry("META-INF/services/javax.script.ScriptEngineFactory");
        if (ze == null) {
            this.statusMessage = I18n.tr((String)"The jar file ''{0}'' doesn''t provide a script engine. The entry ''{1}'' is missing.", (Object[])new Object[]{jar, "/META-INF/services/javax.script.ScriptEngineFactory"});
            return;
        }
        this.statusMessage = OK_MESSAGE;
    }

    public ScriptEngineJarInfo(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        this.jarFilePath = fileName.trim();
        this.analyse();
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            this.analyse();
        }
        return this.statusMessage;
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public void setJarFilePath(String path) {
        if (path == null) {
            path = "";
        }
        this.jarFilePath = path = path.trim();
        this.analyse();
    }

    public String toString() {
        return MessageFormat.format("<scriptJarInfo for=''{0}'' />", this.jarFilePath);
    }

    @Override
    public int compareTo(ScriptEngineJarInfo o) {
        if (o == null) {
            return -1;
        }
        return this.jarFilePath.compareTo(o.jarFilePath);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jarFilePath == null ? 0 : this.jarFilePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptEngineJarInfo other = (ScriptEngineJarInfo)obj;
        return !(this.jarFilePath == null ? other.jarFilePath != null : !this.jarFilePath.equals(other.jarFilePath));
    }
}

