/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openstreetmap.josm.plugins.scripting.preferences.ScriptDescriptor;
import org.openstreetmap.josm.plugins.scripting.util.IOUtil;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="scriptsType")
@XmlRootElement(name="scripts")
public class ScriptDescriptors {
    @XmlElement(name="script")
    protected List<ScriptDescriptor> scripts;

    public static List<ScriptDescriptor> unmarshall(Reader reader) throws JAXBException, SAXException, IOException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ScriptDescriptors.class, ScriptDescriptor.class});
        Unmarshaller um = jc.createUnmarshaller();
        um.setSchema(ScriptDescriptors.getSchema());
        um.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                return false;
            }
        });
        ScriptDescriptors sd = (ScriptDescriptors)um.unmarshal(reader);
        return sd.scripts == null ? Collections.emptyList() : sd.scripts;
    }

    public static void marshall(Writer writer, List<ScriptDescriptor> scripts) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ScriptDescriptors.class, ScriptDescriptor.class});
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ScriptDescriptors descs = new ScriptDescriptors();
        descs.scripts = scripts;
        m.marshal((Object)descs, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema getSchema() throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream is = null;
        try {
            is = ScriptDescriptor.class.getResourceAsStream("script.xsd");
            if (is == null) {
                throw new IOException(MessageFormat.format("failed to open input stream to resource ''{0}''", "script.xsd"));
            }
            Schema schema = factory.newSchema(new StreamSource(is));
            return schema;
        }
        finally {
            IOUtil.close(is);
        }
    }
}

