/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.UUID;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineProvider;
import org.openstreetmap.josm.plugins.scripting.preferences.GridBagConstraintBuilder;
import org.openstreetmap.josm.plugins.scripting.preferences.ScriptDescriptor;
import org.openstreetmap.josm.plugins.scripting.preferences.ScriptEngineComboBoxModel;
import org.openstreetmap.josm.plugins.scripting.ui.ScriptEngineCellRenderer;
import org.openstreetmap.josm.plugins.scripting.util.Assert;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ScriptDescriptorEditorDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(ScriptDescriptorEditorDialog.class.getName());
    private JTextField tfId;
    private JTextField tfDisplayName;
    private JTextField tfScriptFile;
    private JButton btnLaunchFileChooser;
    private ScriptingEngineEditorPanel pnlScriptEngineEditor;
    private OKAction actOK;
    private boolean canceled = false;

    public ScriptDescriptorEditorDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    protected JPanel buildScriptFileInputPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GridBagConstraintBuilder.gbc().cell(0, 0).weight(1.0, 0.0).constraints();
        this.tfScriptFile = new JTextField();
        pnl.add((Component)this.tfScriptFile, gbc);
        this.tfScriptFile.setToolTipText(I18n.tr((String)"Full local path to the script file"));
        SelectAllOnFocusGainedDecorator.decorate((JTextComponent)this.tfScriptFile);
        gbc = GridBagConstraintBuilder.gbc().cell(1, 0).weight(0.0, 0.0).constraints();
        this.btnLaunchFileChooser = new JButton(new SelectScriptFileAction());
        pnl.add((Component)this.btnLaunchFileChooser, gbc);
        this.btnLaunchFileChooser.setFocusable(false);
        this.btnLaunchFileChooser.setBorder(null);
        return pnl;
    }

    protected JPanel buildMainPropertiesPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GridBagConstraintBuilder.gbc().cell(0, 0).weight(0.0, 0.0).borderright(5).constraints();
        pnl.add((Component)new JLabel(I18n.tr((String)"ID:")), gbc);
        gbc = GridBagConstraintBuilder.gbc().cell(1, 0).weight(1.0, 0.0).constraints();
        this.tfId = new JTextField();
        pnl.add((Component)this.tfId, gbc);
        this.tfId.setToolTipText(I18n.tr((String)"The unique internal ID used to identify the script."));
        SelectAllOnFocusGainedDecorator.decorate((JTextComponent)this.tfId);
        gbc = GridBagConstraintBuilder.gbc().cell(2, 0).weight(0.0, 0.0).constraints();
        JButton btn = new JButton(new GenerateIdAction());
        pnl.add((Component)btn, gbc);
        btn.setBorder(null);
        btn.setFocusable(false);
        gbc = GridBagConstraintBuilder.gbc().cell(0, 1).weight(0.0, 0.0).borderright(5).constraints();
        pnl.add((Component)new JLabel(I18n.tr((String)"Display name:")), gbc);
        gbc = GridBagConstraintBuilder.gbc().cell(1, 1, 2, 1).weight(1.0, 0.0).constraints();
        this.tfDisplayName = new JTextField();
        pnl.add((Component)this.tfDisplayName, gbc);
        this.tfDisplayName.setToolTipText(I18n.tr((String)"The display name of the script. Used in menu entries."));
        SelectAllOnFocusGainedDecorator.decorate((JTextComponent)this.tfDisplayName);
        gbc = GridBagConstraintBuilder.gbc().cell(0, 2).weight(0.0, 0.0).borderright(5).constraints();
        pnl.add((Component)new JLabel(I18n.tr((String)"Script file:")), gbc);
        gbc = GridBagConstraintBuilder.gbc().cell(1, 2, 2, 1).weight(1.0, 0.0).constraints();
        pnl.add((Component)this.buildScriptFileInputPanel(), gbc);
        gbc = GridBagConstraintBuilder.gbc().cell(0, 3, 3, 1).weight(1.0, 0.0).anchor(18).constraints();
        this.pnlScriptEngineEditor = new ScriptingEngineEditorPanel();
        pnl.add((Component)this.pnlScriptEngineEditor, gbc);
        gbc = GridBagConstraintBuilder.gbc().cell(0, 4, 3, 1).weight(1.0, 1.0).constraints();
        pnl.add((Component)new JPanel(), gbc);
        return pnl;
    }

    protected JPanel buildControlButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        this.actOK = new OKAction();
        pnl.add((Component)new SideButton((Action)this.actOK));
        pnl.add((Component)new SideButton((Action)new CancelAction()));
        pnl.add((Component)new SideButton((Action)new ContextSensitiveHelpAction(HelpUtil.ht((String)"/Plugins/Scripting"))));
        return pnl;
    }

    protected void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)this.buildMainPropertiesPanel(), "Center");
        pnl.add((Component)this.buildControlButtonPanel(), "South");
        c.add((Component)pnl, "Center");
        this.addWindowListener(new WindowEventHandler());
        this.tfId.getDocument().addDocumentListener(this.actOK);
        this.tfScriptFile.getDocument().addDocumentListener(this.actOK);
        this.tfScriptFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.propagate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.propagate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.propagate();
            }

            public void propagate() {
                ScriptDescriptorEditorDialog.this.pnlScriptEngineEditor.refreshAutomaticallyDerivedScriptingEngine();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)this.getParent(), (Dimension)new Dimension(400, 400))).applySafe((Window)this);
        } else {
            new WindowGeometry((Window)this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void populate(ScriptDescriptor sd) {
        if (sd == null) {
            this.tfDisplayName.setText("");
            this.tfId.setText("");
            this.tfScriptFile.setText("");
            this.setTitle(I18n.tr((String)"Define a new script"));
        } else {
            this.tfId.setText(sd.getId());
            this.tfDisplayName.setText(sd.getDisplayName() == null ? "" : sd.getDisplayName());
            this.tfScriptFile.setText(sd.getScriptFile() == null ? "" : sd.getScriptFile().toString());
            this.setTitle(I18n.tr((String)"Edit a script"));
        }
        this.pnlScriptEngineEditor.populate(sd);
    }

    public void grab(ScriptDescriptor sd) throws IllegalArgumentException, IllegalStateException {
        Assert.assertArgNotNull(sd, "sd");
        if (this.tfId.getText().trim().isEmpty()) {
            throw new IllegalStateException("id must not be empty or consists of white space only");
        }
        if (this.tfScriptFile.getText().trim().isEmpty()) {
            throw new IllegalStateException("display name must not be empty or consists of white space only");
        }
        sd.setId(this.tfId.getText());
        sd.setDisplayName(this.tfDisplayName.getText());
        sd.setScriptFile(new File(this.tfScriptFile.getText().trim()));
        this.pnlScriptEngineEditor.grab(sd);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private class ScriptingEngineEditorPanel
    extends JPanel {
        private JRadioButton rbDeriveFromFileName;
        private JRadioButton rbManuallySelectScriptEngine;
        private ButtonGroup bgMethodToSelectScriptEngine;
        private JComboBox cbScriptEngines;
        private JPanel pnlSelectScriptEngine;
        private HtmlPanel pnlAutomaticallyDeriveEngine;

        public ScriptingEngineEditorPanel() {
            this.build();
        }

        public void populate(ScriptDescriptor sd) {
            if (sd == null) {
                this.rbDeriveFromFileName.setSelected(true);
            } else if (sd.getScriptEngineName() == null) {
                this.rbDeriveFromFileName.setSelected(true);
            } else {
                this.rbManuallySelectScriptEngine.setSelected(true);
                this.cbScriptEngines.getModel().setSelectedItem(ScriptEngineProvider.getInstance().getScriptFactoryByName(sd.getScriptEngineName()));
            }
        }

        public void grab(ScriptDescriptor sd) throws IllegalArgumentException {
            Assert.assertArgNotNull(sd, "sd");
            if (this.rbDeriveFromFileName.isSelected()) {
                sd.setScriptEngineName(null);
            } else if (this.cbScriptEngines.getSelectedItem() == null) {
                sd.setScriptEngineName(null);
            } else {
                ScriptEngineFactory f = (ScriptEngineFactory)this.cbScriptEngines.getSelectedItem();
                sd.setScriptEngineName(f.getEngineName());
            }
        }

        public void refreshAutomaticallyDerivedScriptingEngine() {
            String file;
            String msg = I18n.tr((String)"Automatically derive a script engine from the file name.");
            if (this.rbDeriveFromFileName.isSelected() && !(file = ScriptDescriptorEditorDialog.this.tfScriptFile.getText()).trim().isEmpty()) {
                ScriptEngine engine = ScriptEngineProvider.getInstance().getEngineForFile(new File(file));
                msg = engine == null ? msg + "<br>\n" + "<font color=\"red\">" + I18n.tr((String)"No scripting engine found for file ''{0}''.", (Object[])new Object[]{file}) + "</font>" : msg + "<br>\n" + I18n.tr((String)"Using scripting engine <strong>{0}</strong>.", (Object[])new Object[]{engine.getFactory().getEngineName()});
            }
            this.pnlAutomaticallyDeriveEngine.setText("<html>" + msg + "</html>");
        }

        protected void build() {
            this.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Script Engine")));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = GridBagConstraintBuilder.gbc().cell(0, 0).weight(0.0, 0.0).anchor(18).constraints();
            this.rbDeriveFromFileName = new JRadioButton();
            this.add((Component)this.rbDeriveFromFileName, gbc);
            gbc = GridBagConstraintBuilder.gbc().cell(1, 0).weight(1.0, 0.0).anchor(18).constraints();
            this.pnlAutomaticallyDeriveEngine = new HtmlPanel("");
            this.add((Component)this.pnlAutomaticallyDeriveEngine, gbc);
            gbc = GridBagConstraintBuilder.gbc().cell(0, 1).weight(0.0, 0.0).anchor(18).constraints();
            this.rbManuallySelectScriptEngine = new JRadioButton();
            this.add((Component)this.rbManuallySelectScriptEngine, gbc);
            this.pnlSelectScriptEngine = new JPanel(new GridBagLayout());
            gbc = GridBagConstraintBuilder.gbc().cell(0, 0, 2, 1).weight(1.0, 0.0).anchor(18).constraints();
            this.pnlSelectScriptEngine.add((Component)new HtmlPanel(I18n.tr((String)"Select one of the available script engines for executing this script.")), gbc);
            gbc = GridBagConstraintBuilder.gbc().cell(0, 1).weight(0.0, 0.0).anchor(18).borderright(5).constraints();
            this.pnlSelectScriptEngine.add((Component)new JLabel(I18n.tr((String)"Script engines:")), gbc);
            gbc = GridBagConstraintBuilder.gbc().cell(1, 1).weight(0.0, 0.0).anchor(18).constraints();
            this.cbScriptEngines = new JComboBox(new ScriptEngineComboBoxModel());
            this.pnlSelectScriptEngine.add(this.cbScriptEngines, gbc);
            this.cbScriptEngines.setRenderer(new ScriptEngineCellRenderer());
            this.cbScriptEngines.setToolTipText(I18n.tr((String)"Choose a script engine"));
            gbc = GridBagConstraintBuilder.gbc().cell(0, 2, 2, 1).weight(1.0, 0.0).constraints();
            this.pnlSelectScriptEngine.add((Component)new JPanel(), gbc);
            gbc = GridBagConstraintBuilder.gbc().cell(1, 1).weight(1.0, 0.0).anchor(18).constraints();
            this.add((Component)this.pnlSelectScriptEngine, gbc);
            this.bgMethodToSelectScriptEngine = new ButtonGroup();
            this.bgMethodToSelectScriptEngine.add(this.rbDeriveFromFileName);
            this.bgMethodToSelectScriptEngine.add(this.rbManuallySelectScriptEngine);
            RadioToggleListener l = new RadioToggleListener();
            this.rbDeriveFromFileName.addItemListener(l);
            this.rbManuallySelectScriptEngine.addItemListener(l);
            this.rbDeriveFromFileName.setSelected(true);
            this.refreshAutomaticallyDerivedScriptingEngine();
        }

        protected void setEnabled(Container parent, boolean enabled) {
            if (parent == null) {
                return;
            }
            parent.setEnabled(enabled);
            for (Component c : parent.getComponents()) {
                if (c instanceof Component) {
                    c.setEnabled(enabled);
                    continue;
                }
                this.setEnabled((Container)c, enabled);
            }
        }

        class RadioToggleListener
        implements ItemListener {
            RadioToggleListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object source = e.getSource();
                if (source == ScriptingEngineEditorPanel.this.rbDeriveFromFileName) {
                    if (e.getStateChange() == 1) {
                        ScriptingEngineEditorPanel.this.setEnabled(ScriptingEngineEditorPanel.this.pnlSelectScriptEngine, false);
                    }
                } else if (source == ScriptingEngineEditorPanel.this.rbManuallySelectScriptEngine && e.getStateChange() == 1) {
                    ScriptingEngineEditorPanel.this.setEnabled(ScriptingEngineEditorPanel.this.pnlSelectScriptEngine, true);
                }
                ScriptingEngineEditorPanel.this.refreshAutomaticallyDerivedScriptingEngine();
            }
        }
    }

    private class SelectScriptFileAction
    extends AbstractAction {
        public SelectScriptFileAction() {
            this.putValue("SmallIcon", ImageProvider.get((String)"open"));
            this.putValue("ShortDescription", I18n.tr((String)"Launch file selection dialog"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int ret;
            String fileName = ScriptDescriptorEditorDialog.this.tfScriptFile.getText().trim();
            File currentFile = null;
            if (!fileName.isEmpty()) {
                currentFile = new File(fileName);
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(I18n.tr((String)"Select a script"));
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (currentFile != null) {
                chooser.setCurrentDirectory(currentFile);
                chooser.setSelectedFile(currentFile);
            }
            if ((ret = chooser.showOpenDialog(ScriptDescriptorEditorDialog.this)) != 0) {
                return;
            }
            currentFile = chooser.getSelectedFile();
            ScriptDescriptorEditorDialog.this.tfScriptFile.setText(currentFile.toString());
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            ScriptDescriptorEditorDialog.this.tfDisplayName.requestFocusInWindow();
            ScriptDescriptorEditorDialog.this.canceled = false;
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel"));
            this.putValue("ShortDescription", I18n.tr((String)"Cancel and close dialog"));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptDescriptorEditorDialog.this.canceled = true;
            ScriptDescriptorEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction
    implements DocumentListener {
        public OKAction() {
            this.putValue("Name", I18n.tr((String)"OK"));
            this.putValue("ShortDescription", I18n.tr((String)"Accept script descriptor and close dialog"));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptDescriptorEditorDialog.this.canceled = false;
            ScriptDescriptorEditorDialog.this.setVisible(false);
        }

        protected void updateEnabledState() {
            if (ScriptDescriptorEditorDialog.this.tfId.getText().trim().isEmpty()) {
                this.setEnabled(false);
                return;
            }
            if (ScriptDescriptorEditorDialog.this.tfScriptFile.getText().trim().isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }
    }

    private class GenerateIdAction
    extends AbstractAction {
        public GenerateIdAction() {
            this.putValue("SmallIcon", ImageProvider.get((String)"new"));
            this.putValue("ShortDescription", I18n.tr((String)"Generate a globally unique ID"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptDescriptorEditorDialog.this.tfId.setText(UUID.randomUUID().toString());
        }
    }
}

