/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.preferences;

import java.io.File;
import java.text.MessageFormat;
import java.util.UUID;
import javax.swing.KeyStroke;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.openstreetmap.josm.plugins.scripting.util.Assert;

@XmlType(name="scriptType")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ScriptDescriptor {
    @XmlAttribute(name="id", required=true)
    @XmlJavaTypeAdapter(value=IdAdapter.class)
    @XmlID
    private String id = UUID.randomUUID().toString();
    @XmlAttribute(name="displayName", required=false)
    private String displayName;
    @XmlAttribute(name="file", required=true)
    @XmlJavaTypeAdapter(value=FileAdapter.class)
    private File scriptFile;
    @XmlAttribute(name="engine", required=false)
    private String scriptEngineName = null;
    @XmlAttribute(name="shortcut", required=false)
    @XmlJavaTypeAdapter(value=KeyStrokeAdapter.class)
    private KeyStroke shortCut;
    @XmlAttribute(name="overrideShortcut", required=false)
    private boolean shortCutOverride = false;

    public String getId() {
        return this.id;
    }

    public void setId(String id) throws IllegalArgumentException {
        Assert.assertArgNotNull(id, "id");
        Assert.assertArg(!id.trim().isEmpty(), "id must not consist of white space only. Got ''{0}''", id);
        this.id = id.trim();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) throws IllegalArgumentException {
        Assert.assertArgNotNull(scriptFile, "scriptFile");
        Assert.assertArg(scriptFile.isFile(), "Expected a file, got a directory. Got ''{0}''", scriptFile.toString());
        this.scriptFile = scriptFile;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public KeyStroke getShortCut() {
        return this.shortCut;
    }

    public void setShortCut(KeyStroke shortCut) {
        this.shortCut = shortCut;
    }

    public boolean isShortCutOverride() {
        return this.shortCutOverride;
    }

    public void setShortCutOverride(boolean shortCutOverride) {
        this.shortCutOverride = shortCutOverride;
    }

    private static class IdAdapter
    extends XmlAdapter<String, String> {
        private IdAdapter() {
        }

        public String unmarshal(String v) throws Exception {
            if ((v = v.trim()).isEmpty()) {
                throw new Exception(MessageFormat.format("Attribute ''{0}'' must not be empty or consist of white space only", "id"));
            }
            return v;
        }

        public String marshal(String v) throws Exception {
            return v.trim();
        }
    }

    private static class KeyStrokeAdapter
    extends XmlAdapter<String, KeyStroke> {
        private KeyStrokeAdapter() {
        }

        public KeyStroke unmarshal(String v) throws Exception {
            KeyStroke ks = KeyStroke.getKeyStroke(v);
            if (ks == null) {
                throw new Exception(MessageFormat.format("Failed to unmarshal key stroke from ''{0}''", v));
            }
            return ks;
        }

        public String marshal(KeyStroke v) throws Exception {
            if (v == null) {
                return null;
            }
            return v.toString();
        }
    }

    private static class FileAdapter
    extends XmlAdapter<String, File> {
        private FileAdapter() {
        }

        public File unmarshal(String v) throws Exception {
            return new File(v);
        }

        public String marshal(File v) throws Exception {
            if (v == null) {
                return null;
            }
            return v.getAbsolutePath();
        }
    }
}

