/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarServiceProvider {
    private static final Logger LOG = Logger.getLogger(JarServiceProvider.class.getName());

    private JarServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getServiceProviders(Class cls) throws IOException {
        ArrayList<Object> l = new ArrayList<Object>();
        ClassLoader cl = JarServiceProvider.class.getClassLoader();
        ClassLoader classLoader = cl = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        if (cl != null) {
            String serviceFile = "META-INF/services/" + cls.getName();
            Enumeration<URL> e = cl.getResources(serviceFile);
            while (e.hasMoreElements()) {
                URL u = e.nextElement();
                InputStream is = u.openStream();
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                    String str = null;
                    while ((str = br.readLine()) != null) {
                        int commentStartIdx = str.indexOf("#");
                        if (commentStartIdx != -1) {
                            str = str.substring(0, commentStartIdx);
                        }
                        if ((str = str.trim()).length() == 0) continue;
                        try {
                            Object obj = cl.loadClass(str).newInstance();
                            l.add(obj);
                        }
                        catch (Exception ex) {
                            LOG.warning("Could not load: " + str);
                            LOG.warning(ex.getMessage());
                        }
                    }
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
        }
        return l;
    }

    public static Properties readProperties(Class clazz) {
        return JarServiceProvider.readProperties(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String name) {
        ClassLoader cl = JarServiceProvider.class.getClassLoader();
        cl = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        Properties props = new Properties();
        if (cl != null) {
            InputStream is = null;
            try {
                String serviceFile = "META-INF/services/" + name.toLowerCase() + ".properties";
                URL loc = cl.getResource(serviceFile);
                if (loc != null) {
                    is = loc.openStream();
                    props.load(is);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
        return props;
    }

    public static Map<String, String> readStringsMap(String name) {
        Properties props = JarServiceProvider.readProperties(name);
        HashMap<String, String> map = new HashMap<String, String>();
        if (props != null) {
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                map.put(e.getKey().toString(), e.getValue().toString());
            }
        }
        return map;
    }
}

