/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.Markers;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class PairsMarker
implements CaretListener,
SyntaxComponent {
    public static final String PROPERTY_COLOR = "PairMarker.Color";
    private JTextComponent pane;
    private Markers.SimpleMarker marker;

    @Override
    public void caretUpdate(CaretEvent e) {
        this.removeMarkers();
        int pos = e.getDot();
        SyntaxDocument doc = ActionUtils.getSyntaxDocument(this.pane);
        Token token = doc.getTokenAt(pos);
        if (token != null && token.pairValue != 0) {
            Markers.markToken(this.pane, token, this.marker);
            Token other = doc.getPairFor(token);
            if (other != null) {
                Markers.markToken(this.pane, other, this.marker);
            }
        }
    }

    public void removeMarkers() {
        Markers.removeMarkers(this.pane, this.marker);
    }

    @Override
    public void config(Configuration config, String prefix) {
        Color markerColor = new Color(config.getPrefixInteger(prefix, PROPERTY_COLOR, 0xEEEE33));
        this.marker = new Markers.SimpleMarker(markerColor);
    }

    @Override
    public void install(JEditorPane editor) {
        this.pane = editor;
        this.pane.addCaretListener(this);
    }

    @Override
    public void deinstall(JEditorPane editor) {
        this.pane.removeCaretListener(this);
        this.removeMarkers();
    }
}

