/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class UnindentAction
extends TextAction
implements SyntaxAction {
    public UnindentAction() {
        super("UNINDENT");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        Integer tabStop = (Integer)target.getDocument().getProperty("tabSize");
        String indent = ActionUtils.SPACES.substring(0, tabStop);
        if (target != null) {
            String[] lines = ActionUtils.getSelectedLines(target);
            int start = target.getSelectionStart();
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                if (line.startsWith(indent)) {
                    sb.append(line.substring(indent.length()));
                } else if (line.startsWith("\t")) {
                    sb.append(line.substring(1));
                } else {
                    sb.append(line);
                }
                sb.append('\n');
            }
            target.replaceSelection(sb.toString());
            target.select(start, start + sb.length());
        }
    }

    @Override
    public void config(Configuration config, String prefix, String name) {
    }

    @Override
    public TextAction getAction(String key) {
        return this;
    }
}

