/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class IndentAction
extends DefaultEditorKit.InsertTabAction
implements SyntaxAction {
    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null) {
            String selected = target.getSelectedText();
            if (selected == null) {
                PlainDocument pDoc = (PlainDocument)target.getDocument();
                Integer tabStop = (Integer)pDoc.getProperty("tabSize");
                int lineStart = pDoc.getParagraphElement(target.getCaretPosition()).getStartOffset();
                int column = target.getCaretPosition() - lineStart;
                int needed = tabStop - column % tabStop;
                target.replaceSelection(ActionUtils.SPACES.substring(0, needed));
            } else {
                String[] lines = ActionUtils.getSelectedLines(target);
                int start = target.getSelectionStart();
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append('\t');
                    sb.append(line);
                    sb.append('\n');
                }
                target.replaceSelection(sb.toString());
                target.select(start, start + sb.length());
            }
        }
    }

    @Override
    public void config(Configuration config, String prefix, String name) {
    }

    @Override
    public TextAction getAction(String key) {
        return this;
    }
}

