/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoManager;
import jsyntaxpane.CompoundUndoManager;
import jsyntaxpane.Lexer;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public class SyntaxDocument
extends PlainDocument {
    Lexer lexer;
    List<Token> tokens;
    UndoManager undo = new CompoundUndoManager();
    private static final Logger log = Logger.getLogger(SyntaxDocument.class.getName());

    public SyntaxDocument(Lexer lexer) {
        this.putProperty("tabSize", 4);
        this.lexer = lexer;
        this.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                if (evt.getEdit().isSignificant()) {
                    SyntaxDocument.this.undo.addEdit(evt.getEdit());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parse() {
        ArrayList<Token> toks;
        block9: {
            if (this.lexer == null) {
                this.tokens = null;
                return;
            }
            toks = new ArrayList<Token>(this.getLength() / 10);
            long ts = System.nanoTime();
            int len = this.getLength();
            try {
                Token token;
                Segment seg = new Segment();
                this.getText(0, this.getLength(), seg);
                CharArrayReader reader = new CharArrayReader(seg.array, seg.offset, seg.count);
                this.lexer.yyreset(reader);
                while ((token = this.lexer.yylex()) != null) {
                    toks.add(token);
                }
                if (!log.isLoggable(Level.FINEST)) break block9;
            }
            catch (BadLocationException ex) {
                block10: {
                    log.log(Level.SEVERE, null, ex);
                    if (!log.isLoggable(Level.FINEST)) break block10;
                    log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                }
                this.tokens = toks;
            }
            catch (IOException ex2) {
                block11: {
                    log.log(Level.SEVERE, null, ex2);
                    if (!log.isLoggable(Level.FINEST)) break block11;
                    {
                        catch (Throwable throwable) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                            }
                            this.tokens = toks;
                            throw throwable;
                        }
                    }
                    log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                }
                this.tokens = toks;
            }
            log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
        }
        this.tokens = toks;
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent e) {
        this.parse();
        super.fireChangedUpdate(e);
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        this.parse();
        super.fireInsertUpdate(e);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        this.parse();
        super.fireRemoveUpdate(e);
    }

    @Override
    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        this.parse();
        super.fireUndoableEditUpdate(e);
    }

    public void replaceToken(Token token, String replacement) {
        try {
            this.replace(token.start, token.length, replacement, null);
        }
        catch (BadLocationException ex) {
            log.log(Level.WARNING, "unable to replace token: " + token, ex);
        }
    }

    public Iterator<Token> getTokens(int start, int end) {
        return new TokenIterator(start, end);
    }

    public Token getTokenAt(int pos) {
        if (this.tokens == null || this.tokens.isEmpty() || pos > this.getLength()) {
            return null;
        }
        Token tok = null;
        Token tKey = new Token(TokenType.DEFAULT, pos, 1);
        int ndx = Collections.binarySearch(this.tokens, tKey);
        if (ndx < 0) {
            ndx = -ndx - 1 - 1 < 0 ? 0 : -ndx - 1 - 1;
            Token t = this.tokens.get(ndx);
            if (t.start <= pos && pos <= t.end()) {
                tok = t;
            }
        } else {
            tok = this.tokens.get(ndx);
        }
        return tok;
    }

    public Token getPairFor(Token t) {
        if (t == null || t.pairValue == 0) {
            return null;
        }
        Token p = null;
        int ndx = this.tokens.indexOf(t);
        int w = t.pairValue;
        int direction = t.pairValue > 0 ? 1 : -1;
        boolean done = false;
        int v = Math.abs(t.pairValue);
        while (!done && (ndx += direction) >= 0 && ndx < this.tokens.size()) {
            Token current = this.tokens.get(ndx);
            if (Math.abs(current.pairValue) != v || (w += current.pairValue) != 0) continue;
            p = current;
            done = true;
        }
        return p;
    }

    public void doUndo() {
        if (this.undo.canUndo()) {
            this.undo.undo();
            this.parse();
        }
    }

    public void doRedo() {
        if (this.undo.canRedo()) {
            this.undo.redo();
            this.parse();
        }
    }

    @Deprecated
    public int getIndexOf(String search, int start) {
        int flag = 16;
        Pattern pattern = Pattern.compile(search, flag);
        return this.getIndexOf(pattern, start);
    }

    @Deprecated
    public int getIndexOf(Pattern pattern, int start) {
        int ndx = -1;
        if (pattern == null || this.getLength() == 0) {
            return -1;
        }
        try {
            Segment segment = new Segment();
            this.getText(start, this.getLength() - start, segment);
            Matcher m = pattern.matcher(segment);
            if (m.find()) {
                ndx = m.start() + start;
            }
        }
        catch (BadLocationException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        return ndx;
    }

    public Matcher getMatcher(Pattern pattern) {
        return this.getMatcher(pattern, 0, this.getLength());
    }

    public Matcher getMatcher(Pattern pattern, int start) {
        return this.getMatcher(pattern, start, this.getLength() - start);
    }

    public Matcher getMatcher(Pattern pattern, int start, int length) {
        Matcher matcher = null;
        if (this.getLength() == 0) {
            return null;
        }
        try {
            Segment seg = new Segment();
            this.getText(start, length, seg);
            matcher = pattern.matcher(seg);
        }
        catch (BadLocationException ex) {
            log.log(Level.SEVERE, "Requested offset: " + ex.offsetRequested(), ex);
        }
        return matcher;
    }

    public void clearUndos() {
        this.undo.discardAllEdits();
    }

    public String getLineAt(int pos) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        Segment seg = new Segment();
        this.getText(e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), seg);
        char last = seg.last();
        if (last == '\n' || last == '\r') {
            return ((Object)seg.subSequence(0, seg.length() - 1)).toString();
        }
        return seg.toString();
    }

    public void removeLineAt(int pos) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        this.remove(e.getStartOffset(), this.getElementLength(e));
    }

    public void replaceLineAt(int pos, String newLines) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        this.replace(e.getStartOffset(), this.getElementLength(e), newLines, null);
    }

    private int getElementLength(Element e) {
        int end = e.getEndOffset();
        if (end >= this.getLength() - 1) {
            --end;
        }
        return end - e.getStartOffset();
    }

    public synchronized String getUncommentedText(int aStart, int anEnd) {
        this.readLock();
        StringBuilder result = new StringBuilder();
        Iterator<Token> iter = this.getTokens(aStart, anEnd);
        while (iter.hasNext()) {
            Token t = iter.next();
            if (TokenType.COMMENT == t.type || TokenType.COMMENT2 == t.type) continue;
            result.append(t.getText(this));
        }
        this.readUnlock();
        return result.toString();
    }

    public int getLineStartOffset(int pos) {
        return this.getParagraphElement(pos).getStartOffset();
    }

    public int getLineEndOffset(int pos) {
        int end = 0;
        end = this.getParagraphElement(pos).getEndOffset();
        if (end >= this.getLength()) {
            end = this.getLength();
        }
        return end;
    }

    public int getLineCount() {
        Element e = this.getDefaultRootElement();
        int cnt = e.getElementCount();
        return cnt;
    }

    public int getLineNumberAt(int pos) {
        int lineNr = this.getDefaultRootElement().getElementIndex(pos);
        return lineNr;
    }

    public String toString() {
        return "SyntaxDocument(" + this.lexer + ", " + (this.tokens == null ? 0 : this.tokens.size()) + " tokens)@" + this.hashCode();
    }

    class TokenIterator
    implements ListIterator<Token> {
        int start;
        int end;
        int ndx = 0;

        private TokenIterator(int start, int end) {
            this.start = start;
            this.end = end;
            if (SyntaxDocument.this.tokens != null && !SyntaxDocument.this.tokens.isEmpty()) {
                Token token = new Token(TokenType.COMMENT, start, end - start);
                this.ndx = Collections.binarySearch(SyntaxDocument.this.tokens, token);
                if (this.ndx < 0) {
                    this.ndx = -this.ndx - 1 - 1 < 0 ? 0 : -this.ndx - 1 - 1;
                    Token t = SyntaxDocument.this.tokens.get(this.ndx);
                    if (t.end() <= start) {
                        ++this.ndx;
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (SyntaxDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx >= SyntaxDocument.this.tokens.size()) {
                return false;
            }
            Token t = SyntaxDocument.this.tokens.get(this.ndx);
            return t.start < this.end;
        }

        @Override
        public Token next() {
            return SyntaxDocument.this.tokens.get(this.ndx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            if (SyntaxDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx <= 0) {
                return false;
            }
            Token t = SyntaxDocument.this.tokens.get(this.ndx);
            return t.end() > this.start;
        }

        @Override
        public Token previous() {
            return SyntaxDocument.this.tokens.get(this.ndx--);
        }

        @Override
        public int nextIndex() {
            return this.ndx + 1;
        }

        @Override
        public int previousIndex() {
            return this.ndx - 1;
        }

        @Override
        public void set(Token e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Token e) {
            throw new UnsupportedOperationException();
        }
    }
}

