/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing;

import com.innovant.josm.jrt.core.PreferencesKeys;
import com.innovant.josm.jrt.osm.OsmEdge;
import com.innovant.josm.plugin.routing.RoutingModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.ImageProvider;

public class RoutingLayer
extends Layer {
    static Logger logger = Logger.getLogger(RoutingLayer.class);
    private static final double ARROW_PHI = Math.toRadians(20.0);
    private RoutingModel routingModel;
    private Icon startIcon;
    private Icon middleIcon;
    private Icon endIcon;
    private OsmDataLayer dataLayer;

    public RoutingLayer(String name, OsmDataLayer dataLayer) {
        super(name);
        logger.debug("Creating Routing Layer...");
        if (this.startIcon == null) {
            this.startIcon = ImageProvider.get((String)"routing", (String)"startflag");
        }
        if (this.middleIcon == null) {
            this.middleIcon = ImageProvider.get((String)"routing", (String)"middleflag");
        }
        if (this.endIcon == null) {
            this.endIcon = ImageProvider.get((String)"routing", (String)"endflag");
        }
        this.dataLayer = dataLayer;
        this.routingModel = new RoutingModel(dataLayer.data);
        logger.debug("Routing Layer created.");
        this.routingModel.routingGraph.createGraph();
        Main.map.repaint();
    }

    public RoutingModel getRoutingModel() {
        return this.routingModel;
    }

    public OsmDataLayer getDataLayer() {
        return this.dataLayer;
    }

    public final Node getNearestHighwayNode(Point p) {
        Node nearest = null;
        int snapDistance = NavigatableComponent.PROP_SNAP_DISTANCE.get();
        double minDist = 0.0;
        for (Way w : this.dataLayer.data.getWays()) {
            if (w.isDeleted() || w.isIncomplete() || w.get("highway") == null) continue;
            for (Node n : w.getNodes()) {
                Point P;
                double dist;
                if (n.isDeleted() || n.isIncomplete() || !((dist = p.distance(P = Main.map.mapView.getPoint(n))) < (double)snapDistance) || nearest != null && !(dist < minDist)) continue;
                nearest = n;
                minDist = dist;
            }
        }
        return nearest;
    }

    public Icon getIcon() {
        ImageIcon icon = ImageProvider.get((String)"layer", (String)"routing_small");
        return icon;
    }

    public Object getInfoComponent() {
        String info = "<html><body>Graph Vertex: " + this.routingModel.routingGraph.getVertexCount() + "<br/>" + "Graph Edges: " + this.routingModel.routingGraph.getEdgeCount() + "<br/>" + "</body>" + "</html>";
        return info;
    }

    public Action[] getMenuEntries() {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(LayerListDialog.getInstance().createShowHideLayerAction());
        components.add(LayerListDialog.getInstance().createDeleteLayerAction());
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new RenameLayerAction(this.getAssociatedFile(), (Layer)this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new LayerListPopup.InfoAction((Layer)this));
        return components.toArray(new Action[0]);
    }

    public String getToolTipText() {
        String tooltip = String.valueOf(this.routingModel.routingGraph.getVertexCount()) + " vertices, " + this.routingModel.routingGraph.getEdgeCount() + " edges";
        return tooltip;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        String colorString;
        boolean isActiveLayer = mv.getActiveLayer().equals((Object)this);
        List<Node> nodes = this.routingModel.getSelectedNodes();
        if (isActiveLayer) {
            if (Main.pref.hasKey(PreferencesKeys.KEY_ACTIVE_ROUTE_COLOR.key)) {
                colorString = Main.pref.get(PreferencesKeys.KEY_ACTIVE_ROUTE_COLOR.key);
            } else {
                colorString = ColorHelper.color2html((Color)Color.RED);
                Main.pref.put(PreferencesKeys.KEY_ACTIVE_ROUTE_COLOR.key, colorString);
            }
        } else if (Main.pref.hasKey(PreferencesKeys.KEY_INACTIVE_ROUTE_COLOR.key)) {
            colorString = Main.pref.get(PreferencesKeys.KEY_INACTIVE_ROUTE_COLOR.key);
        } else {
            colorString = ColorHelper.color2html((Color)Color.decode("#dd2222"));
            Main.pref.put(PreferencesKeys.KEY_INACTIVE_ROUTE_COLOR.key, colorString);
        }
        Color color = ColorHelper.html2color((String)colorString);
        String widthString = Main.pref.get(PreferencesKeys.KEY_ROUTE_WIDTH.key);
        if (widthString.length() == 0) {
            widthString = "2";
        }
        int width = Integer.parseInt(widthString);
        if (isActiveLayer && this.routingModel != null && this.routingModel.routingGraph != null && this.routingModel.routingGraph.getGraph() != null) {
            Color color2 = ColorHelper.html2color((String)"#00ff00");
            Set<OsmEdge> graphEdges = this.routingModel.routingGraph.getGraph().edgeSet();
            OsmEdge firstedge = (OsmEdge)graphEdges.toArray()[0];
            Point from = mv.getPoint(firstedge.fromEastNorth());
            g.drawRect(from.x - 4, from.y + 4, from.x + 4, from.y - 4);
            for (OsmEdge edge : graphEdges) {
                this.drawGraph(g, mv, edge, color2, width);
            }
        }
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        List<OsmEdge> routeEdges = this.routingModel.getRouteEdges();
        if (routeEdges != null) {
            for (OsmEdge edge : routeEdges) {
                this.drawEdge(g, mv, edge, color, width, true);
            }
        }
        Node node = nodes.get(0);
        Point screen = mv.getPoint(node);
        this.startIcon.paintIcon((Component)mv, g, screen.x - this.startIcon.getIconWidth() / 2, screen.y - this.startIcon.getIconHeight());
        int index = 1;
        while (index < nodes.size() - 1) {
            node = nodes.get(index);
            screen = mv.getPoint(node);
            this.middleIcon.paintIcon((Component)mv, g, screen.x - this.startIcon.getIconWidth() / 2, screen.y - this.middleIcon.getIconHeight());
            ++index;
        }
        if (nodes.size() > 1) {
            node = nodes.get(nodes.size() - 1);
            screen = mv.getPoint(node);
            this.endIcon.paintIcon((Component)mv, g, screen.x - this.startIcon.getIconWidth() / 2, screen.y - this.endIcon.getIconHeight());
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Node node : this.routingModel.getSelectedNodes()) {
            v.visit(node);
        }
    }

    public void destroy() {
        this.routingModel.reset();
    }

    private void drawEdge(Graphics g, MapView mv, OsmEdge edge, Color col, int width, boolean showDirection) {
        g.setColor(col);
        Point from = mv.getPoint(edge.fromEastNorth());
        Point to = mv.getPoint(edge.toEastNorth());
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(width));
        g2d.drawLine(from.x, from.y, to.x, to.y);
        if (showDirection) {
            double t = Math.atan2(to.y - from.y, to.x - from.x) + Math.PI;
            g.drawLine(to.x, to.y, (int)((double)to.x + 10.0 * Math.cos(t - ARROW_PHI)), (int)((double)to.y + 10.0 * Math.sin(t - ARROW_PHI)));
            g.drawLine(to.x, to.y, (int)((double)to.x + 10.0 * Math.cos(t + ARROW_PHI)), (int)((double)to.y + 10.0 * Math.sin(t + ARROW_PHI)));
        }
        g2d.setStroke(oldStroke);
    }

    private void drawGraph(Graphics g, MapView mv, OsmEdge edge, Color col, int width) {
        g.setColor(col);
        Point from = mv.getPoint(edge.fromEastNorth());
        Point to = mv.getPoint(edge.toEastNorth());
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(width));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawLine(from.x, from.y, to.x, to.y);
        g2d.drawRect(to.x - 4, to.y + 4, 4, 4);
        g2d.setStroke(oldStroke);
    }
}

