/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

class FastDrawingMode
extends MapMode
implements MapViewPaintable,
AWTEventListener {
    private static final String SIMPLIFYMODE_MESSAGE = "Press Enter to simplify or save, Up/Down to tune simplification";
    private static final String DRAWINGMODE_MESSAGE = "Click or Click&drag to continue, Ctrl-Click to add fixed node, Shift-Click to start new line";
    private double maxDist;
    private double epsilonMult;
    private double minPixelsBetweenPoints;
    private double startingEps;
    private MapView mv;
    private ArrayList<LatLon> points = new ArrayList(100);
    private ArrayList<LatLon> simplePoints = new ArrayList(100);
    private String statusText;
    private boolean drawing;
    private boolean ctrl;
    private boolean shift;
    private boolean oldCtrl;
    private boolean oldShift;
    Set<LatLon> used;
    Set<LatLon> fixed = new HashSet<LatLon>();
    private double eps = this.startingEps;
    private final Stroke strokeForSimplified;
    private final Stroke strokeForOriginal = new BasicStroke();
    private boolean ready;
    private final Cursor cursorDraw;
    private final Cursor cursorCtrl;
    private final Cursor cursorShift;
    private final Cursor cursorReady;
    private final Cursor cursorNode;
    private boolean nearpoint;

    FastDrawingMode(MapFrame mapFrame) {
        super(I18n.tr((String)"FastDrawing"), "turbopen.png", I18n.tr((String)"Fast drawing mode"), Shortcut.registerShortcut((String)"mapmode:FastDraw", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Fast drawing mode")}), (int)84, (int)3), mapFrame, Cursor.getPredefinedCursor(0));
        this.strokeForSimplified = new BasicStroke(1.0f, 1, 2, 5.0f, new float[]{5.0f, 5.0f}, 0.0f);
        this.cursorDraw = ImageProvider.getCursor((String)"crosshair", null);
        this.cursorCtrl = ImageProvider.getCursor((String)"crosshair", (String)"fixed");
        this.cursorShift = ImageProvider.getCursor((String)"crosshair", (String)"new");
        this.cursorReady = ImageProvider.getCursor((String)"crosshair", (String)"ready");
        this.cursorNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.loadPrefs();
        this.mv = Main.map.mapView;
        if (FastDrawingMode.getCurrentDataSet() == null) {
            return;
        }
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        Main.map.mapView.setCursor(this.cursorDraw);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.savePrefs();
        Main.map.mapView.setCursor(this.cursorDraw);
        Main.map.mapView.repaint();
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(FastDrawingMode.getEditLayer() != null);
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.points.size() == 0) {
            return;
        }
        ArrayList<LatLon> pts = this.points;
        if (this.simplePoints != null && this.simplePoints.size() > 0) {
            pts = this.simplePoints;
            g.setStroke(this.strokeForSimplified);
        } else {
            g.setStroke(this.strokeForOriginal);
        }
        Point p1 = this.getPoint((LatLon)pts.get(0));
        g.setColor(Color.green);
        g.fillOval(p1.x - 3, p1.y - 3, 7, 7);
        if (pts.size() > 1) {
            for (int i = 0; i < pts.size() - 1; ++i) {
                g.setColor(Color.red);
                p1 = this.getPoint((LatLon)pts.get(i));
                LatLon pp2 = (LatLon)pts.get(i + 1);
                Point p2 = this.getPoint((LatLon)pts.get(i + 1));
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
                if (this.fixed.contains(pp2)) {
                    g.setColor(Color.green);
                    g.fillOval(p2.x - 3, p2.y - 3, 7, 7);
                    continue;
                }
                g.fillRect(p2.x - 1, p2.y - 1, 3, 3);
            }
        }
    }

    public void eventDispatched(AWTEvent event) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)event);
        if (event.getID() == 401) {
            this.doKeyEvent((KeyEvent)event);
        }
        this.updateCursor();
        Main.map.mapView.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        int idx = this.findClosestPoint(e.getX(), e.getY(), this.maxDist);
        if (idx == 0) {
            this.points.add(this.points.get(idx));
            this.drawing = false;
            this.ready = true;
            this.updateCursor();
            return;
        }
        if (this.shift) {
            this.newDrawing();
        }
        if (this.ready) {
            this.setStatusLine(I18n.tr((String)SIMPLIFYMODE_MESSAGE));
            return;
        }
        LatLon p = this.getLatLon(e);
        Node nd1 = this.getNearestNode(e.getPoint(), this.maxDist);
        if (nd1 != null) {
            p = nd1.getCoor();
            this.fixed.add(p);
        }
        this.drawing = true;
        this.points.add(p);
        if (this.ctrl) {
            this.fixed.add(p);
        }
        this.simplePoints = null;
        this.setStatusLine(I18n.tr((String)"Please move the mouse to draw new way"));
        Main.map.mapView.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.drawing = false;
        if (!this.ready) {
            this.setStatusLine(I18n.tr((String)DRAWINGMODE_MESSAGE) + I18n.tr((String)SIMPLIFYMODE_MESSAGE));
        }
        Main.map.mapView.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        boolean nearpoint2;
        if (!this.isEnabled()) {
            return;
        }
        Node nd1 = this.getNearestNode(e.getPoint(), this.maxDist);
        boolean bl = nearpoint2 = nd1 != null;
        if (this.nearpoint != nearpoint2) {
            this.nearpoint = nearpoint2;
            this.updateCursor();
        }
        if (!this.drawing) {
            return;
        }
        if (this.ready) {
            this.setStatusLine(I18n.tr((String)SIMPLIFYMODE_MESSAGE));
        }
        Point lastP = this.getPoint(this.points.get(this.points.size() - 1));
        if (this.nearpoint) {
            if (Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > 0.01) {
                this.points.add(nd1.getCoor());
                this.fixed.add(nd1.getCoor());
                Main.map.mapView.repaint();
            }
        } else if (Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > this.minPixelsBetweenPoints) {
            this.points.add(this.getLatLon(e));
            Main.map.mapView.repaint();
        }
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.statusText);
        Main.map.statusLine.repaint();
    }

    LatLon getLatLon(MouseEvent e) {
        return this.mv.getLatLon(e.getX(), e.getY());
    }

    Point getPoint(LatLon p) {
        return this.mv.getPoint(p);
    }

    public void newDrawing() {
        this.points.clear();
        this.used = null;
        this.fixed.clear();
        this.eps = this.startingEps;
        this.ready = false;
        this.simplePoints = null;
    }

    public void back() {
        if (this.points.size() == 0) {
            return;
        }
        this.points.remove(this.points.size() - 1);
        Main.map.mapView.repaint();
    }

    private void updateKeyModifiers(InputEvent e) {
        this.oldCtrl = this.ctrl;
        this.oldShift = this.shift;
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    private void doKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            if (this.simplePoints != null) {
                this.simplePoints = null;
                Main.map.mapView.repaint();
                this.eps = this.startingEps;
            }
            this.back();
        }
        if (e.getKeyCode() == 10) {
            if (this.simplePoints == null) {
                this.simplify(this.eps);
                this.setStatusLine(I18n.tr((String)SIMPLIFYMODE_MESSAGE));
            } else {
                this.saveAsWay();
            }
        }
        if (e.getKeyCode() == 40) {
            e.consume();
            this.changeEpsilon(this.epsilonMult);
        }
        if (e.getKeyCode() == 38) {
            e.consume();
            this.changeEpsilon(1.0 / this.epsilonMult);
        }
    }

    void changeEpsilon(double k) {
        this.eps *= k;
        this.setStatusLine(I18n.tr((String)"Eps={0}", (Object[])new Object[]{this.eps}));
        this.simplify(this.eps);
        Main.map.mapView.repaint();
    }

    private void simplify(double epsilon) {
        int n = this.points.size();
        if (n < 3) {
            return;
        }
        this.used = new HashSet<LatLon>(n);
        int start = 0;
        for (int i = 0; i < n; ++i) {
            LatLon p = this.points.get(i);
            if (!this.fixed.contains(p) && i != n - 1) continue;
            if (start < 0) {
                start = i;
                continue;
            }
            this.douglasPeucker(start, i, epsilon, 0);
        }
        this.simplePoints = new ArrayList(n);
        this.simplePoints.addAll(this.points);
        this.simplePoints.retainAll(this.used);
        Main.map.mapView.repaint();
        this.used = null;
    }

    private void douglasPeucker(int start, int end, double epsilon, int depth) {
        if (depth > 500) {
            return;
        }
        if (end - start < 1) {
            return;
        }
        LatLon first = this.points.get(start);
        LatLon last = this.points.get(end);
        Point firstp = this.getPoint(first);
        Point lastp = this.getPoint(last);
        this.used.add(first);
        this.used.add(last);
        if (end - start < 2) {
            return;
        }
        int farthest_node = -1;
        double farthest_dist = 0.0;
        ArrayList new_nodes = new ArrayList();
        double d = 0.0;
        for (int i = start + 1; i < end; ++i) {
            d = this.pointLineDistance(this.getPoint(this.points.get(i)), firstp, lastp);
            if (!(d > farthest_dist)) continue;
            farthest_dist = d;
            farthest_node = i;
        }
        if (farthest_dist > epsilon) {
            this.douglasPeucker(start, farthest_node, epsilon, depth + 1);
            this.douglasPeucker(farthest_node, end, epsilon, depth + 1);
        }
    }

    public double pointLineDistance(Point p1, Point p2, Point p3) {
        double x0 = p1.x;
        double y0 = p1.y;
        double x1 = p2.x;
        double y1 = p2.y;
        double x2 = p3.x;
        double y2 = p3.y;
        if (x2 == x1 && y2 == y1) {
            return Math.hypot(x1 - x0, y1 - y0);
        }
        return Math.abs((x2 - x1) * (y1 - y0) - (x1 - x0) * (y2 - y1)) / Math.hypot(x2 - x1, y2 - y1);
    }

    private void saveAsWay() {
        int n;
        ArrayList<LatLon> pts = this.points;
        if (this.simplePoints != null && this.simplePoints.size() > 0) {
            pts = this.simplePoints;
        }
        if ((n = pts.size()) == 0) {
            return;
        }
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        int i = 0;
        Way w = new Way();
        LatLon first = (LatLon)pts.get(0);
        Node firstNode = null;
        for (LatLon p : pts) {
            Node nd = null;
            if (this.fixed.contains(p)) {
                nd = Main.map.mapView.getNearestNode(this.getPoint(p), OsmPrimitive.isUsablePredicate);
            }
            if (nd == null) {
                if (i > 0 && p.equals((Object)first)) {
                    nd = firstNode;
                } else {
                    nd = new Node(p);
                    cmds.add(new AddCommand((OsmPrimitive)nd));
                }
            }
            if (nd.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot place node outside of the world."));
                return;
            }
            if (i == 0) {
                firstNode = nd;
            }
            w.addNode(nd);
            ++i;
        }
        cmds.add(new AddCommand((OsmPrimitive)w));
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Draw the way by mouse"), cmds);
        Main.main.undoRedo.add((Command)c);
        this.newDrawing();
        this.exitMode();
        FastDrawingMode.getCurrentDataSet().setSelected(new PrimitiveId[]{w});
        Main.map.selectSelectTool(false);
    }

    private int findClosestPoint(double x, double y, double d) {
        int n = this.points.size();
        int idx = -1;
        double minD = 1.0E10;
        for (int i = 0; i < n; ++i) {
            double dist = Math.sqrt(this.getPoint(this.points.get(i)).distanceSq(x, y));
            if (!(dist < d) || !(dist < minD)) continue;
            idx = i;
            minD = dist;
        }
        return idx;
    }

    private void setStatusLine(String tr) {
        this.statusText = tr;
        this.updateStatusLine();
    }

    void loadPrefs() {
        this.maxDist = Main.pref.getDouble("fastdraw.maxdist", 5.0);
        this.epsilonMult = Main.pref.getDouble("fastdraw.epsilonmult", 1.1);
        this.minPixelsBetweenPoints = Main.pref.getDouble("fastdraw.mindelta", 20.0);
        this.startingEps = Main.pref.getDouble("fastdraw.startingEps", 20.0);
    }

    void savePrefs() {
        Main.pref.putDouble("fastdraw.maxdist", Double.valueOf(this.maxDist));
        Main.pref.putDouble("fastdraw.epsilonmult", Double.valueOf(this.epsilonMult));
        Main.pref.putDouble("fastdraw.mindelta", Double.valueOf(this.minPixelsBetweenPoints));
        Main.pref.putDouble("fastdraw.startingEps", Double.valueOf(this.startingEps));
        try {
            Main.pref.save();
        }
        catch (IOException e) {
            System.err.println(I18n.tr((String)"Can not save preferences"));
        }
    }

    private void updateCursor() {
        if (this.shift) {
            Main.map.mapView.setCursor(this.cursorShift);
        } else if (this.ready) {
            Main.map.mapView.setCursor(this.cursorReady);
        } else if (this.ctrl) {
            Main.map.mapView.setCursor(this.cursorCtrl);
        } else if (this.nearpoint) {
            Main.map.mapView.setCursor(this.cursorCtrl);
        } else {
            Main.map.mapView.setCursor(this.cursorDraw);
        }
    }

    private Node getNearestNode(Point point, double maxDist) {
        Node nd = Main.map.mapView.getNearestNode(point, OsmPrimitive.isUsablePredicate);
        if (nd != null && this.getPoint(nd.getCoor()).distance(point) <= maxDist) {
            return nd;
        }
        return null;
    }
}

