/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAddedWaysAction
extends JosmAction {
    private int lastHash;
    private Command lastCmd;

    public SelectAddedWaysAction() {
        super(I18n.tr((String)"Select last added ways"), "seladdedways", I18n.tr((String)"Select last added ways"), Shortcut.registerShortcut((String)"tools:seladdedways", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Select last added ways"}), (int)90, (int)3, (int)8), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelecetAddedWays"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = SelectAddedWaysAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        SelectAddedWaysAction.getCurrentDataSet().clearSelection((Collection)selectedNodes);
        Command cmd = null;
        if (Main.main.undoRedo.commands == null) {
            return;
        }
        int num = Main.main.undoRedo.commands.size();
        if (num == 0) {
            return;
        }
        int k = 0;
        int idx = num - 1;
        do {
            if (selection != null && !selection.isEmpty() && ((Object)selection).hashCode() == this.lastHash) {
                idx = Main.main.undoRedo.commands.indexOf(this.lastCmd);
                idx = idx > 0 ? --idx : num - 1;
            }
            this.lastCmd = cmd = (Command)Main.main.undoRedo.commands.get(idx);
            Collection pp = cmd.getParticipatingPrimitives();
            HashSet<Way> ways = new HashSet<Way>(10);
            for (OsmPrimitive p : pp) {
                if (!(p instanceof Way) || p.isDeleted()) continue;
                ways.add((Way)p);
            }
            if (!ways.isEmpty()) {
                SelectAddedWaysAction.getCurrentDataSet().setSelected(ways);
                break;
            }
            HashSet<Node> nodes = new HashSet<Node>(10);
            for (OsmPrimitive p : pp) {
                if (!(p instanceof Node) || p.isDeleted()) continue;
                nodes.add((Node)p);
            }
            if (nodes.isEmpty()) continue;
            SelectAddedWaysAction.getCurrentDataSet().setSelected(nodes);
            break;
        } while (++k < num);
        this.lastCmd = cmd;
        this.lastHash = ((Object)SelectAddedWaysAction.getCurrentDataSet().getSelected()).hashCode();
    }

    protected void updateEnabledState() {
        if (SelectAddedWaysAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SelectAddedWaysAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(true);
    }
}

