/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.Messages;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.SeaMark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Buoy
extends SeaMark {
    private String Longname = "";
    private String Fixme = "";
    private String LMheight = "";
    private int BuoyIndex = 0;
    private int StyleIndex = 0;
    private boolean Region = false;
    private boolean Radar = false;
    private boolean Racon = false;
    private int RaType = 0;
    private String RaconGroup = "";
    private boolean Fog = false;
    private int FogSound = 0;
    private String FogGroup = "";
    private String FogPeriod = "";
    private boolean Fired = false;
    private String LitRef = "";
    private String LitInf = "";
    private String LitCat = "";
    private String LitMul = "";
    private boolean Sectored = false;
    private int SectorIndex = 0;
    private String[] LightChar = new String[10];
    private String[] LightColour = new String[10];
    private String[] LightGroup = new String[10];
    private String[] Height = new String[10];
    private String[] Range = new String[10];
    private String[] Sequence = new String[10];
    private String[] Bearing1 = new String[10];
    private String[] Bearing2 = new String[10];
    private String[] Radius = new String[10];
    private String[] LightPeriod = new String[10];
    private Node Node = null;
    private boolean TopMark = false;
    private int TopMarkIndex = 0;
    protected SmpDialogAction dlg = null;

    public abstract void setLightColour();

    public String getLongname() {
        return this.Longname;
    }

    public void setLongname(String name) {
        this.Longname = name;
    }

    public String getFixme() {
        return this.Fixme;
    }

    public void setFixme(String name) {
        this.Fixme = name;
    }

    public String getLMheight() {
        return this.LMheight;
    }

    public void setLMheight(String height) {
        this.LMheight = height;
    }

    public int getBuoyIndex() {
        return this.BuoyIndex;
    }

    public void setBuoyIndex(int buoyIndex) {
        this.BuoyIndex = buoyIndex;
    }

    public int getStyleIndex() {
        return this.StyleIndex;
    }

    public void setStyleIndex(int styleIndex) {
        this.StyleIndex = styleIndex;
    }

    public boolean getRegion() {
        return this.Region;
    }

    public void setRegion(boolean region) {
        this.Region = region;
    }

    public boolean hasRadar() {
        return this.Radar;
    }

    public void setRadar(boolean radar) {
        this.Radar = radar;
    }

    public boolean hasRacon() {
        return this.Racon;
    }

    public void setRacon(boolean racon) {
        this.Racon = racon;
    }

    public int getRaType() {
        return this.RaType;
    }

    public void setRaType(int type) {
        this.RaType = type;
    }

    public String getRaconGroup() {
        return this.RaconGroup;
    }

    public void setRaconGroup(String raconGroup) {
        this.RaconGroup = raconGroup;
    }

    public boolean hasFog() {
        return this.Fog;
    }

    public void setFog(boolean fog) {
        this.Fog = fog;
    }

    public int getFogSound() {
        return this.FogSound;
    }

    public void setFogSound(int sound) {
        this.FogSound = sound;
    }

    public String getFogGroup() {
        return this.FogGroup;
    }

    public void setFogGroup(String group) {
        this.FogGroup = group;
    }

    public String getFogPeriod() {
        return this.FogPeriod;
    }

    public void setFogPeriod(String period) {
        this.FogPeriod = period;
    }

    public boolean isFired() {
        return this.Fired;
    }

    public void setFired(boolean fired) {
        this.Fired = fired;
    }

    public String getLitRef() {
        return this.LitRef;
    }

    public void setLitRef(String ref) {
        this.LitRef = ref;
    }

    public String getLitInf() {
        return this.LitInf;
    }

    public void setLitInf(String inf) {
        this.LitInf = inf;
    }

    public String getLitCat() {
        return this.LitCat;
    }

    public void setLitCat(String cat) {
        this.LitCat = cat;
    }

    public String getLitMul() {
        return this.LitMul;
    }

    public void setLitMul(String mul) {
        this.LitMul = mul;
    }

    public boolean isSectored() {
        return this.Sectored;
    }

    public void setSectored(boolean sectored) {
        this.Sectored = sectored;
        if (sectored) {
            this.LightColour[0] = "";
        } else {
            this.setSectorIndex(0);
            this.setLightChar("");
            this.setLightColour("");
            this.setLightGroup("");
            this.setHeight("");
            this.setRange("");
            this.setBearing1("");
            this.setBearing2("");
            this.setRadius("");
            this.setSeq("");
        }
    }

    public int getSectorIndex() {
        return this.SectorIndex;
    }

    public void setSectorIndex(int sector) {
        this.SectorIndex = sector;
    }

    public String getLightChar() {
        if (this.LightChar[this.SectorIndex] == null) {
            return this.LightChar[0];
        }
        return this.LightChar[this.SectorIndex];
    }

    public void setLightChar(String lightChar) {
        if (this.SectorIndex == 0) {
            this.LightChar = new String[10];
            this.LightChar[0] = lightChar;
        } else if (this.LightChar[0].isEmpty()) {
            this.LightChar[this.SectorIndex] = lightChar;
        }
    }

    public String getLightColour() {
        if (this.LightColour[this.SectorIndex] == null) {
            return this.LightColour[0];
        }
        return this.LightColour[this.SectorIndex];
    }

    public void setLightColour(String lightColour) {
        this.LightColour[this.SectorIndex] = lightColour;
    }

    public String getLightGroup() {
        if (this.LightGroup[this.SectorIndex] == null) {
            return this.LightGroup[0];
        }
        return this.LightGroup[this.SectorIndex];
    }

    public void setLightGroup(String lightGroup) {
        if (this.SectorIndex == 0) {
            this.LightGroup = new String[10];
        }
        this.LightGroup[this.SectorIndex] = lightGroup;
    }

    protected void setLightGroup(Map<String, String> k) {
        String s = "";
        if (k.containsKey("seamark:light:group")) {
            s = k.get("seamark:light:group");
            this.setLightGroup(s);
        }
    }

    public String getHeight() {
        if (this.Height[this.SectorIndex] == null) {
            return this.Height[0];
        }
        return this.Height[this.SectorIndex];
    }

    public void setHeight(String height) {
        if (this.SectorIndex == 0) {
            this.Height = new String[10];
        }
        this.Height[this.SectorIndex] = height;
    }

    public String getRange() {
        if (this.Range[this.SectorIndex] == null) {
            return this.Range[0];
        }
        return this.Range[this.SectorIndex];
    }

    public void setRange(String range) {
        if (this.SectorIndex == 0) {
            this.Range = new String[10];
        }
        this.Range[this.SectorIndex] = range;
    }

    public String getSeq() {
        if (this.Sequence[this.SectorIndex] == null) {
            return this.Sequence[0];
        }
        return this.Sequence[this.SectorIndex];
    }

    public void setSeq(String seq) {
        if (this.SectorIndex == 0) {
            this.Sequence = new String[10];
        }
        this.Sequence[this.SectorIndex] = seq;
    }

    public String getBearing1() {
        if (this.Bearing1[this.SectorIndex] == null) {
            return this.Bearing1[0];
        }
        return this.Bearing1[this.SectorIndex];
    }

    public void setBearing1(String bearing) {
        if (this.SectorIndex == 0) {
            this.Bearing1 = new String[10];
        }
        this.Bearing1[this.SectorIndex] = bearing;
    }

    public String getBearing2() {
        if (this.Bearing2[this.SectorIndex] == null) {
            return this.Bearing2[0];
        }
        return this.Bearing2[this.SectorIndex];
    }

    public void setBearing2(String bearing) {
        if (this.SectorIndex == 0) {
            this.Bearing2 = new String[10];
        }
        this.Bearing2[this.SectorIndex] = bearing;
    }

    public String getRadius() {
        if (this.Radius[this.SectorIndex] == null) {
            return this.Radius[0];
        }
        return this.Radius[this.SectorIndex];
    }

    public void setRadius(String radius) {
        if (this.SectorIndex == 0) {
            this.Radius = new String[10];
        }
        this.Radius[this.SectorIndex] = radius;
    }

    public String getLightPeriod() {
        if (this.LightPeriod[this.SectorIndex] == null) {
            return this.LightPeriod[0];
        }
        return this.LightPeriod[this.SectorIndex];
    }

    public void setLightPeriod(String lightPeriod) {
        String regex = "^[\\d\\s.]+$";
        if (!lightPeriod.isEmpty()) {
            Pattern pat = Pattern.compile(regex);
            Matcher matcher = pat.matcher(lightPeriod);
            if (matcher.find()) {
                this.setErrMsg(null);
            } else {
                this.setErrMsg("Must be a number");
                lightPeriod = "";
                this.dlg.tfM01RepeatTime.requestFocus();
            }
        }
        if (this.SectorIndex == 0) {
            this.LightPeriod = new String[10];
        }
        this.LightPeriod[this.SectorIndex] = lightPeriod;
    }

    public Node getNode() {
        return this.Node;
    }

    public void setNode(Node node) {
        this.Node = node;
    }

    public boolean hasTopMark() {
        return this.TopMark;
    }

    public void setTopMark(boolean topMark) {
        this.TopMark = topMark;
        this.dlg.cM01TopMark.setSelected(topMark);
    }

    public int getTopMarkIndex() {
        return this.TopMarkIndex;
    }

    public void setTopMarkIndex(int index) {
        this.TopMarkIndex = index;
    }

    public SmpDialogAction getDlg() {
        return this.dlg;
    }

    public void setDlg(SmpDialogAction dlg) {
        this.dlg = dlg;
    }

    protected Buoy(SmpDialogAction dia) {
        this.dlg = dia;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public void parseLights(Map<String, String> k) {
        this.setFired(false);
        this.setSectored(false);
        for (Map.Entry<String, String> entry : k.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().trim();
            if (!key.contains("seamark:light:")) continue;
            this.setFired(true);
            int index = 0;
            key = key.substring(14);
            if (key.matches("^\\d:.*")) {
                index = key.charAt(0) - 48;
                key = key.substring(2);
            } else if (key.matches("^\\d$")) {
                index = key.charAt(0) - 48;
                String[] values = value.split(":");
                if (values[0].equals("red")) {
                    this.LightColour[index] = "R";
                } else if (values[0].equals("green")) {
                    this.LightColour[index] = "G";
                } else if (values[0].equals("white")) {
                    this.LightColour[index] = "W";
                }
                if (values.length > 1) {
                    this.Bearing1[index] = values[1];
                }
                if (values.length > 2) {
                    this.Bearing2[index] = values[2];
                }
                if (values.length > 3) {
                    this.Radius[index] = values[3];
                }
            } else {
                index = 0;
            }
            if (index != 0) {
                this.setSectored(true);
            }
            if (key.equals("ref")) {
                this.setLitRef(value);
            }
            if (key.equals("inform")) {
                this.setLitInf(value);
            }
            if (key.equals("category")) {
                this.setLitCat(value);
            }
            if (key.equals("multiple")) {
                this.setLitMul(value);
            }
            if (key.equals("colour")) {
                if (value.equals("red")) {
                    this.LightColour[index] = "R";
                    continue;
                }
                if (value.equals("green")) {
                    this.LightColour[index] = "G";
                    continue;
                }
                if (!value.equals("white")) continue;
                this.LightColour[index] = "W";
                continue;
            }
            if (key.equals("character")) {
                this.LightChar[index] = value;
                continue;
            }
            if (key.equals("group")) {
                this.LightGroup[index] = value;
                continue;
            }
            if (key.equals("period")) {
                this.LightPeriod[index] = value;
                continue;
            }
            if (key.equals("height")) {
                this.Height[index] = value;
                continue;
            }
            if (key.equals("range")) {
                this.Range[index] = value;
                continue;
            }
            if (key.equals("sequence")) {
                this.Sequence[index] = value;
                continue;
            }
            if (key.equals("sector_start")) {
                this.Bearing1[index] = value;
                continue;
            }
            if (!key.equals("sector_end")) continue;
            this.Bearing2[index] = value;
        }
        this.setSectorIndex(0);
        this.dlg.cbM01Sector.setSelectedIndex(0);
        this.dlg.cM01Fired.setSelected(this.isFired());
        this.dlg.rbM01Fired1.setSelected(!this.isSectored());
        this.dlg.rbM01FiredN.setSelected(this.isSectored());
        this.dlg.cbM01Kennung.setSelectedItem(this.getLightChar());
        this.dlg.tfM01Height.setText(this.getHeight());
        this.dlg.tfM01Range.setText(this.getRange());
        this.dlg.tfM01Group.setText(this.getLightGroup());
        this.dlg.tfM01RepeatTime.setText(this.getLightPeriod());
        this.dlg.cbM01Colour.setSelectedItem(this.getLightColour());
    }

    public void parseFogRadar(Map<String, String> k) {
        String str;
        this.setFog(false);
        this.setRadar(false);
        this.setRacon(false);
        if (k.containsKey("seamark:fog_signal") || k.containsKey("seamark:fog_signal:category") || k.containsKey("seamark:fog_signal:group") || k.containsKey("seamark:fog_signal:period")) {
            this.setFog(true);
            if (k.containsKey("seamark:fog_signal:category")) {
                str = k.get("seamark:fog_signal:category");
                if (str.equals("horn")) {
                    this.setFogSound(1);
                } else if (str.equals("siren")) {
                    this.setFogSound(2);
                } else if (str.equals("diaphone")) {
                    this.setFogSound(3);
                } else if (str.equals("bell")) {
                    this.setFogSound(4);
                } else if (str.equals("whis")) {
                    this.setFogSound(5);
                } else if (str.equals("gong")) {
                    this.setFogSound(6);
                } else if (str.equals("explosive")) {
                    this.setFogSound(7);
                } else {
                    this.setFogSound(0);
                }
            }
            if (k.containsKey("seamark:fog_signal:group")) {
                this.setFogGroup(k.get("seamark:fog_signal:group"));
            }
            if (k.containsKey("seamark:fog_signal:period")) {
                this.setFogPeriod(k.get("seamark:fog_signal:period"));
            }
        }
        this.dlg.cM01Fog.setSelected(this.hasFog());
        this.dlg.cbM01Fog.setSelectedIndex(this.getFogSound());
        this.dlg.tfM01FogGroup.setText(this.getFogGroup());
        this.dlg.tfM01FogPeriod.setText(this.getFogPeriod());
        if (k.containsKey("seamark:radar_transponder") || k.containsKey("seamark:radar_transponder:category") || k.containsKey("seamark:radar_transponder:group")) {
            this.setRacon(true);
            if (k.containsKey("seamark:radar_transponder:category")) {
                str = k.get("seamark:radar_transponder:category");
                if (str.equals("racon")) {
                    this.setRaType(1);
                } else if (str.equals("ramark")) {
                    this.setRaType(2);
                } else if (str.equals("leading")) {
                    this.setRaType(3);
                } else {
                    this.setRaType(0);
                }
            }
            if (k.containsKey("seamark:radar_transponder:group")) {
                this.setRaconGroup(k.get("seamark:radar_transponder:group"));
            }
        } else if (k.containsKey("seamark:radar_reflector")) {
            this.setRadar(true);
        }
        this.dlg.cM01Radar.setSelected(this.hasRadar());
        this.dlg.cM01Racon.setSelected(this.hasRacon());
        this.dlg.cbM01Racon.setSelectedIndex(this.getRaType());
        this.dlg.tfM01Racon.setText(this.getRaconGroup());
    }

    @Override
    public void paintSign() {
        if (this.dlg.paintlock) {
            return;
        }
        this.dlg.paintlock = true;
        this.dlg.lM01Icon.setIcon(null);
        this.dlg.lM02Icon.setIcon(null);
        this.dlg.lM03Icon.setIcon(null);
        this.dlg.lM04Icon.setIcon(null);
        this.dlg.lM05Icon.setIcon(null);
        this.dlg.lM06Icon.setIcon(null);
        this.dlg.lM01NameMark.setText("");
        this.dlg.lM01FireMark.setText("");
        this.dlg.lM01FogMark.setText("");
        this.dlg.lM01RadarMark.setText("");
        this.dlg.rbM01RegionA.setSelected(!this.getRegion());
        this.dlg.rbM01RegionB.setSelected(this.getRegion());
        if (this.isValid()) {
            String c;
            this.dlg.lM01NameMark.setText(this.getName());
            this.dlg.bM01Save.setEnabled(true);
            this.dlg.cM01TopMark.setSelected(this.hasTopMark());
            this.dlg.cM01Fired.setSelected(this.isFired());
            this.dlg.tfM01RepeatTime.setText(this.getLightPeriod());
            this.dlg.tfM01Name.setText(this.getName());
            this.dlg.tfM01Name.setEnabled(true);
            if (this.hasRadar()) {
                this.dlg.lM03Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Radar_Reflector_355.png")));
            } else if (this.hasRacon()) {
                this.dlg.lM04Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Radar_Station.png")));
                if (this.getRaType() != 0) {
                    c = (String)this.dlg.cbM01Racon.getSelectedItem();
                    if (this.getRaType() == 1 && !this.getRaconGroup().isEmpty()) {
                        c = c + "(" + this.getRaconGroup() + ")";
                    }
                    this.dlg.lM01RadarMark.setText(c);
                }
                this.dlg.cbM01Racon.setVisible(true);
                if (this.getRaType() == 1) {
                    this.dlg.lM01Racon.setVisible(true);
                    this.dlg.tfM01Racon.setVisible(true);
                    this.dlg.tfM01Racon.setEnabled(true);
                } else {
                    this.dlg.lM01Racon.setVisible(false);
                    this.dlg.tfM01Racon.setVisible(false);
                }
            } else {
                this.dlg.cbM01Racon.setVisible(false);
                this.dlg.lM01Racon.setVisible(false);
                this.dlg.tfM01Racon.setVisible(false);
            }
            if (this.hasFog()) {
                this.dlg.lM05Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Fog_Signal.png")));
                if (this.getFogSound() != 0) {
                    c = (String)this.dlg.cbM01Fog.getSelectedItem();
                    if (!this.getFogGroup().isEmpty()) {
                        c = c + "(" + this.getFogGroup() + ")";
                    }
                    if (!this.getFogPeriod().isEmpty()) {
                        c = c + " " + this.getFogPeriod() + "s";
                    }
                    this.dlg.lM01FogMark.setText(c);
                }
                this.dlg.cbM01Fog.setVisible(true);
                if (this.getFogSound() == 0) {
                    this.dlg.lM01FogGroup.setVisible(false);
                    this.dlg.tfM01FogGroup.setVisible(false);
                    this.dlg.lM01FogPeriod.setVisible(false);
                    this.dlg.tfM01FogPeriod.setVisible(false);
                } else {
                    this.dlg.lM01FogGroup.setVisible(true);
                    this.dlg.tfM01FogGroup.setVisible(true);
                    this.dlg.lM01FogPeriod.setVisible(true);
                    this.dlg.tfM01FogPeriod.setVisible(true);
                }
            } else {
                this.dlg.cbM01Fog.setVisible(false);
                this.dlg.lM01FogGroup.setVisible(false);
                this.dlg.tfM01FogGroup.setVisible(false);
                this.dlg.lM01FogPeriod.setVisible(false);
                this.dlg.tfM01FogPeriod.setVisible(false);
            }
            if (this.isFired()) {
                String tmp = null;
                String col = this.getLightColour();
                if (col.equals("W")) {
                    this.dlg.lM02Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_White_120.png")));
                    this.dlg.cbM01Colour.setSelectedIndex(1);
                } else if (col.equals("R")) {
                    this.dlg.lM02Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Red_120.png")));
                    this.dlg.cbM01Colour.setSelectedIndex(2);
                } else if (col.equals("G")) {
                    this.dlg.lM02Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Green_120.png")));
                    this.dlg.cbM01Colour.setSelectedIndex(3);
                } else {
                    this.dlg.lM02Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Magenta_120.png")));
                    this.dlg.cbM01Colour.setSelectedIndex(0);
                }
                String c2 = this.getLightChar();
                this.dlg.cbM01Kennung.setSelectedItem(c2);
                if (c2.contains("+")) {
                    int i1 = c2.indexOf("+");
                    tmp = c2.substring(i1, c2.length());
                    c2 = c2.substring(0, i1);
                    if (!this.getLightGroup().isEmpty()) {
                        c2 = c2 + "(" + this.getLightGroup() + ")";
                    }
                    if (tmp != null) {
                        c2 = c2 + tmp;
                    }
                    this.dlg.cbM01Kennung.setSelectedItem(c2);
                } else if (!this.getLightGroup().isEmpty()) {
                    c2 = c2 + "(" + this.getLightGroup() + ")";
                }
                if (this.dlg.cbM01Kennung.getSelectedIndex() == 0) {
                    this.dlg.cbM01Kennung.setSelectedItem(c2);
                }
                c2 = c2 + " " + this.getLightColour();
                String lp = this.getLightPeriod();
                if (!lp.isEmpty()) {
                    c2 = c2 + " " + lp + "s";
                }
                this.dlg.lM01FireMark.setText(c2);
                this.dlg.cM01Fired.setVisible(true);
                this.dlg.lM01Kennung.setVisible(true);
                this.dlg.cbM01Kennung.setVisible(true);
                if (((String)this.dlg.cbM01Kennung.getSelectedItem()).contains("(")) {
                    this.dlg.tfM01Group.setVisible(false);
                    this.dlg.lM01Group.setVisible(false);
                } else {
                    this.dlg.lM01Group.setVisible(true);
                    this.dlg.tfM01Group.setVisible(true);
                }
                this.dlg.tfM01Group.setText(this.getLightGroup());
                this.dlg.lM01RepeatTime.setVisible(true);
                this.dlg.tfM01RepeatTime.setVisible(true);
                if (this.isSectored()) {
                    this.dlg.rbM01Fired1.setSelected(false);
                    this.dlg.rbM01FiredN.setSelected(true);
                    if (this.getSectorIndex() != 0 && !this.LightChar[0].isEmpty()) {
                        this.dlg.cbM01Kennung.setEnabled(false);
                    } else {
                        this.dlg.cbM01Kennung.setEnabled(true);
                    }
                    this.dlg.cbM01Kennung.setSelectedItem(this.getLightChar());
                    if (this.getSectorIndex() != 0 && !this.LightGroup[0].isEmpty()) {
                        this.dlg.tfM01Group.setEnabled(false);
                    } else {
                        this.dlg.tfM01Group.setEnabled(true);
                    }
                    this.dlg.tfM01Group.setText(this.getLightGroup());
                    if (this.getSectorIndex() != 0 && !this.LightPeriod[0].isEmpty()) {
                        this.dlg.tfM01RepeatTime.setEnabled(false);
                    } else {
                        this.dlg.tfM01RepeatTime.setEnabled(true);
                    }
                    this.dlg.tfM01RepeatTime.setText(this.getLightPeriod());
                    if (this.getSectorIndex() != 0 && !this.Height[0].isEmpty()) {
                        this.dlg.tfM01Height.setEnabled(false);
                    } else {
                        this.dlg.tfM01Height.setEnabled(true);
                    }
                    this.dlg.tfM01Height.setText(this.getHeight());
                    if (this.getSectorIndex() != 0 && !this.Range[0].isEmpty()) {
                        this.dlg.tfM01Range.setEnabled(false);
                    } else {
                        this.dlg.tfM01Range.setEnabled(true);
                    }
                    this.dlg.tfM01Range.setText(this.getRange());
                    this.dlg.lM01Sector.setVisible(true);
                    this.dlg.cbM01Sector.setVisible(true);
                    if (this.getSectorIndex() == 0) {
                        this.dlg.lM01Colour.setVisible(false);
                        this.dlg.cbM01Colour.setVisible(false);
                        this.dlg.lM01Bearing.setVisible(false);
                        this.dlg.tfM01Bearing.setVisible(false);
                        this.dlg.tfM02Bearing.setVisible(false);
                        this.dlg.tfM01Radius.setVisible(false);
                    } else {
                        this.dlg.lM01Colour.setVisible(true);
                        this.dlg.cbM01Colour.setVisible(true);
                        this.dlg.lM01Bearing.setVisible(true);
                        this.dlg.tfM01Bearing.setVisible(true);
                        this.dlg.tfM01Bearing.setText(this.getBearing1());
                        this.dlg.tfM02Bearing.setVisible(true);
                        this.dlg.tfM02Bearing.setText(this.getBearing2());
                        this.dlg.tfM01Radius.setVisible(true);
                        this.dlg.tfM01Radius.setText(this.getRadius());
                    }
                } else {
                    this.dlg.rbM01FiredN.setSelected(false);
                    this.dlg.rbM01Fired1.setSelected(true);
                    this.dlg.cbM01Kennung.setEnabled(true);
                    this.dlg.tfM01Group.setEnabled(true);
                    this.dlg.tfM01RepeatTime.setEnabled(true);
                    this.dlg.tfM01Height.setEnabled(true);
                    this.dlg.tfM01Range.setEnabled(true);
                    this.dlg.lM01Colour.setVisible(true);
                    this.dlg.cbM01Colour.setVisible(true);
                    this.dlg.lM01Sector.setVisible(false);
                    this.dlg.cbM01Sector.setVisible(false);
                    this.dlg.lM01Bearing.setVisible(false);
                    this.dlg.tfM01Bearing.setVisible(false);
                    this.dlg.tfM02Bearing.setVisible(false);
                    this.dlg.tfM01Radius.setVisible(false);
                }
            } else {
                this.dlg.lM01FireMark.setText("");
                this.dlg.rbM01Fired1.setVisible(false);
                this.dlg.rbM01FiredN.setVisible(false);
                this.dlg.cbM01Kennung.setVisible(false);
                this.dlg.lM01Kennung.setVisible(false);
                this.dlg.tfM01Height.setVisible(false);
                this.dlg.lM01Height.setVisible(false);
                this.dlg.tfM01Range.setVisible(false);
                this.dlg.lM01Range.setVisible(false);
                this.dlg.cbM01Colour.setVisible(false);
                this.dlg.lM01Colour.setVisible(false);
                this.dlg.cbM01Sector.setVisible(false);
                this.dlg.lM01Sector.setVisible(false);
                this.dlg.tfM01Group.setVisible(false);
                this.dlg.lM01Group.setVisible(false);
                this.dlg.tfM01RepeatTime.setVisible(false);
                this.dlg.lM01RepeatTime.setVisible(false);
                this.dlg.tfM01Bearing.setVisible(false);
                this.dlg.lM01Bearing.setVisible(false);
                this.dlg.tfM02Bearing.setVisible(false);
                this.dlg.tfM01Radius.setVisible(false);
            }
        } else {
            this.dlg.bM01Save.setEnabled(false);
            this.dlg.tfM01Name.setEnabled(false);
            this.dlg.cM01TopMark.setVisible(false);
            this.dlg.cbM01TopMark.setVisible(false);
            this.dlg.cM01Radar.setVisible(false);
            this.dlg.cM01Racon.setVisible(false);
            this.dlg.cbM01Racon.setVisible(false);
            this.dlg.tfM01Racon.setVisible(false);
            this.dlg.lM01Racon.setVisible(false);
            this.dlg.cM01Fog.setVisible(false);
            this.dlg.cbM01Fog.setVisible(false);
            this.dlg.tfM01FogGroup.setVisible(false);
            this.dlg.lM01FogGroup.setVisible(false);
            this.dlg.tfM01FogPeriod.setVisible(false);
            this.dlg.lM01FogPeriod.setVisible(false);
            this.dlg.cM01Fired.setVisible(false);
            this.dlg.rbM01Fired1.setVisible(false);
            this.dlg.rbM01FiredN.setVisible(false);
            this.dlg.cbM01Kennung.setVisible(false);
            this.dlg.lM01Kennung.setVisible(false);
            this.dlg.tfM01Height.setVisible(false);
            this.dlg.lM01Height.setVisible(false);
            this.dlg.tfM01Range.setVisible(false);
            this.dlg.lM01Range.setVisible(false);
            this.dlg.cbM01Colour.setVisible(false);
            this.dlg.lM01Colour.setVisible(false);
            this.dlg.cbM01Sector.setVisible(false);
            this.dlg.lM01Sector.setVisible(false);
            this.dlg.tfM01Group.setVisible(false);
            this.dlg.lM01Group.setVisible(false);
            this.dlg.tfM01RepeatTime.setVisible(false);
            this.dlg.lM01RepeatTime.setVisible(false);
            this.dlg.tfM01Bearing.setVisible(false);
            this.dlg.lM01Bearing.setVisible(false);
            this.dlg.tfM02Bearing.setVisible(false);
            this.dlg.tfM01Radius.setVisible(false);
        }
        this.dlg.paintlock = false;
    }

    public void saveSign(String type) {
        this.delSeaMarkKeys(this.Node);
        String str = this.dlg.tfM01Name.getText();
        if (!str.isEmpty()) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:name", str));
        }
        if (!this.Longname.isEmpty()) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:longname", this.Longname));
        }
        if (!this.Fixme.isEmpty()) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fixme", this.Fixme));
        }
        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:type", type));
    }

    protected void saveLightData() {
        if (this.dlg.cM01Fired.isSelected()) {
            String colour = this.LightColour[0];
            if (!colour.isEmpty() && !this.Sectored) {
                if (colour.equals("R")) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:colour", "red"));
                } else if (colour.equals("G")) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:colour", "green"));
                } else if (colour.equals("W")) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:colour", "white"));
                }
            }
            if (!this.LitRef.isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:ref", this.LitRef));
            }
            if (!this.LitInf.isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:inform", this.LitInf));
            }
            if (!this.LitCat.isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:category", this.LitCat));
            }
            if (!this.LitMul.isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:multiple", this.LitMul));
            }
            if (!this.LightPeriod[0].isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:period", this.LightPeriod[0]));
            }
            if (!this.LightChar[0].isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:character", this.LightChar[0]));
            }
            if (!this.LightGroup[0].isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:group", this.LightGroup[0]));
            }
            if (!this.Height[0].isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:height", this.Height[0]));
            }
            if (!this.Range[0].isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:range", this.Range[0]));
            }
            if (!this.Sequence[0].isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:sequence", this.Sequence[0]));
            }
            for (int i = 1; i < 10; ++i) {
                colour = this.LightColour[i];
                if (colour != null) {
                    if (colour.equals("R")) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":colour", "red"));
                        if (this.Bearing1[i] != null && this.Bearing2[i] != null && this.Radius[i] != null) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i, "red:" + this.Bearing1[i] + ":" + this.Bearing2[i] + ":" + this.Radius[i]));
                        }
                    } else if (colour.equals("G")) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":colour", "green"));
                        if (this.Bearing1[i] != null && this.Bearing2[i] != null && this.Radius[i] != null) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i, "green:" + this.Bearing1[i] + ":" + this.Bearing2[i] + ":" + this.Radius[i]));
                        }
                    } else if (colour.equals("W")) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":colour", "white"));
                        if (this.Bearing1[i] != null && this.Bearing2[i] != null && this.Radius[i] != null) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i, "white:" + this.Bearing1[i] + ":" + this.Bearing2[i] + ":" + this.Radius[i]));
                        }
                    }
                }
                if (this.LightPeriod[i] != null) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":period", this.LightPeriod[i]));
                }
                if (this.LightChar[i] != null) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":character", this.LightChar[i]));
                }
                if (this.LightGroup[i] != null) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":group", this.LightGroup[i]));
                }
                if (this.Height[i] != null) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":height", this.Height[i]));
                }
                if (this.Sequence[i] != null) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":sequence", this.Sequence[i]));
                }
                if (this.Range[i] != null) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":range", this.Range[i]));
                }
                if (this.Bearing1[i] != null) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":sector_start", this.Bearing1[i]));
                }
                if (this.Bearing2[i] == null) continue;
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:" + i + ":sector_end", this.Bearing2[i]));
            }
        }
    }

    protected void saveTopMarkData(String shape, String colour) {
        if (this.hasTopMark()) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:topmark:shape", shape));
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:topmark:colour", colour));
        }
    }

    protected void saveRadarFogData() {
        if (this.hasRadar()) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:radar_reflector", "yes"));
        }
        if (this.hasRacon()) {
            switch (this.RaType) {
                case 1: {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:radar_transponder:category", "racon"));
                    if (this.getRaconGroup().isEmpty()) break;
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:radar_transponder:group", this.getRaconGroup()));
                    break;
                }
                case 2: {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:radar_transponder:category", "ramark"));
                    break;
                }
                case 3: {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:radar_transponder:category", "leading"));
                    break;
                }
                default: {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:radar_transponder", "yes"));
                }
            }
        }
        if (this.hasFog()) {
            if (this.getFogSound() == 0) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal", "yes"));
            } else {
                switch (this.getFogSound()) {
                    case 1: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:category", "horn"));
                        break;
                    }
                    case 2: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:category", "siren"));
                        break;
                    }
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:category", "diaphone"));
                        break;
                    }
                    case 4: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:category", "bell"));
                        break;
                    }
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:category", "whistle"));
                        break;
                    }
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:category", "gong"));
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:category", "explosive"));
                    }
                }
                if (!this.getFogGroup().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:group", this.getFogGroup()));
                }
                if (!this.getFogPeriod().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:fog_signal:period", this.getFogPeriod()));
                }
            }
        }
    }

    public void refreshStyles() {
    }

    public void refreshLights() {
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01Kennung.addItem("Fl");
        this.dlg.cbM01Kennung.addItem("LFl");
        this.dlg.cbM01Kennung.addItem("Iso");
        this.dlg.cbM01Kennung.addItem("F");
        this.dlg.cbM01Kennung.addItem("FFl");
        this.dlg.cbM01Kennung.addItem("Oc");
        this.dlg.cbM01Kennung.addItem("Q");
        this.dlg.cbM01Kennung.addItem("IQ");
        this.dlg.cbM01Kennung.addItem("VQ");
        this.dlg.cbM01Kennung.addItem("IVQ");
        this.dlg.cbM01Kennung.addItem("UQ");
        this.dlg.cbM01Kennung.addItem("IUQ");
        this.dlg.cbM01Kennung.addItem("Mo");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
    }

    public void resetMask() {
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        this.dlg.lM01Icon.setIcon(null);
        this.dlg.lM02Icon.setIcon(null);
        this.dlg.lM03Icon.setIcon(null);
        this.dlg.lM04Icon.setIcon(null);
        this.dlg.lM05Icon.setIcon(null);
        this.dlg.lM06Icon.setIcon(null);
        this.dlg.rbM01RegionA.setEnabled(false);
        this.dlg.rbM01RegionB.setEnabled(false);
        this.dlg.lM01FireMark.setText("");
        this.dlg.cbM01CatOfMark.setVisible(false);
        this.dlg.lM01CatOfMark.setVisible(false);
        this.setBuoyIndex(0);
        this.dlg.cbM01StyleOfMark.setVisible(false);
        this.dlg.lM01StyleOfMark.setVisible(false);
        this.setStyleIndex(0);
        this.dlg.tfM01Name.setText("");
        this.dlg.tfM01Name.setEnabled(false);
        this.setName("");
        this.setLongname("");
        this.setFixme("");
        this.setLitRef("");
        this.setLitInf("");
        this.setLitCat("");
        this.setLitMul("");
        this.dlg.cM01TopMark.setSelected(false);
        this.dlg.cM01TopMark.setVisible(false);
        this.dlg.cbM01TopMark.setVisible(false);
        this.setTopMark(false);
        this.dlg.cM01Radar.setSelected(false);
        this.dlg.cM01Radar.setVisible(false);
        this.setRadar(false);
        this.dlg.cM01Racon.setSelected(false);
        this.dlg.cM01Racon.setVisible(false);
        this.dlg.cbM01Racon.setVisible(false);
        this.dlg.tfM01Racon.setText("");
        this.dlg.tfM01Racon.setVisible(false);
        this.dlg.lM01Racon.setVisible(false);
        this.setRacon(false);
        this.setRaType(0);
        this.dlg.cM01Fog.setSelected(false);
        this.dlg.cM01Fog.setVisible(false);
        this.dlg.cbM01Fog.setVisible(false);
        this.setFogSound(0);
        this.dlg.tfM01FogGroup.setText("");
        this.dlg.tfM01FogGroup.setVisible(false);
        this.dlg.lM01FogGroup.setVisible(false);
        this.dlg.tfM01FogPeriod.setText("");
        this.dlg.tfM01FogPeriod.setVisible(false);
        this.dlg.lM01FogPeriod.setVisible(false);
        this.setFog(false);
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01Fired.setVisible(false);
        this.setFired(false);
        this.dlg.rbM01Fired1.setVisible(false);
        this.dlg.rbM01Fired1.setSelected(true);
        this.dlg.rbM01FiredN.setVisible(false);
        this.dlg.rbM01FiredN.setSelected(false);
        this.setSectored(false);
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.setVisible(false);
        this.dlg.lM01Kennung.setVisible(false);
        this.setLightChar("");
        this.dlg.tfM01Height.setText("");
        this.dlg.tfM01Height.setVisible(false);
        this.dlg.lM01Height.setVisible(false);
        this.setHeight("");
        this.dlg.tfM01Range.setText("");
        this.dlg.tfM01Range.setVisible(false);
        this.dlg.lM01Range.setVisible(false);
        this.setRange("");
        this.dlg.cbM01Colour.setVisible(false);
        this.dlg.lM01Colour.setVisible(false);
        this.setLightColour("");
        this.dlg.cbM01Sector.setVisible(false);
        this.dlg.lM01Sector.setVisible(false);
        this.setSectorIndex(0);
        this.dlg.tfM01Group.setText("");
        this.dlg.tfM01Group.setVisible(false);
        this.dlg.lM01Group.setVisible(false);
        this.setLightGroup("");
        this.dlg.tfM01RepeatTime.setText("");
        this.dlg.tfM01RepeatTime.setVisible(false);
        this.dlg.lM01RepeatTime.setVisible(false);
        this.setLightPeriod("");
        this.dlg.tfM01Bearing.setText("");
        this.dlg.tfM01Bearing.setVisible(false);
        this.dlg.lM01Bearing.setVisible(false);
        this.setBearing1("");
        this.dlg.tfM02Bearing.setText("");
        this.dlg.tfM02Bearing.setVisible(false);
        this.setBearing2("");
        this.dlg.tfM01Radius.setText("");
        this.dlg.tfM01Radius.setVisible(false);
        this.setRadius("");
        this.dlg.bM01Save.setEnabled(false);
    }
}

