/*
 * Decompiled with CFR 0.152.
 */
package toms.plug.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import toms.plug.ifc.Pluggable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static List<Pluggable> createPluggableObjects(List<Class<Pluggable>> pluggables) {
        ArrayList<Pluggable> plugs = new ArrayList<Pluggable>(pluggables.size());
        for (Class<Pluggable> plug : pluggables) {
            try {
                plugs.add(plug.newInstance());
            }
            catch (InstantiationException e) {
                System.err.println("Can't instantiate plugin: " + plug.getName());
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println("IllegalAccess for plugin: " + plug.getName());
                e.printStackTrace();
            }
        }
        return plugs;
    }

    private static List<Class<Pluggable>> extractClassesFromJARs(File[] jars, ClassLoader cl) throws FileNotFoundException, IOException {
        ArrayList<Class<Pluggable>> classes = new ArrayList<Class<Pluggable>>();
        for (File jar : jars) {
            classes.addAll(PluginLoader.extractClassesFromJAR(jar, cl));
        }
        return classes;
    }

    private static Collection<? extends Class<Pluggable>> extractClassesFromJAR(File jar, ClassLoader cl) throws FileNotFoundException, IOException {
        ArrayList classes = new ArrayList();
        JarInputStream jaris = new JarInputStream(new FileInputStream(jar));
        JarEntry ent = null;
        while ((ent = jaris.getNextJarEntry()) != null) {
            String entName = ent.getName();
            if (!entName.endsWith(".class")) continue;
            try {
                Class<?> cls = cl.loadClass(entName.substring(0, entName.length() - 6).replace('/', '.'));
                if (!PluginLoader.isPluggableClass(cls)) continue;
                classes.add(cls);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Can't load Class" + entName);
                e.printStackTrace();
            }
        }
        jaris.close();
        return classes;
    }

    private static boolean isPluggableClass(Class<?> cls) {
        for (Class<?> i : cls.getInterfaces()) {
            if (!i.equals(Pluggable.class)) continue;
            return true;
        }
        return false;
    }

    private static URL[] fileArrayToURLArray(File[] files) throws MalformedURLException {
        URL[] urls = new URL[files.length];
        if (urls == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return urls;
    }
}

