// License: GPL. Copyright 2011 by Josh Doe and others

/*
 * ConflationPanel.java
 *
 * Created on Apr 26, 2011, 10:47:18 PM
 */

package org.openstreetmap.josm.plugins.conflation;

import java.awt.Component;

import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchAction.SearchSetting;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

/**
 *
 * @author Josh
 */
public class ConflationOptionsPanel extends javax.swing.JPanel {
    ConflationOptionsDialog dlg = null;

    /** Creates new form ConflationPanel */
    public ConflationOptionsPanel(ConflationOptionsDialog dlg, List<OsmDataLayer> layers) {
        initComponents();

        this.dlg = dlg;

        // set layer names to comboboxes
        if (layers != null && layers.size() > 0) {
            refLayerComboBox.setModel(new javax.swing.DefaultComboBoxModel(layers.toArray()));
            refLayerComboBox.setRenderer(new LayerListCellRenderer());
            nonRefLayerComboBox.setModel(new javax.swing.DefaultComboBoxModel(layers.toArray()));
            nonRefLayerComboBox.setRenderer(new LayerListCellRenderer());
        }

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        refSearchModeButtonGroup = new javax.swing.ButtonGroup();
        nonRefSearchModeButtonGroup = new javax.swing.ButtonGroup();
        resultsTabPanel = new javax.swing.JTabbedPane();
        objectTabPanel = new javax.swing.JPanel();
        refSetPanel = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        refLayerComboBox = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        refFilterTextField = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        refReplaceRadio = new javax.swing.JRadioButton();
        refAddRadio = new javax.swing.JRadioButton();
        refRemoveRadio = new javax.swing.JRadioButton();
        refInSelectionRadio = new javax.swing.JRadioButton();
        refCaseSensitiveCheckBox = new javax.swing.JCheckBox();
        refAllObjectsCheckBox = new javax.swing.JCheckBox();
        refRegExCheckBox = new javax.swing.JCheckBox();
        nonRefSetPanel = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        nonRefLayerComboBox = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        nonRefFilterTextField = new javax.swing.JTextField();
        jPanel8 = new javax.swing.JPanel();
        nonRefReplaceRadio = new javax.swing.JRadioButton();
        nonRefAddRadio = new javax.swing.JRadioButton();
        nonRefRemoveRadio = new javax.swing.JRadioButton();
        nonRefInSelectionRadio = new javax.swing.JRadioButton();
        nonRefCaseSensitiveCheckBox = new javax.swing.JCheckBox();
        nonRefAllObjectsCheckBox = new javax.swing.JCheckBox();
        nonRefRegExCheckBox = new javax.swing.JCheckBox();
        objectTabCancelButton = new javax.swing.JButton();
        objectTabNextButton = new javax.swing.JButton();
        criteriaTabPanel = new javax.swing.JPanel();
        criteriaTabConflateButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        refSetPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Reference Set"));

        jLabel1.setText("Layer");

        refLayerComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jLabel2.setText("Filter");

        jPanel5.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        refSearchModeButtonGroup.add(refReplaceRadio);
        refReplaceRadio.setSelected(true);
        refReplaceRadio.setText("Replace selection");

        refSearchModeButtonGroup.add(refAddRadio);
        refAddRadio.setText("Add to selection");
        refAddRadio.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refAddRadioActionPerformed(evt);
            }
        });

        refSearchModeButtonGroup.add(refRemoveRadio);
        refRemoveRadio.setText("Remove from selection");

        refSearchModeButtonGroup.add(refInSelectionRadio);
        refInSelectionRadio.setText("Find in selection");

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(refReplaceRadio)
                    .addComponent(refAddRadio)
                    .addComponent(refRemoveRadio)
                    .addComponent(refInSelectionRadio))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(refReplaceRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(refAddRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(refRemoveRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(refInSelectionRadio))
        );

        refCaseSensitiveCheckBox.setText("Case sensitive");

        refAllObjectsCheckBox.setText("All objects");

        refRegExCheckBox.setText("Regular expression");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2))
                        .addGap(18, 18, 18)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(refLayerComboBox, 0, 246, Short.MAX_VALUE)
                            .addComponent(refFilterTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 246, Short.MAX_VALUE)))
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(refCaseSensitiveCheckBox)
                            .addComponent(refAllObjectsCheckBox)
                            .addComponent(refRegExCheckBox))))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(refLayerComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(refFilterTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(refCaseSensitiveCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(refAllObjectsCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(refRegExCheckBox))))
        );

        javax.swing.GroupLayout refSetPanelLayout = new javax.swing.GroupLayout(refSetPanel);
        refSetPanel.setLayout(refSetPanelLayout);
        refSetPanelLayout.setHorizontalGroup(
            refSetPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        refSetPanelLayout.setVerticalGroup(
            refSetPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        nonRefSetPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Non-Reference Set"));

        jLabel3.setText("Layer");

        nonRefLayerComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jLabel4.setText("Filter");

        jPanel8.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        nonRefSearchModeButtonGroup.add(nonRefReplaceRadio);
        nonRefReplaceRadio.setSelected(true);
        nonRefReplaceRadio.setText("Replace selection");

        nonRefSearchModeButtonGroup.add(nonRefAddRadio);
        nonRefAddRadio.setText("Add to selection");
        nonRefAddRadio.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nonRefAddRadioActionPerformed(evt);
            }
        });

        nonRefSearchModeButtonGroup.add(nonRefRemoveRadio);
        nonRefRemoveRadio.setText("Remove from selection");

        nonRefSearchModeButtonGroup.add(nonRefInSelectionRadio);
        nonRefInSelectionRadio.setText("Find in selection");

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(nonRefReplaceRadio)
                    .addComponent(nonRefAddRadio)
                    .addComponent(nonRefRemoveRadio)
                    .addComponent(nonRefInSelectionRadio))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(nonRefReplaceRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nonRefAddRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nonRefRemoveRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nonRefInSelectionRadio))
        );

        nonRefCaseSensitiveCheckBox.setText("Case sensitive");

        nonRefAllObjectsCheckBox.setText("All objects");

        nonRefRegExCheckBox.setText("Regular expression");

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel3)
                            .addComponent(jLabel4))
                        .addGap(18, 18, 18)
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(nonRefLayerComboBox, 0, 246, Short.MAX_VALUE)
                            .addComponent(nonRefFilterTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 246, Short.MAX_VALUE)))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jPanel8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(nonRefCaseSensitiveCheckBox)
                            .addComponent(nonRefAllObjectsCheckBox)
                            .addComponent(nonRefRegExCheckBox))))
                .addContainerGap())
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(nonRefLayerComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(nonRefFilterTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(nonRefCaseSensitiveCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nonRefAllObjectsCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nonRefRegExCheckBox))))
        );

        javax.swing.GroupLayout nonRefSetPanelLayout = new javax.swing.GroupLayout(nonRefSetPanel);
        nonRefSetPanel.setLayout(nonRefSetPanelLayout);
        nonRefSetPanelLayout.setHorizontalGroup(
            nonRefSetPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        nonRefSetPanelLayout.setVerticalGroup(
            nonRefSetPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        objectTabCancelButton.setText("Cancel");
        objectTabCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                objectTabCancelButtonActionPerformed(evt);
            }
        });

        objectTabNextButton.setMnemonic('N');
        objectTabNextButton.setText("Next");
        objectTabNextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                objectTabNextButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout objectTabPanelLayout = new javax.swing.GroupLayout(objectTabPanel);
        objectTabPanel.setLayout(objectTabPanelLayout);
        objectTabPanelLayout.setHorizontalGroup(
            objectTabPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(objectTabPanelLayout.createSequentialGroup()
                .addGroup(objectTabPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(nonRefSetPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(refSetPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, objectTabPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(objectTabCancelButton)
                        .addGap(81, 81, 81)
                        .addComponent(objectTabNextButton)))
                .addContainerGap())
        );
        objectTabPanelLayout.setVerticalGroup(
            objectTabPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(objectTabPanelLayout.createSequentialGroup()
                .addComponent(refSetPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nonRefSetPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(objectTabPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(objectTabNextButton)
                    .addComponent(objectTabCancelButton))
                .addGap(55, 55, 55))
        );

        resultsTabPanel.addTab("Object selection", objectTabPanel);

        criteriaTabConflateButton.setMnemonic('f');
        criteriaTabConflateButton.setText("Conflate");
        criteriaTabConflateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                criteriaTabConflateButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout criteriaTabPanelLayout = new javax.swing.GroupLayout(criteriaTabPanel);
        criteriaTabPanel.setLayout(criteriaTabPanelLayout);
        criteriaTabPanelLayout.setHorizontalGroup(
            criteriaTabPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, criteriaTabPanelLayout.createSequentialGroup()
                .addContainerGap(254, Short.MAX_VALUE)
                .addComponent(criteriaTabConflateButton)
                .addContainerGap())
        );
        criteriaTabPanelLayout.setVerticalGroup(
            criteriaTabPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, criteriaTabPanelLayout.createSequentialGroup()
                .addContainerGap(404, Short.MAX_VALUE)
                .addComponent(criteriaTabConflateButton)
                .addContainerGap())
        );

        resultsTabPanel.addTab("Matching criteria", criteriaTabPanel);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 337, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 438, Short.MAX_VALUE)
        );

        resultsTabPanel.addTab("Results", jPanel1);

        add(resultsTabPanel);
    }// </editor-fold>//GEN-END:initComponents

    private void refAddRadioActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refAddRadioActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_refAddRadioActionPerformed

    private void nonRefAddRadioActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nonRefAddRadioActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_nonRefAddRadioActionPerformed

    private void objectTabCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_objectTabCancelButtonActionPerformed
        dlg.setCanceled(true);
        dlg.setVisible(false);
    }//GEN-LAST:event_objectTabCancelButtonActionPerformed

    private void criteriaTabConflateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_criteriaTabConflateButtonActionPerformed
        dlg.setVisible(false);
    }//GEN-LAST:event_criteriaTabConflateButtonActionPerformed

    private void objectTabNextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_objectTabNextButtonActionPerformed
        if (criteriaTabPanel != null)
            resultsTabPanel.setSelectedComponent(criteriaTabPanel);
    }//GEN-LAST:event_objectTabNextButtonActionPerformed

    static public class LayerListCellRenderer extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected,
                boolean cellHasFocus) {
            Layer layer = (Layer) value;
            JLabel label = (JLabel) super.getListCellRendererComponent(list, layer.getName(), index, isSelected,
                    cellHasFocus);
            Icon icon = layer.getIcon();
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }

    public OsmDataLayer getRefLayer() {
        return (OsmDataLayer) refLayerComboBox.getModel().getSelectedItem();
    }

    public OsmDataLayer getNonRefLayer() {
        return (OsmDataLayer) nonRefLayerComboBox.getModel().getSelectedItem();
    }

    public SearchSetting getRefSearchSetting() {
        SearchSetting s = new SearchSetting();
        s.text = refFilterTextField.getText();
        s.allElements = refAllObjectsCheckBox.isSelected();
        s.caseSensitive = refCaseSensitiveCheckBox.isSelected();
        s.regexSearch = refRegExCheckBox.isSelected();
        s.mode = refReplaceRadio.isSelected() ? SearchAction.SearchMode.replace
                : (refAddRadio.isSelected() ? SearchAction.SearchMode.add
                : (refRemoveRadio.isSelected() ? SearchAction.SearchMode.remove : SearchAction.SearchMode.in_selection));
        return s;
    }

    public SearchSetting getNonRefSearchSetting() {
        SearchSetting s = new SearchSetting();
        s.text = nonRefFilterTextField.getText();
        s.allElements = nonRefAllObjectsCheckBox.isSelected();
        s.caseSensitive = nonRefCaseSensitiveCheckBox.isSelected();
        s.regexSearch = nonRefRegExCheckBox.isSelected();
        s.mode = nonRefReplaceRadio.isSelected() ? SearchAction.SearchMode.replace
                : (nonRefAddRadio.isSelected() ? SearchAction.SearchMode.add
                : (nonRefRemoveRadio.isSelected() ? SearchAction.SearchMode.remove : SearchAction.SearchMode.in_selection));
        return s;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton criteriaTabConflateButton;
    private javax.swing.JPanel criteriaTabPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JRadioButton nonRefAddRadio;
    private javax.swing.JCheckBox nonRefAllObjectsCheckBox;
    private javax.swing.JCheckBox nonRefCaseSensitiveCheckBox;
    private javax.swing.JTextField nonRefFilterTextField;
    private javax.swing.JRadioButton nonRefInSelectionRadio;
    private javax.swing.JComboBox nonRefLayerComboBox;
    private javax.swing.JCheckBox nonRefRegExCheckBox;
    private javax.swing.JRadioButton nonRefRemoveRadio;
    private javax.swing.JRadioButton nonRefReplaceRadio;
    private javax.swing.ButtonGroup nonRefSearchModeButtonGroup;
    private javax.swing.JPanel nonRefSetPanel;
    private javax.swing.JButton objectTabCancelButton;
    private javax.swing.JButton objectTabNextButton;
    private javax.swing.JPanel objectTabPanel;
    private javax.swing.JRadioButton refAddRadio;
    private javax.swing.JCheckBox refAllObjectsCheckBox;
    private javax.swing.JCheckBox refCaseSensitiveCheckBox;
    private javax.swing.JTextField refFilterTextField;
    private javax.swing.JRadioButton refInSelectionRadio;
    private javax.swing.JComboBox refLayerComboBox;
    private javax.swing.JCheckBox refRegExCheckBox;
    private javax.swing.JRadioButton refRemoveRadio;
    private javax.swing.JRadioButton refReplaceRadio;
    private javax.swing.ButtonGroup refSearchModeButtonGroup;
    private javax.swing.JPanel refSetPanel;
    private javax.swing.JTabbedPane resultsTabPanel;
    // End of variables declaration//GEN-END:variables

}
