/*
 * Decompiled with CFR 0.152.
 */
package ext_tools;

import ext_tools.ExtTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class ToolsInformation {
    String filename;
    ArrayList<ExtTool> tools = new ArrayList();

    public ToolsInformation(String filename) {
        this.filename = filename;
        this.load();
    }

    public void load() {
        try {
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = rdr.readLine()) != null) {
                sb.append(line).append('\n');
                if (!line.equals("")) continue;
                this.tools.add(ExtTool.unserialize(sb.toString()));
                sb = new StringBuilder();
            }
            rdr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), "UTF-8");
            for (ExtTool tool : this.tools) {
                w.write(tool.serialize());
            }
            w.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ExtTool> getToolsList() {
        return this.tools;
    }

    public void addTool(ExtTool tool) {
        this.tools.add(tool);
    }

    public void removeTool(ExtTool tool) {
        tool.setEnabled(false);
        this.tools.remove(tool);
    }
}

