/*
 * Decompiled with CFR 0.152.
 */
package ext_tools;

import ext_tools.DataSetToCmd;
import ext_tools.ExtToolAction;
import ext_tools.ExtToolsPlugin;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ExtTool {
    protected boolean enabled = false;
    public String name;
    public String cmdline;
    public String description;
    public String url;
    protected ExtToolAction action;
    protected JMenuItem menuItem;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (!this.enabled ^ enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            if (this.action == null) {
                this.action = new ExtToolAction(this);
            }
            this.menuItem = MainMenu.add((JMenu)Main.main.menu.toolsMenu, (JosmAction)this.action);
        } else {
            Main.main.menu.toolsMenu.remove(this.menuItem);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExtTool() {
    }

    public ExtTool(String name) {
        this();
        this.name = name;
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.name).append('\n');
        sb.append("cmdline=").append(this.cmdline).append('\n');
        sb.append("description=").append(this.description).append('\n');
        sb.append("url=").append(this.url).append('\n');
        sb.append('\n');
        return sb.toString();
    }

    public static ExtTool unserialize(String str) {
        String[] lines;
        ExtTool t = new ExtTool();
        String[] stringArray = lines = str.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] parts = line.split("=", 2);
            if (parts[0].equals("name")) {
                t.name = parts[1];
            } else if (parts[0].equals("cmdline")) {
                t.cmdline = parts[1];
            } else if (parts[0].equals("description")) {
                t.description = parts[1];
            } else if (parts[0].equals("url")) {
                t.url = parts[1];
            }
            ++n2;
        }
        return t;
    }

    static double getPPD() {
        ProjectionBounds bounds = Main.map.mapView.getProjectionBounds();
        return (double)Main.map.mapView.getWidth() / (bounds.maxEast - bounds.minEast);
    }

    private double latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI;
    }

    private double lonToTileX(double lon, int zoom) {
        return Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0;
    }

    private double getTMSZoom() {
        if (Main.map == null || Main.map.mapView == null) {
            return 1.0;
        }
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        double x1 = this.lonToTileX(topLeft.lon(), 1);
        double y1 = this.latToTileY(topLeft.lat(), 1);
        double x2 = this.lonToTileX(botRight.lon(), 1);
        double y2 = this.latToTileY(botRight.lat(), 1);
        int screenPixels = mv.getWidth() * mv.getHeight();
        double tilePixels = Math.abs((y2 - y1) * (x2 - x1) * 65536.0);
        if (screenPixels == 0 || tilePixels == 0.0) {
            return 1.0;
        }
        return Math.log((double)screenPixels / tilePixels) / Math.log(2.0) / 2.0 + 1.0;
    }

    protected void showErrorMessage(String message, String details) {
        final JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JMultilineLabel(message), GBC.eol());
        if (details != null) {
            JTextArea info = new JTextArea(details, 20, 60);
            info.setCaretPosition(0);
            info.setEditable(false);
            p.add((Component)new JScrollPane(info), GBC.eop());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Main.parent, p, I18n.tr((String)"External tool error"), 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTool(LatLon pos) {
        Main.map.mapView.setCursor(Cursor.getPredefinedCursor(3));
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{lat}", "" + pos.lat());
        replace.put("{lon}", "" + pos.lon());
        replace.put("{PPD}", "" + ExtTool.getPPD());
        replace.put("{TZoom}", "" + this.getTMSZoom());
        ArrayList<String> cmdParams = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.cmdline);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (replace.containsKey(token)) {
                cmdParams.add((String)replace.get(token));
                continue;
            }
            cmdParams.add(token);
        }
        final Object syncObj = new Object();
        ProcessBuilder builder = new ProcessBuilder(cmdParams);
        builder.directory(new File(ExtToolsPlugin.plugin.getPluginDir()));
        final StringBuilder debugstr = new StringBuilder();
        for (String s : builder.command()) {
            debugstr.append(String.valueOf(s) + " ");
        }
        debugstr.append("\n");
        System.out.print(debugstr.toString());
        final ToolProcess tp = new ToolProcess();
        try {
            tp.process = builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            StringBuilder stringBuilder = debugstr;
            synchronized (stringBuilder) {
                this.showErrorMessage(I18n.tr((String)"Error executing the script:"), String.valueOf(debugstr.toString()) + e.getMessage() + "\n" + e.getStackTrace());
            }
            return;
        }
        tp.running = true;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int len;
                    byte[] buffer = new byte[1024];
                    InputStream errStream = tp.process.getErrorStream();
                    while ((len = errStream.read(buffer)) > 0) {
                        StringBuilder stringBuilder = debugstr;
                        synchronized (stringBuilder) {
                            debugstr.append(new String(buffer, 0, len));
                        }
                        System.err.write(buffer, 0, len);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
        Thread osmParseThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block19: {
                    try {
                        try {
                            InputStream inputStream = tp.process.getInputStream();
                            DataSet ds = OsmReader.parseDataSet((InputStream)inputStream, (ProgressMonitor)NullProgressMonitor.INSTANCE);
                            LinkedList<Command> cmdlist = new DataSetToCmd(ds).getCommandList();
                            if (!cmdlist.isEmpty()) {
                                SequenceCommand cmd = new SequenceCommand(ExtTool.this.getName(), cmdlist);
                                Main.main.undoRedo.add((Command)cmd);
                            }
                        }
                        catch (IllegalDataException e) {
                            e.printStackTrace();
                            if (tp.running) {
                                tp.process.destroy();
                                StringBuilder stringBuilder = debugstr;
                                synchronized (stringBuilder) {
                                    ExtTool.this.showErrorMessage(I18n.tr((String)"Child script have returned invalid data.\n\nstderr contents:"), debugstr.toString());
                                }
                            }
                            Object object = syncObj;
                            synchronized (object) {
                                tp.running = false;
                                syncObj.notifyAll();
                                break block19;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = syncObj;
                        synchronized (object) {
                            tp.running = false;
                            syncObj.notifyAll();
                        }
                        throw throwable;
                    }
                    Object object = syncObj;
                    synchronized (object) {
                        tp.running = false;
                        syncObj.notifyAll();
                    }
                }
            }
        });
        osmParseThread.start();
        Object object = syncObj;
        synchronized (object) {
            try {
                syncObj.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tp.running) {
            new Thread((Runnable)new PleaseWaitRunnable(this.name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void realRun() {
                    try {
                        this.progressMonitor.indeterminateSubTask(null);
                        Object object = syncObj;
                        synchronized (object) {
                            if (tp.running) {
                                syncObj.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void cancel() {
                    Object object = syncObj;
                    synchronized (object) {
                        tp.running = false;
                        tp.process.destroy();
                        syncObj.notifyAll();
                    }
                }

                protected void finish() {
                }
            }).start();
        }
    }

    private class ToolProcess {
        public Process process;
        public volatile boolean running;

        private ToolProcess() {
        }
    }
}

