/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.iwa;

import java.awt.Point;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.iwa.IWAGeometry;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Pair;

public class IWATargetWayHelper {
    public static Way findWay(MapView mv, Point p) {
        if (mv == null || p == null) {
            return null;
        }
        Node node = mv.getNearestNode(p, OsmPrimitive.isSelectablePredicate);
        Way candidate = null;
        if (node != null) {
            List candidates = node.getReferrers();
            for (OsmPrimitive refferer : candidates) {
                if (!(refferer instanceof Way)) continue;
                candidate = (Way)refferer;
                break;
            }
            if (candidate != null) {
                return candidate;
            }
        }
        candidate = Main.map.mapView.getNearestWay(p, OsmPrimitive.isSelectablePredicate);
        return candidate;
    }

    public static Node findCandidateNode(MapView mv, Way w, Point p) {
        if (mv == null || w == null || p == null) {
            return null;
        }
        EastNorth pEN = mv.getEastNorth(p.x, p.y);
        Double bestDistance = Double.MAX_VALUE;
        List wpps = w.getNodePairs(false);
        Node result = null;
        block0: for (Node n : w.getNodes()) {
            EastNorth nEN = n.getEastNorth();
            Double currentDistance = pEN.distance(nEN);
            if (!(currentDistance < bestDistance)) continue;
            for (Pair wpp : wpps) {
                if (((Node)wpp.a).equals((Object)n) || ((Node)wpp.b).equals((Object)n) || Geometry.getSegmentSegmentIntersection((EastNorth)((Node)wpp.a).getEastNorth(), (EastNorth)((Node)wpp.b).getEastNorth(), (EastNorth)pEN, (EastNorth)nEN) == null) continue;
                continue block0;
            }
            result = n;
            bestDistance = currentDistance;
        }
        return result;
    }

    public static WaySegment findCandidateSegment(MapView mv, Way w, Point p) {
        if (mv == null || w == null || p == null) {
            return null;
        }
        EastNorth pEN = mv.getEastNorth(p.x, p.y);
        Double bestDistance = Double.MAX_VALUE;
        Double bestAngle = 0.0;
        int candidate = -1;
        List wpps = w.getNodePairs(true);
        int i = -1;
        for (Pair wpp : wpps) {
            Double currentAngle;
            Double currentDistance;
            ++i;
            EastNorth altitudeIntersection = IWAGeometry.getSegmentAltituteIntersection(((Node)wpp.a).getEastNorth(), ((Node)wpp.b).getEastNorth(), pEN);
            if (altitudeIntersection != null) {
                currentDistance = pEN.distance(altitudeIntersection);
                currentAngle = Double.MAX_VALUE;
            } else {
                currentDistance = Math.min(pEN.distance(((Node)wpp.a).getEastNorth()), pEN.distance(((Node)wpp.b).getEastNorth()));
                currentAngle = Math.abs(IWAGeometry.getCornerAngle(((Node)wpp.a).getEastNorth(), pEN, ((Node)wpp.b).getEastNorth()));
            }
            if (!(currentDistance < bestDistance) && (!(currentAngle > bestAngle) || !(currentDistance < bestDistance * 1.0001))) continue;
            candidate = i;
            bestAngle = currentAngle;
            bestDistance = currentDistance;
        }
        return candidate != -1 ? new WaySegment(w, candidate) : null;
    }
}

