/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionPane;
import org.openstreetmap.josm.plugins.turnlanes.gui.ValidationPanel;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.tools.I18n;

public class TurnLanesDialog
extends ToggleDialog {
    private final Action editAction = new JosmAction(I18n.tr((String)"Edit"), "dialogs/edit", I18n.tr((String)"Edit turn relations and lane lengths for selected node."), null, true){
        private static final long serialVersionUID = 4114119073563457706L;

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_EDIT);
            TurnLanesDialog.this.editing = true;
        }
    };
    private final Action validateAction = new JosmAction(I18n.tr((String)"Validate"), "dialogs/validator", I18n.tr((String)"Validate turn- and lane-length-relations for consistency."), null, true){
        private static final long serialVersionUID = 7510740945725851427L;

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_VALIDATE);
            TurnLanesDialog.this.editing = false;
        }
    };
    private static final long serialVersionUID = -1998375221636611358L;
    private static final String CARD_EDIT = "EDIT";
    private static final String CARD_VALIDATE = "VALIDATE";
    private static final String CARD_ERROR = "ERROR";
    private final JPanel body = new JPanel();
    private final JunctionPane junctionPane = new JunctionPane(null);
    private final JLabel error = new JLabel();
    private boolean editing = true;

    public TurnLanesDialog() {
        super(I18n.tr((String)"Turn Lanes"), "turnlanes.png", I18n.tr((String)"Edit turn lanes"), null, 200);
        DataSet.addSelectionListener((SelectionChangedListener)new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
                Collection<? extends OsmPrimitive> s = Collections.unmodifiableCollection(newSelection);
                List nodes = OsmPrimitive.getFilteredList(s, Node.class);
                List ways = OsmPrimitive.getFilteredList(s, Way.class);
                if (nodes.isEmpty()) {
                    TurnLanesDialog.this.setJunction(null);
                    return;
                }
                try {
                    TurnLanesDialog.this.setJunction(ModelContainer.create(nodes, ways));
                }
                catch (RuntimeException e) {
                    TurnLanesDialog.this.displayError(e);
                    return;
                }
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        ButtonGroup group = new ButtonGroup();
        JToggleButton editButton = new JToggleButton(this.editAction);
        JToggleButton validateButton = new JToggleButton(this.validateAction);
        group.add(editButton);
        group.add(validateButton);
        buttonPanel.add(editButton);
        buttonPanel.add(validateButton);
        this.body.setLayout(new CardLayout(4, 4));
        this.add(buttonPanel, "South");
        this.add(this.body, "Center");
        this.body.add((Component)this.junctionPane, CARD_EDIT);
        this.body.add((Component)new ValidationPanel(), CARD_VALIDATE);
        this.body.add((Component)this.error, CARD_ERROR);
        editButton.doClick();
    }

    void displayError(RuntimeException e) {
        if (this.editing) {
            e.printStackTrace();
            this.error.setText("<html>An error occured while constructing the model. Please run the validator to make sure the data is consistent.<br><br>Error: " + e.getMessage() + "</html>");
            CardLayout cl = (CardLayout)this.body.getLayout();
            cl.show(this.body, CARD_ERROR);
        }
    }

    void setJunction(ModelContainer mc) {
        if (mc != null && this.editing) {
            this.junctionPane.setJunction(new GuiContainer(mc));
            CardLayout cl = (CardLayout)this.body.getLayout();
            cl.show(this.body, CARD_EDIT);
        }
    }
}

