/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.plugins.turnlanes.gui.LaneGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;

interface State {

    public static class OutgoingActive
    implements State {
        private final LaneGui lane;

        public OutgoingActive(LaneGui lane) {
            this.lane = lane;
        }

        public LaneGui getLane() {
            return this.lane;
        }
    }

    public static class IncomingActive
    implements State {
        private final Road.End roadEnd;

        public IncomingActive(Road.End roadEnd) {
            this.roadEnd = roadEnd;
        }

        public Road.End getRoadEnd() {
            return this.roadEnd;
        }
    }

    public static class Default
    implements State {
    }

    public static class Dirty
    implements State {
        private final State wrapped;

        public Dirty(State wrapped) {
            this.wrapped = wrapped;
        }

        public State unwrap() {
            return this.wrapped;
        }
    }

    public static class Invalid
    implements State {
        private final State wrapped;

        public Invalid(State wrapped) {
            this.wrapped = wrapped;
        }

        public State unwrap() {
            return this.wrapped;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Connecting
    implements State {
        private final Lane lane;
        private final List<RoadGui.ViaConnector> vias;

        public Connecting(Lane lane) {
            this(lane, Collections.emptyList());
        }

        public Connecting(Lane lane, List<RoadGui.ViaConnector> vias) {
            this.lane = lane;
            this.vias = vias;
        }

        public Connecting next(RoadGui.ViaConnector via) {
            if (this.vias.isEmpty()) {
                return new Connecting(this.lane, Collections.unmodifiableList(Arrays.asList(via)));
            }
            ArrayList<RoadGui.ViaConnector> tmp = new ArrayList<RoadGui.ViaConnector>(this.vias.size() + 1);
            boolean even = (this.vias.size() & 1) == 0;
            RoadGui.ViaConnector last = this.vias.get(this.vias.size() - 1);
            if (last.equals(via) || !even && last.getRoadEnd().getJunction().equals(via.getRoadEnd().getJunction())) {
                return this.pop().next(via);
            }
            if (this.vias.size() >= 2) {
                if (this.lane.getOutgoingJunction().equals(via.getRoadEnd().getJunction())) {
                    return new Connecting(this.lane);
                }
                if (via.equals(this.getBacktrackViaConnector())) {
                    return new Connecting(this.lane, this.vias.subList(0, this.vias.size() - 1));
                }
            }
            for (RoadGui.ViaConnector v : this.vias) {
                tmp.add(v);
                if (even && v.equals(last) || !v.getRoadEnd().getJunction().equals(via.getRoadEnd().getJunction())) continue;
                return new Connecting(this.lane, Collections.unmodifiableList(tmp));
            }
            tmp.add(via);
            return new Connecting(this.lane, Collections.unmodifiableList(tmp));
        }

        public Junction getJunction() {
            return this.vias.isEmpty() ? this.lane.getOutgoingJunction() : this.vias.get(this.vias.size() - 1).getRoadEnd().getJunction();
        }

        public RoadGui.ViaConnector getBacktrackViaConnector() {
            return this.vias.size() < 2 ? null : this.vias.get(this.vias.size() - 2);
        }

        public List<RoadGui.ViaConnector> getViaConnectors() {
            return this.vias;
        }

        public Lane getLane() {
            return this.lane;
        }

        public Connecting pop() {
            return new Connecting(this.lane, this.vias.subList(0, this.vias.size() - 1));
        }
    }

    public static class AllTurns
    implements State {
        private final State wrapped;

        public AllTurns(State wrapped) {
            this.wrapped = wrapped;
        }

        public State unwrap() {
            return this.wrapped;
        }
    }
}

