/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.MyDialog;
import buildings_tools.ToolSettings;
import java.awt.Component;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedSettingsDialog
extends MyDialog {
    private final TagEditorModel tagsModel = new TagEditorModel();
    private final JCheckBox cBigMode = new JCheckBox(I18n.tr((String)"Big buildings mode"));
    private final JCheckBox cSoftCur = new JCheckBox(I18n.tr((String)"Rotate crosshair"));
    private final JCheckBox cAddrNode = new JCheckBox(I18n.tr((String)"Use address nodes under buildings"));

    public AdvancedSettingsDialog() {
        super(I18n.tr((String)"Advanced settings"));
        this.panel.add((Component)new JLabel(I18n.tr((String)"Buildings tags:")), GBC.eol().fill(2));
        for (Map.Entry<String, String> entry : ToolSettings.getTags().entrySet()) {
            this.tagsModel.add(entry.getKey(), entry.getValue());
        }
        this.panel.add((Component)new TagEditorPanel(this.tagsModel, null), GBC.eop().fill(1));
        this.panel.add((Component)this.cBigMode, GBC.eol().fill(2));
        this.panel.add((Component)this.cSoftCur, GBC.eol().fill(2));
        this.panel.add((Component)this.cAddrNode, GBC.eol().fill(2));
        this.cBigMode.setSelected(ToolSettings.isBBMode());
        this.cSoftCur.setSelected(ToolSettings.isSoftCursor());
        this.cAddrNode.setSelected(ToolSettings.PROP_USE_ADDR_NODE.get());
        this.setupDialog();
        this.showDialog();
    }

    public void saveSettings() {
        this.tagsModel.applyToTags(ToolSettings.getTags());
        ToolSettings.saveTags();
        ToolSettings.setBBMode(this.cBigMode.isSelected());
        ToolSettings.setSoftCursor(this.cSoftCur.isSelected());
        ToolSettings.PROP_USE_ADDR_NODE.put(this.cAddrNode.isSelected());
    }
}

