/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.DownloadWMSPlanImage;
import cadastre_fr.MenuActionNewLocation;
import cadastre_fr.WMSLayer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionGrabPlanImage
extends JosmAction
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static String name = "Georeference an image";
    private DownloadWMSPlanImage downloadWMSPlanImage;
    private WMSLayer wmsLayer;
    private int countMouseClicked = 0;
    private int mode = 0;
    private int cGetCorners = 1;
    private int cGetLambertCrosspieces = 2;
    private EastNorth ea1;
    private EastNorth ea2;
    private long mouseClickedTime = 0L;
    private EastNorth georefpoint1;
    private EastNorth georefpoint2;
    private boolean ignoreMouseClick = false;
    private boolean clickOnTheMap = false;
    private int initialClickDelay;

    public MenuActionGrabPlanImage() {
        super(I18n.tr((String)name), "cadastre_small", I18n.tr((String)"Grab non-georeferenced image"), null, false);
    }

    public void actionCompleted() {
        this.countMouseClicked = 0;
        this.mode = 0;
        this.mouseClickedTime = System.currentTimeMillis();
    }

    public void actionInterrupted() {
        this.actionCompleted();
        if (this.wmsLayer != null) {
            Main.map.mapView.removeLayer((Layer)this.wmsLayer);
            this.wmsLayer = null;
        }
    }

    protected void updateEnabledState() {
        if (this.wmsLayer == null || Main.map == null || Main.map.mapView == null) {
            return;
        }
        if (this.countMouseClicked == 0 && this.mode == 0) {
            return;
        }
        for (Layer l : Main.map.mapView.getAllLayersAsList()) {
            if (l != this.wmsLayer) continue;
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Georeferencing interrupted"));
        this.actionInterrupted();
    }

    public void actionPerformed(ActionEvent ae) {
        if (Main.map != null) {
            if (CadastrePlugin.isCadastreProjection()) {
                this.wmsLayer = new MenuActionNewLocation().addNewLayer(new ArrayList<WMSLayer>());
                if (this.wmsLayer == null) {
                    return;
                }
                this.downloadWMSPlanImage = new DownloadWMSPlanImage();
                this.downloadWMSPlanImage.download(this.wmsLayer);
                this.initialClickDelay = Main.pref.getInteger("cadastrewms.georef-click-delay", 200);
                Main.worker.execute(this);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To enable the cadastre WMS plugin, change\nthe current projection to one of the cadastre\nprojections and retry"));
            }
        }
    }

    @Override
    public void run() {
        boolean loadedFromCache = this.downloadWMSPlanImage.waitFinished();
        if (loadedFromCache) {
            Main.map.repaint();
        } else if (this.wmsLayer.getImages().size() == 0) {
            this.actionInterrupted();
        } else {
            int reply = 2;
            if (this.wmsLayer.isAlreadyGeoreferenced()) {
                reply = JOptionPane.showConfirmDialog(null, I18n.tr((String)"This image contains georeference data.\nDo you want to use them ?"), null, 0);
            }
            if (reply == 0) {
                this.transformGeoreferencedImg();
            } else {
                this.mouseClickedTime = System.currentTimeMillis();
                Main.map.mapView.addMouseListener((MouseListener)this);
                if (!Main.pref.getBoolean("cadastrewms.noImageCropping", false)) {
                    this.startCropping();
                } else {
                    this.startGeoreferencing();
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (System.currentTimeMillis() - this.mouseClickedTime < (long)this.initialClickDelay) {
            System.out.println("mouse click bounce detected");
            return;
        }
        this.mouseClickedTime = System.currentTimeMillis();
        if (e.getButton() != 1) {
            return;
        }
        if (this.ignoreMouseClick) {
            return;
        }
        EastNorth ea = Main.proj.latlon2eastNorth(Main.map.mapView.getLatLon(e.getX(), e.getY()));
        System.out.println("clic:" + this.countMouseClicked + " ," + ea + ", mode:" + this.mode);
        if (this.clickOnTheMap) {
            this.clickOnTheMap = false;
            this.handleNewCoordinates(ea.east(), ea.north());
        } else {
            ++this.countMouseClicked;
            if (ea.east() < this.wmsLayer.getImage((int)0).min.east() || ea.east() > this.wmsLayer.getImage((int)0).max.east() || ea.north() < this.wmsLayer.getImage((int)0).min.north() || ea.north() > this.wmsLayer.getImage((int)0).max.north()) {
                return;
            }
            if (this.mode == this.cGetCorners) {
                if (this.countMouseClicked == 1) {
                    this.ea1 = ea;
                    this.continueCropping();
                }
                if (this.countMouseClicked == 2) {
                    this.wmsLayer.cropImage(this.ea1, ea);
                    Main.map.mapView.repaint();
                    this.startGeoreferencing();
                }
            } else if (this.mode == this.cGetLambertCrosspieces) {
                if (this.countMouseClicked == 1) {
                    this.ea1 = ea;
                    this.inputLambertPosition();
                }
                if (this.countMouseClicked == 2) {
                    this.ea2 = ea;
                    this.inputLambertPosition();
                }
            }
        }
    }

    private boolean startCropping() {
        this.mode = this.cGetCorners;
        this.countMouseClicked = 0;
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = JOptionPane.showOptionDialog(null, I18n.tr((String)"Click first corner for image cropping\n(two points required)"), I18n.tr((String)"Image cropping"), -1, 1, null, options, options[0]);
        if (ret == 0) {
            this.mouseClickedTime = System.currentTimeMillis();
        } else if (this.canceledOrRestartCurrAction("image cropping")) {
            return this.startCropping();
        }
        return true;
    }

    private boolean continueCropping() {
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = JOptionPane.showOptionDialog(null, I18n.tr((String)"Click second corner for image cropping"), I18n.tr((String)"Image cropping"), -1, 1, null, options, options[0]);
        if (ret != 0 && this.canceledOrRestartCurrAction("image cropping")) {
            return this.startCropping();
        }
        return true;
    }

    private boolean startGeoreferencing() {
        this.countMouseClicked = 0;
        this.mode = this.cGetLambertCrosspieces;
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = JOptionPane.showOptionDialog(null, I18n.tr((String)"Click first Lambert crosspiece for georeferencing\n(two points required)"), I18n.tr((String)"Image georeferencing"), -1, 1, null, options, options[0]);
        if (ret == 0) {
            this.mouseClickedTime = System.currentTimeMillis();
        } else if (this.canceledOrRestartCurrAction("georeferencing")) {
            return this.startGeoreferencing();
        }
        return true;
    }

    private boolean continueGeoreferencing() {
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = JOptionPane.showOptionDialog(null, I18n.tr((String)"Click second Lambert crosspiece for georeferencing"), I18n.tr((String)"Image georeferencing"), -1, 1, null, options, options[0]);
        if (ret != 0 && this.canceledOrRestartCurrAction("georeferencing")) {
            return this.startGeoreferencing();
        }
        return true;
    }

    private void endGeoreferencing() {
        Main.map.mapView.removeMouseListener((MouseListener)this);
        this.affineTransform(this.ea1, this.ea2, this.georefpoint1, this.georefpoint2);
        this.wmsLayer.grabThread.saveNewCache();
        Main.map.mapView.repaint();
        this.actionCompleted();
        this.clickOnTheMap = false;
        this.ignoreMouseClick = false;
    }

    private boolean canceledOrRestartCurrAction(String action) {
        Object[] options = new Object[]{"Cancel", "Retry"};
        int selectedValue = JOptionPane.showOptionDialog(null, I18n.tr((String)("Do you want to cancel completely\nor just retry " + action + " ?")), "", -1, 2, null, options, options[0]);
        this.countMouseClicked = 0;
        if (selectedValue == 0) {
            Main.map.mapView.removeLayer((Layer)this.wmsLayer);
            this.wmsLayer = null;
            Main.map.mapView.removeMouseListener((MouseListener)this);
            return false;
        }
        return true;
    }

    private void inputLambertPosition() {
        JLabel labelEnterPosition = new JLabel(I18n.tr((String)"Enter cadastre east,north position"));
        JLabel labelWarning = new JLabel(I18n.tr((String)"(Warning: verify north with arrow !!)"));
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelEast = new JLabel(I18n.tr((String)"East"));
        JLabel labelNorth = new JLabel(I18n.tr((String)"North"));
        final JTextField inputEast = new JTextField();
        final JTextField inputNorth = new JTextField();
        p.add((Component)labelEnterPosition, GBC.eol());
        p.add((Component)labelWarning, GBC.eol());
        p.add((Component)labelEast, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)inputEast, GBC.eol().fill(2).insets(10, 5, 0, 5));
        p.add((Component)labelNorth, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)inputNorth, GBC.eol().fill(2).insets(10, 5, 0, 5));
        final Object[] options = new Object[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel"), I18n.tr((String)"I use the mouse")};
        final JOptionPane pane = new JOptionPane(p, 1, 1, null, options, options[0]);
        String number = this.countMouseClicked == 1 ? "first" : "second";
        JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Set {0} Lambert coordinates", (Object[])new Object[]{number}));
        dialog.setModal(false);
        this.ignoreMouseClick = true;
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("value".equals(evt.getPropertyName())) {
                    MenuActionGrabPlanImage.this.ignoreMouseClick = false;
                    if (pane.getValue().equals(options[1]) && MenuActionGrabPlanImage.this.canceledOrRestartCurrAction("georeferencing")) {
                        MenuActionGrabPlanImage.this.startGeoreferencing();
                    }
                    if (pane.getValue().equals(options[2])) {
                        MenuActionGrabPlanImage.this.clickOnTheMap = true;
                    } else {
                        MenuActionGrabPlanImage.this.clickOnTheMap = false;
                        if (inputEast.getText().length() != 0 && inputNorth.getText().length() != 0) {
                            double n;
                            double e;
                            try {
                                e = Double.parseDouble(inputEast.getText());
                                n = Double.parseDouble(inputNorth.getText());
                            }
                            catch (NumberFormatException ex) {
                                return;
                            }
                            MenuActionGrabPlanImage.this.handleNewCoordinates(e, n);
                        }
                    }
                }
            }
        });
    }

    private void handleNewCoordinates(double e, double n) {
        if (this.countMouseClicked == 1) {
            this.georefpoint1 = new EastNorth(e, n);
            this.continueGeoreferencing();
        } else {
            this.georefpoint2 = new EastNorth(e, n);
            this.endGeoreferencing();
        }
    }

    private void affineTransform(EastNorth org1, EastNorth org2, EastNorth dst1, EastNorth dst2) {
        double angle = dst1.heading(dst2) - org1.heading(org2);
        double proportion = dst1.distance((Point2D)dst2) / org1.distance((Point2D)org2);
        double dx = dst1.getX() - org1.getX();
        double dy = dst1.getY() - org1.getY();
        this.wmsLayer.getImage(0).shear(dx, dy);
        org1 = org1.add(dx, dy);
        org2 = org2.add(dx, dy);
        this.wmsLayer.getImage(0).rotate(dst1, angle);
        org2 = org2.rotate(dst1, angle);
        this.wmsLayer.getImage(0).scale(dst1, proportion);
    }

    private void transformGeoreferencedImg() {
        this.georefpoint1 = new EastNorth(this.wmsLayer.X0, this.wmsLayer.Y0);
        this.georefpoint2 = new EastNorth(this.wmsLayer.X0 + this.wmsLayer.fX * this.wmsLayer.communeBBox.max.getX(), this.wmsLayer.Y0 + this.wmsLayer.fY * this.wmsLayer.communeBBox.max.getX());
        this.ea1 = new EastNorth(this.wmsLayer.getImage((int)0).min.east(), this.wmsLayer.getImage((int)0).max.north());
        EastNorth ea2 = this.wmsLayer.getImage((int)0).max;
        this.affineTransform(this.ea1, ea2, this.georefpoint1, this.georefpoint2);
        this.wmsLayer.grabThread.saveNewCache();
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

