/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.EastNorthBound;
import cadastre_fr.VectorImageModifier;
import cadastre_fr.WMSLayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class GeorefImage
implements Serializable,
ImageObserver,
Cloneable {
    private static final long serialVersionUID = 1L;
    public EastNorth min;
    public EastNorth max;
    public EastNorth[] orgRaster = new EastNorth[4];
    public EastNorth[] orgCroppedRaster = new EastNorth[4];
    public double angle = 0.0;
    public int imageOriginalHeight = 0;
    public int imageOriginalWidth = 0;
    public BufferedImage image;
    private double pixelPerEast;
    private double pixelPerNorth;

    public GeorefImage(BufferedImage img, EastNorth min, EastNorth max) {
        this.image = img;
        this.min = min;
        this.max = max;
        this.orgRaster[0] = min;
        this.orgRaster[1] = new EastNorth(min.east(), max.north());
        this.orgRaster[2] = max;
        this.orgRaster[3] = new EastNorth(max.east(), min.north());
        this.orgCroppedRaster[0] = min;
        this.orgCroppedRaster[1] = new EastNorth(min.east(), max.north());
        this.orgCroppedRaster[2] = max;
        this.orgCroppedRaster[3] = new EastNorth(max.east(), min.north());
        this.imageOriginalHeight = img == null ? 1 : img.getHeight();
        this.imageOriginalWidth = img == null ? 1 : img.getWidth();
        this.updatePixelPer();
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    private EastNorthBound computeNewBounding(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        EastNorth[] pt = new EastNorth[]{p1, p2, p3, p4};
        double smallestEast = Double.MAX_VALUE;
        double smallestNorth = Double.MAX_VALUE;
        double highestEast = Double.MIN_VALUE;
        double highestNorth = Double.MIN_VALUE;
        int i = 0;
        while (i <= 3) {
            smallestEast = Math.min(pt[i].east(), smallestEast);
            smallestNorth = Math.min(pt[i].north(), smallestNorth);
            highestEast = Math.max(pt[i].east(), highestEast);
            highestNorth = Math.max(pt[i].north(), highestNorth);
            ++i;
        }
        return new EastNorthBound(new EastNorth(smallestEast, smallestNorth), new EastNorth(highestEast, highestNorth));
    }

    public boolean contains(EastNorth en) {
        return this.min.east() <= en.east() && en.east() <= this.max.east() && this.min.north() <= en.north() && en.north() <= this.max.north();
    }

    public void paint(Graphics2D g, NavigatableComponent nc, boolean backgroundTransparent, float transparency, boolean drawBoundaries) {
        if (this.image == null || this.min == null || this.max == null) {
            return;
        }
        Point minPt = nc.getPoint(this.min);
        Point maxPt = nc.getPoint(this.max);
        if (!g.hitClip(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y)) {
            return;
        }
        if (backgroundTransparent && transparency < 1.0f) {
            g.setComposite(AlphaComposite.getInstance(3, transparency));
        }
        if (drawBoundaries) {
            if (this.orgCroppedRaster == null) {
                g.setColor(Color.green);
                g.drawRect(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y);
            } else {
                Point[] croppedPoint = new Point[5];
                int i = 0;
                while (i < 4) {
                    croppedPoint[i] = nc.getPoint(this.orgCroppedRaster[i]);
                    ++i;
                }
                croppedPoint[4] = croppedPoint[0];
                i = 0;
                while (i < 4) {
                    g.setColor(Color.green);
                    g.drawLine(croppedPoint[i].x, croppedPoint[i].y, croppedPoint[i + 1].x, croppedPoint[i + 1].y);
                    ++i;
                }
            }
        }
        g.drawImage(this.image, minPt.x, maxPt.y, maxPt.x, minPt.y, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        if (backgroundTransparent && transparency < 1.0f) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    public boolean overlap(GeorefImage georefImage) {
        if (this.contains(georefImage.min) || this.contains(georefImage.max)) {
            return true;
        }
        return this.contains(new EastNorth(georefImage.min.east(), georefImage.max.north())) || this.contains(new EastNorth(georefImage.max.east(), georefImage.min.north()));
    }

    public void withdraw(GeorefImage georefImage) {
        double maxMaskNorth;
        double minMaskEast = georefImage.min.east() > this.min.east() ? georefImage.min.east() : this.min.east();
        double maxMaskEast = georefImage.max.east() < this.max.east() ? georefImage.max.east() : this.max.east();
        double minMaskNorth = georefImage.min.north() > this.min.north() ? georefImage.min.north() : this.min.north();
        double d = maxMaskNorth = georefImage.max.north() < this.max.north() ? georefImage.max.north() : this.max.north();
        if (maxMaskNorth - minMaskNorth > 0.0 && maxMaskEast - minMaskEast > 0.0) {
            double pixelPerEast = (this.max.east() - this.min.east()) / (double)this.image.getWidth();
            double pixelPerNorth = (this.max.north() - this.min.north()) / (double)this.image.getHeight();
            int minXMaskPixel = (int)((minMaskEast - this.min.east()) / pixelPerEast);
            int minYMaskPixel = (int)((this.max.north() - maxMaskNorth) / pixelPerNorth);
            int widthXMaskPixel = Math.abs((int)((maxMaskEast - minMaskEast) / pixelPerEast));
            int heightYMaskPixel = Math.abs((int)((maxMaskNorth - minMaskNorth) / pixelPerNorth));
            Graphics g = this.image.getGraphics();
            int x = minXMaskPixel;
            while (x < minXMaskPixel + widthXMaskPixel) {
                int y = minYMaskPixel;
                while (y < minYMaskPixel + heightYMaskPixel) {
                    this.image.setRGB(x, y, VectorImageModifier.cadastreBackgroundTransp);
                    ++y;
                }
                ++x;
            }
            g.dispose();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (WMSLayer.currentFormat >= 2) {
            this.max = new EastNorth(in.readDouble(), in.readDouble());
            this.min = new EastNorth(in.readDouble(), in.readDouble());
        }
        this.orgRaster = null;
        this.orgCroppedRaster = null;
        if (WMSLayer.currentFormat >= 3) {
            this.orgRaster = new EastNorth[4];
            this.orgCroppedRaster = new EastNorth[4];
            this.angle = in.readDouble();
            this.orgRaster[0] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgRaster[1] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgRaster[2] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgRaster[3] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[0] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[1] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[2] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[3] = new EastNorth(in.readDouble(), in.readDouble());
        }
        if (WMSLayer.currentFormat >= 4) {
            this.imageOriginalHeight = in.readInt();
            this.imageOriginalWidth = in.readInt();
        }
        this.image = ImageIO.read(ImageIO.createImageInputStream(in));
        this.updatePixelPer();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.max.getX());
        out.writeDouble(this.max.getY());
        out.writeDouble(this.min.getX());
        out.writeDouble(this.min.getY());
        if (this.orgRaster == null) {
            this.orgRaster = new EastNorth[4];
            this.orgCroppedRaster = new EastNorth[4];
        }
        out.writeDouble(this.angle);
        out.writeDouble(this.orgRaster[0].getX());
        out.writeDouble(this.orgRaster[0].getY());
        out.writeDouble(this.orgRaster[1].getX());
        out.writeDouble(this.orgRaster[1].getY());
        out.writeDouble(this.orgRaster[2].getX());
        out.writeDouble(this.orgRaster[2].getY());
        out.writeDouble(this.orgRaster[3].getX());
        out.writeDouble(this.orgRaster[3].getY());
        out.writeDouble(this.orgCroppedRaster[0].getX());
        out.writeDouble(this.orgCroppedRaster[0].getY());
        out.writeDouble(this.orgCroppedRaster[1].getX());
        out.writeDouble(this.orgCroppedRaster[1].getY());
        out.writeDouble(this.orgCroppedRaster[2].getX());
        out.writeDouble(this.orgCroppedRaster[2].getY());
        out.writeDouble(this.orgCroppedRaster[3].getX());
        out.writeDouble(this.orgCroppedRaster[3].getY());
        if (WMSLayer.currentFormat >= 4) {
            out.writeInt(this.imageOriginalHeight);
            out.writeInt(this.imageOriginalWidth);
        }
        ImageIO.write((RenderedImage)this.image, "png", ImageIO.createImageOutputStream(out));
    }

    private void updatePixelPer() {
        this.pixelPerEast = (double)this.image.getWidth() / (this.max.east() - this.min.east());
        this.pixelPerNorth = (double)this.image.getHeight() / (this.max.north() - this.min.north());
    }

    public double getPixelPerEast() {
        return this.pixelPerEast;
    }

    public double getPixelPerNorth() {
        return this.pixelPerNorth;
    }

    public String toString() {
        return "GeorefImage[min=" + this.min + ", max=" + this.max + ", image" + this.image + "]";
    }

    public void shear(double dx, double dy) {
        this.min = new EastNorth(this.min.east() + dx, this.min.north() + dy);
        this.max = new EastNorth(this.max.east() + dx, this.max.north() + dy);
        int i = 0;
        while (i < 4) {
            this.orgRaster[i] = new EastNorth(this.orgRaster[i].east() + dx, this.orgRaster[i].north() + dy);
            this.orgCroppedRaster[i] = new EastNorth(this.orgCroppedRaster[i].east() + dx, this.orgCroppedRaster[i].north() + dy);
            ++i;
        }
    }

    public void scale(EastNorth anchor, double proportion) {
        this.min = anchor.interpolate(this.min, proportion);
        this.max = anchor.interpolate(this.max, proportion);
        int i = 0;
        while (i < 4) {
            this.orgRaster[i] = anchor.interpolate(this.orgRaster[i], proportion);
            this.orgCroppedRaster[i] = anchor.interpolate(this.orgCroppedRaster[i], proportion);
            ++i;
        }
        this.updatePixelPer();
    }

    public void rotate(EastNorth anchor, double delta_ang) {
        if (this.orgRaster == null || this.orgCroppedRaster == null) {
            return;
        }
        int i = 0;
        while (i < 4) {
            this.orgRaster[i] = this.orgRaster[i].rotate(anchor, delta_ang);
            this.orgCroppedRaster[i] = this.orgCroppedRaster[i].rotate(anchor, delta_ang);
            ++i;
        }
        double sin = Math.abs(Math.sin(this.angle + delta_ang));
        double cos = Math.abs(Math.cos(this.angle + delta_ang));
        int w = this.imageOriginalWidth;
        int h = this.imageOriginalHeight;
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        GraphicsConfiguration gc = GeorefImage.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(neww, newh, this.image.getTransparency());
        Graphics2D g = result.createGraphics();
        g.translate((neww - this.image.getWidth()) / 2, (newh - this.image.getHeight()) / 2);
        g.rotate(delta_ang, this.image.getWidth() / 2, this.image.getHeight() / 2);
        g.drawRenderedImage(this.image, null);
        g.dispose();
        this.image = result;
        EastNorthBound enb = this.computeNewBounding(this.orgCroppedRaster[0], this.orgCroppedRaster[1], this.orgCroppedRaster[2], this.orgCroppedRaster[3]);
        this.min = enb.min;
        this.max = enb.max;
        this.angle += delta_ang;
    }

    public void crop(EastNorth adj1, EastNorth adj2) {
        int sx1 = (int)((adj1.getX() - this.min.getX()) * this.getPixelPerEast());
        int sy1 = (int)((this.max.getY() - adj2.getY()) * this.getPixelPerNorth());
        int sx2 = (int)((adj2.getX() - this.min.getX()) * this.getPixelPerEast());
        int sy2 = (int)((this.max.getY() - adj1.getY()) * this.getPixelPerNorth());
        int newWidth = Math.abs(sx2 - sx1);
        int newHeight = Math.abs(sy2 - sy1);
        BufferedImage new_img = new BufferedImage(newWidth, newHeight, this.image.getType());
        Graphics g = new_img.getGraphics();
        g.drawImage(this.image, 0, 0, newWidth - 1, newHeight - 1, sx1, sy1, sx2, sy2, this);
        this.image = new_img;
        this.min = adj1;
        this.max = adj2;
        this.orgCroppedRaster[0] = this.min;
        this.orgCroppedRaster[1] = new EastNorth(this.min.east(), this.max.north());
        this.orgCroppedRaster[2] = this.max;
        this.orgCroppedRaster[3] = new EastNorth(this.max.east(), this.min.north());
        this.imageOriginalWidth = newWidth;
        this.imageOriginalHeight = newHeight;
        this.updatePixelPer();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }
}

