/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.WMSException;
import cadastre_fr.WMSLayer;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class DownloadWMSVectorImage
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private Bounds bounds;
    private static String errorMessage;

    public DownloadWMSVectorImage(WMSLayer wmsLayer, Bounds bounds) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.getName()}));
        this.wmsLayer = wmsLayer;
        this.bounds = bounds;
    }

    public void realRun() throws IOException {
        this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Contacting WMS Server..."));
        errorMessage = null;
        try {
            if (this.wmsLayer.grabber.getWmsInterface().retrieveInterface(this.wmsLayer)) {
                if (this.wmsLayer.getImages().isEmpty()) {
                    if (CacheControl.cacheEnabled && this.wmsLayer.grabThread.getCacheControl().loadCacheIfExist()) {
                        Main.map.mapView.zoomTo(this.wmsLayer.getCommuneBBox().toBounds());
                        return;
                    }
                    if (this.wmsLayer.isRaster()) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This commune is not vectorized.\nPlease use the other menu entry to georeference a \"Plan image\""));
                        Main.main.removeLayer((Layer)this.wmsLayer);
                        this.wmsLayer = null;
                        return;
                    }
                    this.wmsLayer.grabber.getWmsInterface().retrieveCommuneBBox(this.wmsLayer);
                }
                this.wmsLayer.grab(this.bounds);
            }
        }
        catch (DuplicateLayerException e) {
            System.err.println("removed a duplicated layer");
        }
        catch (WMSException e) {
            errorMessage = e.getMessage();
            this.wmsLayer.grabber.getWmsInterface().resetCookie();
        }
    }

    protected void cancel() {
        this.wmsLayer.grabber.getWmsInterface().cancel();
        if (this.wmsLayer != null) {
            this.wmsLayer.grabThread.setCancelled(true);
        }
    }

    protected void finish() {
    }

    public static void download(WMSLayer wmsLayer) {
        MapView mv = Main.map.mapView;
        Bounds bounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
        Main.worker.execute((Runnable)((Object)new DownloadWMSVectorImage(wmsLayer, bounds)));
        if (errorMessage != null) {
            JOptionPane.showMessageDialog(Main.parent, errorMessage);
        }
    }
}

