/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.Scale;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CadastrePreferenceSetting
implements PreferenceSetting {
    static final int TRANS_MIN = 1;
    static final int TRANS_MAX = 10;
    private JSlider sliderTrans = new JSlider(0, 1, 10, 10);
    private JTextField sourcing = new JTextField(20);
    private JCheckBox alterColors = new JCheckBox(I18n.tr((String)"Replace original background by JOSM background color."));
    private JCheckBox reversGrey = new JCheckBox(I18n.tr((String)"Reverse grey colors (for black backgrounds)."));
    private JCheckBox transparency = new JCheckBox(I18n.tr((String)"Set background transparent."));
    private JCheckBox drawBoundaries = new JCheckBox(I18n.tr((String)"Draw boundaries of downloaded data."));
    private JComboBox imageInterpolationMethod = new JComboBox();
    private JCheckBox disableImageCropping = new JCheckBox(I18n.tr((String)"Disable image cropping during georeferencing."));
    private JCheckBox enableTableauAssemblage = new JCheckBox(I18n.tr((String)"Use \"Tableau d''assemblage\""));
    private JCheckBox autoFirstLayer = new JCheckBox(I18n.tr((String)"Select first WMS layer in list."));
    private JCheckBox dontUseRelation = new JCheckBox(I18n.tr((String)"Don't use relation for addresses (but \"addr:street\" on elements)."));
    private JRadioButton grabMultiplier1 = new JRadioButton("", true);
    private JRadioButton grabMultiplier2 = new JRadioButton("", true);
    private JRadioButton grabMultiplier3 = new JRadioButton("", true);
    private JRadioButton grabMultiplier4 = new JRadioButton("", true);
    private JRadioButton crosspiece1 = new JRadioButton("off");
    private JRadioButton crosspiece2 = new JRadioButton("25m");
    private JRadioButton crosspiece3 = new JRadioButton("50m");
    private JRadioButton crosspiece4 = new JRadioButton("100m");
    private JRadioButton grabRes1 = new JRadioButton("high");
    private JRadioButton grabRes2 = new JRadioButton("medium");
    private JRadioButton grabRes3 = new JRadioButton("low");
    private JCheckBox layerLS3 = new JCheckBox(I18n.tr((String)"water"));
    private JCheckBox layerLS2 = new JCheckBox(I18n.tr((String)"building"));
    private JCheckBox layerLS1 = new JCheckBox(I18n.tr((String)"symbol"));
    private JCheckBox layerParcel = new JCheckBox(I18n.tr((String)"parcel"));
    private JCheckBox layerLabel = new JCheckBox(I18n.tr((String)"parcel number"));
    private JCheckBox layerNumero = new JCheckBox(I18n.tr((String)"address"));
    private JCheckBox layerLieudit = new JCheckBox(I18n.tr((String)"locality"));
    private JCheckBox layerSection = new JCheckBox(I18n.tr((String)"section"));
    private JCheckBox layerCommune = new JCheckBox(I18n.tr((String)"commune"));
    static final int DEFAULT_SQUARE_SIZE = 100;
    private JTextField grabMultiplier4Size = new JTextField(5);
    private JCheckBox enableCache = new JCheckBox(I18n.tr((String)"Enable automatic caching."));
    static final int DEFAULT_CACHE_SIZE = 0;
    JLabel jLabelCacheSize = new JLabel(I18n.tr((String)"Max. cache size (in MB)"));
    private JTextField cacheSize = new JTextField(20);
    static final String DEFAULT_RASTER_DIVIDER = "5";
    private JTextField rasterDivider = new JTextField(10);
    static final int DEFAULT_CROSSPIECES = 0;

    public void addGui(PreferenceTabbedPane gui) {
        String description = I18n.tr((String)"A special handler of the French cadastre wms at www.cadastre.gouv.fr<BR><BR>Please read the Terms and Conditions of Use here (in French): <br><a href=\"http://www.cadastre.gouv.fr/scpc/html/CU_01_ConditionsGenerales_fr.html\"> http://www.cadastre.gouv.fr/scpc/html/CU_01_ConditionsGenerales_fr.html</a> <BR>before any upload of data created by this plugin.");
        JPanel cadastrewmsMast = gui.createPreferenceTab("cadastrewms.gif", I18n.tr((String)"French cadastre WMS"), description);
        JPanel cadastrewms = new JPanel(new GridBagLayout());
        cadastrewms.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sourcing.setText(CadastrePlugin.source);
        this.sourcing.setToolTipText(I18n.tr((String)"<html>Value of key \"source\" when autosourcing is enabled</html>"));
        JLabel jLabelSource = new JLabel(I18n.tr((String)"Source"));
        cadastrewms.add((Component)jLabelSource, GBC.eop().insets(0, 0, 0, 0));
        cadastrewms.add((Component)this.sourcing, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.alterColors.setSelected(Main.pref.getBoolean("cadastrewms.alterColors", false));
        this.alterColors.setToolTipText(I18n.tr((String)"Replace the original white background by the backgound color defined in JOSM preferences."));
        cadastrewms.add((Component)this.alterColors, GBC.eop().insets(0, 0, 0, 0));
        this.reversGrey.setSelected(Main.pref.getBoolean("cadastrewms.invertGrey", false));
        this.reversGrey.setToolTipText(I18n.tr((String)"Invert the original black and white colors (and all intermediate greys). Useful for texts on dark backgrounds."));
        cadastrewms.add((Component)this.reversGrey, GBC.eop().insets(0, 0, 0, 0));
        this.transparency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CadastrePreferenceSetting.this.sliderTrans.setEnabled(CadastrePreferenceSetting.this.transparency.isSelected());
            }
        });
        this.transparency.setSelected(Main.pref.getBoolean("cadastrewms.backgroundTransparent", false));
        this.transparency.setToolTipText(I18n.tr((String)"Allows multiple layers stacking"));
        cadastrewms.add((Component)this.transparency, GBC.eop().insets(0, 0, 0, 0));
        this.sliderTrans.setSnapToTicks(true);
        this.sliderTrans.setToolTipText(I18n.tr((String)"Set WMS layers transparency. Right is opaque, left is transparent."));
        this.sliderTrans.setMajorTickSpacing(10);
        this.sliderTrans.setMinorTickSpacing(1);
        this.sliderTrans.setValue((int)(Float.parseFloat(Main.pref.get("cadastrewms.brightness", "1.0f")) * 10.0f));
        this.sliderTrans.setPaintTicks(true);
        this.sliderTrans.setPaintLabels(false);
        this.sliderTrans.setEnabled(this.transparency.isSelected());
        cadastrewms.add((Component)this.sliderTrans, GBC.eol().fill(2).insets(20, 0, 250, 0));
        this.drawBoundaries.setSelected(Main.pref.getBoolean("cadastrewms.drawBoundaries", false));
        this.drawBoundaries.setToolTipText(I18n.tr((String)"Draw a rectangle around downloaded data from WMS server."));
        cadastrewms.add((Component)this.drawBoundaries, GBC.eop().insets(0, 0, 0, 5));
        JLabel jLabelRes = new JLabel(I18n.tr((String)"Image resolution:"));
        cadastrewms.add((Component)jLabelRes, GBC.std().insets(0, 5, 10, 0));
        ButtonGroup bgResolution = new ButtonGroup();
        ActionListener resActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton button = (AbstractButton)actionEvent.getSource();
                CadastrePreferenceSetting.this.grabMultiplier4Size.setEnabled(button == CadastrePreferenceSetting.this.grabMultiplier4);
            }
        };
        this.grabRes1.addActionListener(resActionListener);
        this.grabRes1.setToolTipText(I18n.tr((String)"High resolution (1000x800)"));
        this.grabRes2.addActionListener(resActionListener);
        this.grabRes2.setToolTipText(I18n.tr((String)"Medium resolution (800x600)"));
        this.grabRes3.addActionListener(resActionListener);
        this.grabRes3.setToolTipText(I18n.tr((String)"Low resolution (600x400)"));
        bgResolution.add(this.grabRes1);
        bgResolution.add(this.grabRes2);
        bgResolution.add(this.grabRes3);
        String currentResolution = Main.pref.get("cadastrewms.resolution", "high");
        if (currentResolution.equals("high")) {
            this.grabRes1.setSelected(true);
        }
        if (currentResolution.equals("medium")) {
            this.grabRes2.setSelected(true);
        }
        if (currentResolution.equals("low")) {
            this.grabRes3.setSelected(true);
        }
        cadastrewms.add((Component)this.grabRes1, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabRes2, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabRes3, GBC.eol().fill(2).insets(5, 5, 0, 5));
        JLabel jLabelImageZoomInterpolation = new JLabel(I18n.tr((String)"Image filter interpolation:"));
        cadastrewms.add((Component)jLabelImageZoomInterpolation, GBC.std().insets(0, 0, 10, 0));
        this.imageInterpolationMethod.addItem(I18n.tr((String)"Nearest-Neighbor (fastest) [ Default ]"));
        this.imageInterpolationMethod.addItem(I18n.tr((String)"Bilinear (fast)"));
        this.imageInterpolationMethod.addItem(I18n.tr((String)"Bicubic (slow)"));
        String savedImageInterpolationMethod = Main.pref.get("cadastrewms.imageInterpolation", "standard");
        if (savedImageInterpolationMethod.equals("bilinear")) {
            this.imageInterpolationMethod.setSelectedIndex(1);
        } else if (savedImageInterpolationMethod.equals("bicubic")) {
            this.imageInterpolationMethod.setSelectedIndex(2);
        } else {
            this.imageInterpolationMethod.setSelectedIndex(0);
        }
        cadastrewms.add((Component)this.imageInterpolationMethod, GBC.eol().fill(2).insets(5, 5, 200, 5));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        JLabel jLabelScale = new JLabel(I18n.tr((String)"Vector images grab multiplier:"));
        cadastrewms.add((Component)jLabelScale, GBC.std().insets(0, 5, 10, 0));
        ButtonGroup bgGrabMultiplier = new ButtonGroup();
        ActionListener multiplierActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton button = (AbstractButton)actionEvent.getSource();
                CadastrePreferenceSetting.this.grabMultiplier4Size.setEnabled(button == CadastrePreferenceSetting.this.grabMultiplier4);
            }
        };
        this.grabMultiplier1.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_1"));
        this.grabMultiplier1.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_1"));
        this.grabMultiplier1.addActionListener(multiplierActionListener);
        this.grabMultiplier1.setToolTipText(I18n.tr((String)"Grab one image full screen"));
        this.grabMultiplier2.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_2"));
        this.grabMultiplier2.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_2"));
        this.grabMultiplier2.addActionListener(multiplierActionListener);
        this.grabMultiplier2.setToolTipText(I18n.tr((String)"Grab smaller images (higher quality but use more memory)"));
        this.grabMultiplier3.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_3"));
        this.grabMultiplier3.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_3"));
        this.grabMultiplier3.addActionListener(multiplierActionListener);
        this.grabMultiplier3.setToolTipText(I18n.tr((String)"Grab smaller images (higher quality but use more memory)"));
        this.grabMultiplier4.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_4"));
        this.grabMultiplier4.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_4"));
        this.grabMultiplier4.addActionListener(multiplierActionListener);
        this.grabMultiplier4.setToolTipText(I18n.tr((String)"Fixed size square (default is 100m)"));
        bgGrabMultiplier.add(this.grabMultiplier1);
        bgGrabMultiplier.add(this.grabMultiplier2);
        bgGrabMultiplier.add(this.grabMultiplier3);
        bgGrabMultiplier.add(this.grabMultiplier4);
        String currentScale = Main.pref.get("cadastrewms.scale", "1");
        if (currentScale.equals(Scale.X1.value)) {
            this.grabMultiplier1.setSelected(true);
        }
        if (currentScale.equals(Scale.X2.value)) {
            this.grabMultiplier2.setSelected(true);
        }
        if (currentScale.equals(Scale.X3.value)) {
            this.grabMultiplier3.setSelected(true);
        }
        if (currentScale.equals(Scale.SQUARE_100M.value)) {
            this.grabMultiplier4.setSelected(true);
        }
        cadastrewms.add((Component)this.grabMultiplier1, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabMultiplier2, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabMultiplier3, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabMultiplier4, GBC.std().insets(5, 0, 5, 0));
        int squareSize = this.getNumber("cadastrewms.squareSize", 100);
        this.grabMultiplier4Size.setText(String.valueOf(squareSize));
        this.grabMultiplier4Size.setToolTipText(I18n.tr((String)"Fixed size (from 25 to 1000 meters)"));
        this.grabMultiplier4Size.setEnabled(currentScale.equals(Scale.SQUARE_100M.value));
        cadastrewms.add((Component)this.grabMultiplier4Size, GBC.eol().fill(2).insets(5, 5, 0, 5));
        JLabel jLabelLayers = new JLabel(I18n.tr((String)"Layers:"));
        cadastrewms.add((Component)jLabelLayers, GBC.std().insets(0, 5, 10, 0));
        this.layerLS3.setSelected(Main.pref.getBoolean("cadastrewms.layerWater", true));
        this.layerLS3.setToolTipText(I18n.tr((String)"See, rivers, swimming pools."));
        cadastrewms.add((Component)this.layerLS3, GBC.std().insets(5, 0, 5, 0));
        this.layerLS2.setSelected(Main.pref.getBoolean("cadastrewms.layerBuilding", true));
        this.layerLS2.setToolTipText(I18n.tr((String)"Buildings, covers, underground constructions."));
        cadastrewms.add((Component)this.layerLS2, GBC.std().insets(5, 0, 5, 0));
        this.layerLS1.setSelected(Main.pref.getBoolean("cadastrewms.layerSymbol", true));
        this.layerLS1.setToolTipText(I18n.tr((String)"Symbols like cristian cross."));
        cadastrewms.add((Component)this.layerLS1, GBC.std().insets(5, 0, 5, 0));
        this.layerParcel.setSelected(Main.pref.getBoolean("cadastrewms.layerParcel", true));
        this.layerParcel.setToolTipText(I18n.tr((String)"Parcels."));
        cadastrewms.add((Component)this.layerParcel, GBC.eop().insets(5, 0, 5, 0));
        this.layerLabel.setSelected(Main.pref.getBoolean("cadastrewms.layerLabel", true));
        this.layerLabel.setToolTipText(I18n.tr((String)"Parcels numbers, street names."));
        cadastrewms.add((Component)this.layerLabel, GBC.std().insets(70, 0, 5, 0));
        this.layerNumero.setSelected(Main.pref.getBoolean("cadastrewms.layerNumero", true));
        this.layerNumero.setToolTipText(I18n.tr((String)"Address, houses numbers."));
        cadastrewms.add((Component)this.layerNumero, GBC.std().insets(5, 0, 5, 0));
        this.layerLieudit.setSelected(Main.pref.getBoolean("cadastrewms.layerLieudit", true));
        this.layerLieudit.setToolTipText(I18n.tr((String)"Locality, hamlet, place."));
        cadastrewms.add((Component)this.layerLieudit, GBC.std().insets(5, 0, 5, 0));
        this.layerSection.setSelected(Main.pref.getBoolean("cadastrewms.layerSection", true));
        this.layerSection.setToolTipText(I18n.tr((String)"Cadastral sections and subsections."));
        cadastrewms.add((Component)this.layerSection, GBC.std().insets(5, 0, 5, 0));
        this.layerCommune.setSelected(Main.pref.getBoolean("cadastrewms.layerCommune", true));
        this.layerCommune.setToolTipText(I18n.tr((String)"Municipality administrative borders."));
        cadastrewms.add((Component)this.layerCommune, GBC.eop().insets(5, 0, 5, 0));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        String savedRasterDivider = Main.pref.get("cadastrewms.rasterDivider", DEFAULT_RASTER_DIVIDER);
        JLabel jLabelRasterDivider = new JLabel(I18n.tr((String)"Raster images grab multiplier:"));
        this.rasterDivider.setText(savedRasterDivider);
        this.rasterDivider.setToolTipText("Raster image grab division, from 1 to 12; 12 is very high definition");
        cadastrewms.add((Component)jLabelRasterDivider, GBC.std().insets(0, 5, 10, 0));
        cadastrewms.add((Component)this.rasterDivider, GBC.eol().fill(2).insets(5, 5, 200, 5));
        this.disableImageCropping.setSelected(Main.pref.getBoolean("cadastrewms.noImageCropping", false));
        this.disableImageCropping.setToolTipText(I18n.tr((String)"Disable image cropping during georeferencing."));
        cadastrewms.add((Component)this.disableImageCropping, GBC.std().insets(0, 0, 10, 0));
        this.enableTableauAssemblage.setSelected(Main.pref.getBoolean("cadastrewms.useTA", false));
        this.enableTableauAssemblage.setToolTipText(I18n.tr((String)"Add the \"Tableau(x) d'assemblage\" in the list of cadastre sheets to grab."));
        cadastrewms.add((Component)this.enableTableauAssemblage, GBC.eop().insets(0, 0, 0, 0));
        JLabel jLabelCrosspieces = new JLabel(I18n.tr((String)"Display crosspieces:"));
        cadastrewms.add((Component)jLabelCrosspieces, GBC.std().insets(0, 0, 10, 0));
        ButtonGroup bgCrosspieces = new ButtonGroup();
        int crosspieces = this.getNumber("cadastrewms.crosspieces", 0);
        if (crosspieces == 0) {
            this.crosspiece1.setSelected(true);
        }
        if (crosspieces == 1) {
            this.crosspiece2.setSelected(true);
        }
        if (crosspieces == 2) {
            this.crosspiece3.setSelected(true);
        }
        if (crosspieces == 3) {
            this.crosspiece4.setSelected(true);
        }
        bgCrosspieces.add(this.crosspiece1);
        bgCrosspieces.add(this.crosspiece2);
        bgCrosspieces.add(this.crosspiece3);
        bgCrosspieces.add(this.crosspiece4);
        cadastrewms.add((Component)this.crosspiece1, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.crosspiece2, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.crosspiece3, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.crosspiece4, GBC.eol().fill(2).insets(5, 5, 0, 5));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        this.enableCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CadastrePreferenceSetting.this.jLabelCacheSize.setEnabled(CadastrePreferenceSetting.this.enableCache.isSelected());
                CadastrePreferenceSetting.this.cacheSize.setEnabled(CadastrePreferenceSetting.this.enableCache.isSelected());
            }
        });
        this.enableCache.setSelected(Main.pref.getBoolean("cadastrewms.enableCaching", true));
        this.enableCache.setToolTipText(I18n.tr((String)"Replace the original white background by the backgound color defined in JOSM preferences."));
        cadastrewms.add((Component)this.enableCache, GBC.eop().insets(0, 0, 0, 0));
        int size = this.getNumber("cadastrewms.cacheSize", 0);
        this.cacheSize.setText(String.valueOf(size));
        this.cacheSize.setToolTipText(I18n.tr((String)"Oldest files are automatically deleted when this size is exceeded"));
        cadastrewms.add((Component)this.jLabelCacheSize, GBC.std().insets(20, 0, 0, 0));
        cadastrewms.add((Component)this.cacheSize, GBC.eol().fill(2).insets(5, 5, 200, 5));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        this.autoFirstLayer.setSelected(Main.pref.getBoolean("cadastrewms.autoFirstLayer", false));
        this.autoFirstLayer.setToolTipText(I18n.tr((String)"Automatically selects the first WMS layer if multiple layers exist when grabbing."));
        cadastrewms.add((Component)this.autoFirstLayer, GBC.eop().insets(0, 0, 0, 0));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        this.dontUseRelation.setSelected(Main.pref.getBoolean("cadastrewms.addr.dontUseRelation", false));
        this.dontUseRelation.setToolTipText(I18n.tr((String)"Enable this to use the tag \"add:street\" on nodes."));
        cadastrewms.add((Component)this.dontUseRelation, GBC.eop().insets(0, 0, 0, 0));
        cadastrewms.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        JScrollPane scrollpane = new JScrollPane(cadastrewms);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        cadastrewmsMast.add((Component)scrollpane, GBC.eol().fill(1));
    }

    public boolean ok() {
        Main.pref.put("cadastrewms.source", this.sourcing.getText());
        CadastrePlugin.source = this.sourcing.getText();
        Main.pref.put("cadastrewms.alterColors", this.alterColors.isSelected());
        Main.pref.put("cadastrewms.invertGrey", this.reversGrey.isSelected());
        Main.pref.put("cadastrewms.backgroundTransparent", this.transparency.isSelected());
        Main.pref.put("cadastrewms.brightness", Float.toString((float)this.sliderTrans.getValue() / 10.0f));
        Main.pref.put("cadastrewms.drawBoundaries", this.drawBoundaries.isSelected());
        if (this.grabRes1.isSelected()) {
            Main.pref.put("cadastrewms.resolution", "high");
        } else if (this.grabRes2.isSelected()) {
            Main.pref.put("cadastrewms.resolution", "medium");
        } else if (this.grabRes3.isSelected()) {
            Main.pref.put("cadastrewms.resolution", "low");
        }
        if (this.imageInterpolationMethod.getSelectedIndex() == 2) {
            Main.pref.put("cadastrewms.imageInterpolation", "bicubic");
        } else if (this.imageInterpolationMethod.getSelectedIndex() == 1) {
            Main.pref.put("cadastrewms.imageInterpolation", "bilinear");
        } else {
            Main.pref.put("cadastrewms.imageInterpolation", "standard");
        }
        if (this.grabMultiplier1.isSelected()) {
            Main.pref.put("cadastrewms.scale", Scale.X1.toString());
        } else if (this.grabMultiplier2.isSelected()) {
            Main.pref.put("cadastrewms.scale", Scale.X2.toString());
        } else if (this.grabMultiplier3.isSelected()) {
            Main.pref.put("cadastrewms.scale", Scale.X3.toString());
        } else {
            Main.pref.put("cadastrewms.scale", Scale.SQUARE_100M.toString());
            try {
                int squareSize = Integer.parseInt(this.grabMultiplier4Size.getText());
                if (squareSize >= 25 && squareSize <= 1000) {
                    Main.pref.put("cadastrewms.squareSize", this.grabMultiplier4Size.getText());
                }
            }
            catch (NumberFormatException squareSize) {
                // empty catch block
            }
        }
        Main.pref.put("cadastrewms.layerWater", this.layerLS3.isSelected());
        Main.pref.put("cadastrewms.layerBuilding", this.layerLS2.isSelected());
        Main.pref.put("cadastrewms.layerSymbol", this.layerLS1.isSelected());
        Main.pref.put("cadastrewms.layerParcel", this.layerParcel.isSelected());
        Main.pref.put("cadastrewms.layerLabel", this.layerLabel.isSelected());
        Main.pref.put("cadastrewms.layerNumero", this.layerNumero.isSelected());
        Main.pref.put("cadastrewms.layerLieudit", this.layerLieudit.isSelected());
        Main.pref.put("cadastrewms.layerSection", this.layerSection.isSelected());
        Main.pref.put("cadastrewms.layerCommune", this.layerCommune.isSelected());
        try {
            int i = Integer.parseInt(this.rasterDivider.getText());
            if (i > 0 && i < 13) {
                Main.pref.put("cadastrewms.rasterDivider", String.valueOf(i));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Main.pref.put("cadastrewms.noImageCropping", this.disableImageCropping.isSelected());
        Main.pref.put("cadastrewms.useTA", this.enableTableauAssemblage.isSelected());
        if (this.crosspiece1.isSelected()) {
            Main.pref.put("cadastrewms.crosspieces", "0");
        } else if (this.crosspiece2.isSelected()) {
            Main.pref.put("cadastrewms.crosspieces", "1");
        } else if (this.crosspiece3.isSelected()) {
            Main.pref.put("cadastrewms.crosspieces", "2");
        } else if (this.crosspiece4.isSelected()) {
            Main.pref.put("cadastrewms.crosspieces", "3");
        }
        Main.pref.put("cadastrewms.enableCaching", this.enableCache.isSelected());
        try {
            CacheControl.cacheSize = Integer.parseInt(this.cacheSize.getText());
            Main.pref.put("cadastrewms.cacheSize", String.valueOf(CacheControl.cacheSize));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Main.pref.put("cadastrewms.autoFirstLayer", this.autoFirstLayer.isSelected());
        CacheControl.cacheEnabled = this.enableCache.isSelected();
        Main.pref.put("cadastrewms.addr.dontUseRelation", this.dontUseRelation.isSelected());
        CadastrePlugin.refreshConfiguration();
        CadastrePlugin.refreshMenu();
        return false;
    }

    private int getNumber(String pref_parameter, int def_value) {
        try {
            return Integer.parseInt(Main.pref.get(pref_parameter, String.valueOf(def_value)));
        }
        catch (NumberFormatException e) {
            return def_value;
        }
    }
}

