/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreInterface;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.GeorefImage;
import cadastre_fr.ImageModifier;
import cadastre_fr.RasterImageModifier;
import cadastre_fr.VectorImageModifier;
import cadastre_fr.WMSLayer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

public class CadastreGrabber {
    private CadastreInterface wmsInterface = new CadastreInterface();

    public GeorefImage grab(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws IOException, OsmTransferException {
        try {
            URL url = null;
            url = wmsLayer.isRaster() ? this.getURLRaster(wmsLayer, lambertMin, lambertMax) : this.getURLVector(lambertMin, lambertMax);
            BufferedImage img = this.grab(url);
            ImageModifier imageModified = wmsLayer.isRaster() ? new RasterImageModifier(img) : new VectorImageModifier(img, false);
            return new GeorefImage(imageModified.bufferedImage, lambertMin, lambertMax);
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.")).initCause(e);
        }
    }

    private URL getURLRaster(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        int cRasterX = CadastrePlugin.imageWidth;
        String str = new String(String.valueOf(this.wmsInterface.baseURL) + "/scpc/wms?version=1.1&request=GetMap");
        str = String.valueOf(str) + "&layers=CDIF:PMC@";
        str = String.valueOf(str) + wmsLayer.getCodeCommune();
        str = String.valueOf(str) + "&format=image/png";
        str = String.valueOf(str) + "&bbox=";
        str = String.valueOf(str) + wmsLayer.eastNorth2raster(lambertMin, lambertMax);
        str = String.valueOf(str) + "&width=" + cRasterX + "&height=";
        str = String.valueOf(str) + (int)((double)cRasterX * (wmsLayer.communeBBox.max.getY() - wmsLayer.communeBBox.min.getY()) / (wmsLayer.communeBBox.max.getX() - wmsLayer.communeBBox.min.getX()));
        str = String.valueOf(str) + "&exception=application/vnd.ogc.se_inimage&styles=";
        System.out.println("URL=" + str);
        return new URL(str.replace(" ", "%20"));
    }

    private URL buildURLVector(String layers, String styles, int width, int height, EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        String str = new String(String.valueOf(this.wmsInterface.baseURL) + "/scpc/wms?version=1.1&request=GetMap");
        str = String.valueOf(str) + "&layers=" + layers;
        str = String.valueOf(str) + "&format=image/png";
        str = String.valueOf(str) + "&bbox=" + lambertMin.east() + ",";
        str = String.valueOf(str) + lambertMin.north() + ",";
        str = String.valueOf(str) + lambertMax.east() + ",";
        str = String.valueOf(str) + lambertMax.north();
        str = String.valueOf(str) + "&width=" + width + "&height=" + height;
        str = String.valueOf(str) + "&exception=application/vnd.ogc.se_inimage";
        str = String.valueOf(str) + "&styles=" + styles;
        System.out.println("URL=" + str);
        return new URL(str.replace(" ", "%20"));
    }

    private URL getURLVector(EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        return this.buildURLVector(CadastrePlugin.grabLayers, CadastrePlugin.grabStyles, CadastrePlugin.imageWidth, CadastrePlugin.imageHeight, lambertMin, lambertMax);
    }

    private BufferedImage grab(URL url) throws IOException, OsmTransferException {
        this.wmsInterface.urlConn = (HttpURLConnection)url.openConnection();
        this.wmsInterface.urlConn.setRequestMethod("GET");
        this.wmsInterface.setCookie();
        ProgressInputStream is = new ProgressInputStream((URLConnection)this.wmsInterface.urlConn, NullProgressMonitor.INSTANCE);
        BufferedImage img = ImageIO.read((InputStream)is);
        is.close();
        return img;
    }

    public CadastreInterface getWmsInterface() {
        return this.wmsInterface;
    }
}

