/*
 * Decompiled with CFR 0.152.
 */
package sk.zdila.josm.plugin.simplify;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SimplifyAreaPreferenceSetting
implements PreferenceSetting {
    private final JTextField mergeThreshold = new JTextField(8);
    private final JTextField angleThreshold = new JTextField(8);
    private final JTextField angleFactor = new JTextField(8);
    private final JTextField areaThreshold = new JTextField(8);
    private final JTextField areaFactor = new JTextField(8);
    private final JTextField distanceThreshold = new JTextField(8);
    private final JTextField distanceFactor = new JTextField(8);

    public void addGui(PreferenceTabbedPane gui) {
        JPanel tab = gui.createPreferenceTab("simplifyArea", "Simplify Area", "Node of the way (area) is removed if all of <u>Angle Weight</u>, <u>Area Weight</u> and <u>Distance Weight</u> are greater than 1. <u>Weight</u> is computed as <u>Value</u> / <u>Threshold</u>, where <u>Value</u> is one of <u>Angle</u>, <u>Area</u> and <u>Distance</u> computed from every three adjanced points of the way.<ul><li><u>Value</u> of <u>Angle</u> is angle in degrees on the second node</li><li><u>Value</u> of <u>Area</u> is area formed by triangle</li><li><u>Value</u> of the <u>Distance</u> is Cross Track Error Distance</li></ul>All three <u>Weight</u>s multiplied by its <u>Factor</u>s are summed and node of the lowest sum is removed first. Removal continues until there is no node to remove.Merge Nearby Nodes is another step of the simplification that merges adjanced nodes that are closer than <u>Threshold</u> meters.");
        this.angleThreshold.setText(Main.pref.get("simplify-area.angle.threshold", "10"));
        tab.add((Component)new JLabel(I18n.tr((String)"Angle Threshold")), GBC.std());
        tab.add((Component)this.angleThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.angleFactor.setText(Main.pref.get("simplify-area.angle.factor", "1.0"));
        tab.add((Component)new JLabel(I18n.tr((String)"Angle Factor")), GBC.std());
        tab.add((Component)this.angleFactor, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.areaThreshold.setText(Main.pref.get("simplify-area.area.threshold", "5.0"));
        tab.add((Component)new JLabel(I18n.tr((String)"Area Threshold")), GBC.std());
        tab.add((Component)this.areaThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.areaFactor.setText(Main.pref.get("simplify-area.area.factor", "1.0"));
        tab.add((Component)new JLabel(I18n.tr((String)"Area Factor")), GBC.std());
        tab.add((Component)this.areaFactor, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.distanceThreshold.setText(Main.pref.get("simplify-area.dist.threshold", "3"));
        tab.add((Component)new JLabel(I18n.tr((String)"Distance Threshold")), GBC.std());
        tab.add((Component)this.distanceThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.distanceFactor.setText(Main.pref.get("simplify-area.dist.factor", "3"));
        tab.add((Component)new JLabel(I18n.tr((String)"Distance Factor")), GBC.std());
        tab.add((Component)this.distanceFactor, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.mergeThreshold.setText(Main.pref.get("simplify-area.merge.threshold", "0.2"));
        tab.add((Component)new JLabel(I18n.tr((String)"Merge Nearby Nodes Threshold")), GBC.std());
        tab.add((Component)this.mergeThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        tab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public boolean ok() {
        Main.pref.put("simplify-area.merge.threshold", this.mergeThreshold.getText());
        Main.pref.put("simplify-area.angle.threshold", this.angleThreshold.getText());
        Main.pref.put("simplify-area.angle.factor", this.angleFactor.getText());
        Main.pref.put("simplify-area.area.threshold", this.areaThreshold.getText());
        Main.pref.put("simplify-area.area.factor", this.areaFactor.getText());
        Main.pref.put("simplify-area.dist.threshold", this.distanceThreshold.getText());
        Main.pref.put("simplify-area.dist.factor", this.distanceFactor.getText());
        return false;
    }
}

