/*
 * Decompiled with CFR 0.152.
 */
package dumbutils;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AlignWayNodesAction
extends JosmAction {
    private static final String TITLE = "Align way nodes";

    public AlignWayNodesAction() {
        super(I18n.tr((String)TITLE), "alignwaynodes", I18n.tr((String)"Align nodes in a way"), null, true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = AlignWayNodesAction.getCurrentDataSet().getSelected();
        Set<Node> selectedNodes = this.filterNodes(selection);
        Set<Way> ways = this.findCommonWays(selectedNodes);
        if (ways == null || ways.size() != 1) {
            return;
        }
        Way way = ways.iterator().next();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < way.getNodesCount(); ++i) {
            Node node = way.getNode(i);
            if (!selectedNodes.contains(node)) continue;
            nodes.add(node);
            selectedNodes.remove(node);
        }
        ArrayList commands = new ArrayList();
        if (!commands.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)TITLE), commands));
        }
    }

    protected void updateEnabledState() {
        if (AlignWayNodesAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(AlignWayNodesAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        Set<Way> ways = this.findCommonWays(this.filterNodes(selection));
        this.setEnabled(ways != null && ways.size() == 1);
    }

    private Set<Way> findCommonWays(Set<Node> nodes) {
        HashSet ways = null;
        for (Node n : nodes) {
            List referrers = OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class);
            if (ways == null) {
                ways = new HashSet(referrers);
                continue;
            }
            if (!ways.containsAll(referrers)) {
                return null;
            }
            ways.retainAll(referrers);
        }
        return ways;
    }

    private Set<Node> filterNodes(Collection<? extends OsmPrimitive> selection) {
        HashSet<Node> result = new HashSet<Node>();
        if (selection != null) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (!(osmPrimitive instanceof Node)) continue;
                result.add((Node)osmPrimitive);
            }
        }
        return result;
    }
}

