/*
 * Decompiled with CFR 0.152.
 */
package dumbutils;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

class ReplaceGeometryAction
extends JosmAction {
    private static final String TITLE = "Replace geometry";

    public ReplaceGeometryAction() {
        super(I18n.tr((String)TITLE), "replacegeometry", I18n.tr((String)"Replace geometry of selected way with a new one"), Shortcut.registerShortcut((String)"tools:replacegeometry", (String)I18n.tr((String)TITLE), (int)71, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        List selection = OsmPrimitive.getFilteredList((Collection)ReplaceGeometryAction.getCurrentDataSet().getSelected(), Way.class);
        if (selection.size() != 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This tool replaces geometry of one way with another, and requires two ways to be selected."), I18n.tr((String)TITLE), 1);
            return;
        }
        int idxNew = ((Way)selection.get(0)).isNew() ? 0 : 1;
        Way geometry = (Way)selection.get(idxNew);
        Way way = (Way)selection.get(1 - idxNew);
        if (way.isNew() || !geometry.isNew()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select one way that exists in the database and one new way with correct geometry."), I18n.tr((String)TITLE), 2);
            return;
        }
        Way result = new Way(way);
        result.setNodes(geometry.getNodes());
        ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)result);
        DeleteCommand deleteCommand = new DeleteCommand((OsmPrimitive)geometry);
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry of way {0}", (Object[])new Object[]{way.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), new Command[]{changeCommand, deleteCommand}));
    }
}

