/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing;

import com.innovant.josm.jrt.core.RoutingGraph;
import com.innovant.josm.jrt.osm.OsmEdge;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingModel {
    static Logger logger = Logger.getLogger(RoutingModel.class);
    public RoutingGraph routingGraph = null;
    private List<Node> nodes = new ArrayList<Node>();
    private List<OsmEdge> path = null;
    private boolean changeNodes = false;

    public RoutingModel(DataSet data) {
        System.out.println("gr " + data);
        this.routingGraph = new RoutingGraph(data);
    }

    public List<Node> getSelectedNodes() {
        return this.nodes;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        this.changeNodes = true;
    }

    public void removeNode(int index) {
        if (this.nodes.size() > index) {
            this.nodes.remove(index);
            this.changeNodes = true;
        }
    }

    public void insertNode(int index, Node node) {
        if (this.nodes.size() >= index) {
            this.nodes.add(index, node);
            this.changeNodes = true;
        }
    }

    public void reverseNodes() {
        ArrayList<Node> aux = new ArrayList<Node>();
        for (Node n : this.nodes) {
            aux.add(0, n);
        }
        this.nodes = aux;
        this.changeNodes = true;
    }

    public List<OsmEdge> getRouteEdges() {
        if (this.changeNodes || this.path == null) {
            this.path = this.routingGraph.applyAlgorithm(this.nodes, RoutingGraph.Algorithm.ROUTING_ALG_DIJKSTRA);
            this.changeNodes = false;
        }
        return this.path;
    }

    public void setNodesChanged() {
        this.changeNodes = true;
    }

    public void reset() {
        this.nodes.clear();
        this.changeNodes = true;
    }
}

