/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIntersectionsAction
extends JosmAction {
    public AddIntersectionsAction() {
        super(I18n.tr((String)"Add nodes at intersections"), "addintersect", I18n.tr((String)"Add missing nodes at intersections of selected ways."), Shortcut.registerShortcut((String)"tools:addintersect", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Add nodes at intersections")}), (int)73, (int)3, (int)1), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/AddIntersections"));
    }

    public void actionPerformed(ActionEvent arg0) {
        if (!this.isEnabled()) {
            return;
        }
        List ways = OsmPrimitive.getFilteredList((Collection)AddIntersectionsAction.getCurrentDataSet().getSelected(), Way.class);
        if (ways.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select one or more ways with intersections of segments."), I18n.tr((String)"Information"), 1);
            return;
        }
        LinkedList cmds = new LinkedList();
        Geometry.addIntersections((List)ways, (boolean)false, cmds);
        if (!cmds.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Add nodes at intersections"), cmds));
        }
    }

    protected void updateEnabledState() {
        if (AddIntersectionsAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(AddIntersectionsAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

