/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import CommandLine.Command;
import CommandLine.Parameter;
import CommandLine.Relay;
import CommandLine.Type;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader
extends DefaultHandler {
    private String dirToScan;
    private String currentFile;
    private String currentTag;
    private Command currentCommand;
    private Parameter currentParameter;
    private ArrayList<Command> loadingCommands;

    public Loader(String dir) {
        this.dirToScan = dir;
        this.currentTag = "";
        this.loadingCommands = new ArrayList();
    }

    public ArrayList<Command> load() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            File path = new File(this.dirToScan + "/");
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].endsWith(".xml")) continue;
                this.currentFile = this.dirToScan + "/" + list[i];
                this.loadFile(sp, this.currentFile);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return this.loadingCommands;
    }

    private void loadFile(SAXParser parser, String fileName) {
        try {
            String a = new File(fileName).toURI().toString().replace("file:/", "file:///");
            System.out.println(a);
            parser.parse(a, (DefaultHandler)this);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) {
        block21: {
            int len;
            block20: {
                len = attrs.getLength();
                this.currentTag = rawName;
                if (!rawName.equals("command")) break block20;
                this.currentCommand = new Command();
                for (int i = 0; i < len; ++i) {
                    String Name = attrs.getQName(i);
                    String Value = attrs.getValue(i);
                    if (Name.equals("name")) {
                        this.currentCommand.name = Value;
                        continue;
                    }
                    if (Name.equals("run")) {
                        this.currentCommand.run = Value;
                        continue;
                    }
                    if (Name.equals("tracks")) {
                        if (!Value.equals("bbox")) continue;
                        this.currentCommand.tracks = true;
                        continue;
                    }
                    if (!Name.equals("icon")) continue;
                    this.currentCommand.icon = Value;
                }
                break block21;
            }
            if (!rawName.equals("parameter")) break block21;
            this.currentParameter = new Parameter();
            for (int i = 0; i < len; ++i) {
                String Name = attrs.getQName(i);
                String Value = attrs.getValue(i);
                if (Name.equals("required")) {
                    this.currentParameter.required = Value.equals("true");
                    continue;
                }
                if (Name.equals("type")) {
                    if (Value.equals("node")) {
                        this.currentParameter.type = Type.NODE;
                        continue;
                    }
                    if (Value.equals("way")) {
                        this.currentParameter.type = Type.WAY;
                        continue;
                    }
                    if (Value.equals("relation")) {
                        this.currentParameter.type = Type.RELATION;
                        continue;
                    }
                    if (Value.equals("point")) {
                        this.currentParameter.type = Type.POINT;
                        continue;
                    }
                    if (Value.equals("length")) {
                        this.currentParameter.type = Type.LENGTH;
                        continue;
                    }
                    if (Value.equals("natural")) {
                        this.currentParameter.type = Type.NATURAL;
                        continue;
                    }
                    if (Value.equals("any")) {
                        this.currentParameter.type = Type.ANY;
                        continue;
                    }
                    if (Value.equals("string")) {
                        this.currentParameter.type = Type.STRING;
                        continue;
                    }
                    if (Value.equals("relay")) {
                        this.currentParameter.type = Type.RELAY;
                        continue;
                    }
                    if (Value.equals("username")) {
                        this.currentParameter.type = Type.USERNAME;
                        continue;
                    }
                    if (Value.equals("imageryurl")) {
                        this.currentParameter.type = Type.IMAGERYURL;
                        continue;
                    }
                    if (!Value.equals("imageryoffset")) continue;
                    this.currentParameter.type = Type.IMAGERYOFFSET;
                    continue;
                }
                if (Name.equals("maxinstances")) {
                    this.currentParameter.maxInstances = Integer.parseInt(Value);
                    continue;
                }
                if (Name.equals("maxvalue")) {
                    this.currentParameter.maxVal = Float.parseFloat(Value);
                    continue;
                }
                if (!Name.equals("minvalue")) continue;
                this.currentParameter.minVal = Float.parseFloat(Value);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length).trim();
        if (this.currentParameter != null) {
            if (this.currentTag.equals("name")) {
                this.currentParameter.name = text;
            } else if (this.currentTag.equals("description")) {
                this.currentParameter.description = text;
            } else if (this.currentTag.equals("value")) {
                if (this.currentParameter.type == Type.RELAY) {
                    if (!(this.currentParameter.getRawValue() instanceof Relay)) {
                        this.currentParameter.setValue(new Relay());
                    }
                    ((Relay)this.currentParameter.getRawValue()).addValue(text);
                } else {
                    this.currentParameter.setValue(text);
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) {
        if (rawName.equals("command")) {
            this.loadingCommands.add(this.currentCommand);
            this.currentCommand = null;
        } else if (rawName.equals("parameter")) {
            if (this.currentParameter.required) {
                this.currentCommand.parameters.add(this.currentParameter);
            } else {
                this.currentCommand.optParameters.add(this.currentParameter);
            }
            this.currentParameter = null;
        } else {
            this.currentTag = "";
        }
    }

    @Override
    public void warning(SAXParseException ex) {
        System.err.println("Warning in command xml file " + this.currentFile + ": " + ex.getMessage());
    }

    @Override
    public void error(SAXParseException ex) {
        System.err.println("Error in command xml file " + this.currentFile + ": " + ex.getMessage());
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("Error in command xml file " + this.currentFile + ": " + ex.getMessage());
        throw ex;
    }
}

