/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.adapter.DisplayMenu;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.MapdustShowAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowCloseBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowCommentBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowInvalidateBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowReOpenBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.model.BugsListModel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.renderer.BugListCellRenderer;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObserver;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustBugListPanel
extends JPanel
implements ListSelectionListener,
MapdustBugDetailsObservable {
    private static final long serialVersionUID = -675120506597637085L;
    private final ArrayList<MapdustBugDetailsObserver> observers = new ArrayList();
    private List<MapdustBug> mapdustBugsList;
    private JList mapdustBugsJList;
    private JScrollPane cmpMapdustBugs;
    private MapdustButtonPanel btnPanel;
    private MapdustGUI mapdustGUI;
    private JPopupMenu menu;
    private JMenuItem menuAddComment;
    private JMenuItem menuFixed;
    private JMenuItem menuInvalidate;
    private JMenuItem menuReopen;

    public MapdustBugListPanel() {
    }

    public MapdustBugListPanel(List<MapdustBug> mapdustBugsList, String name, MapdustPlugin mapdustPlugin) {
        this.mapdustGUI = mapdustPlugin.getMapdustGUI();
        this.mapdustBugsList = mapdustBugsList;
        this.setLayout(new BorderLayout(5, 10));
        this.addComponents(mapdustPlugin);
        this.setName(name);
    }

    private void addComponents(MapdustPlugin mapdustPlugin) {
        if (this.btnPanel == null) {
            this.btnPanel = new MapdustButtonPanel(mapdustPlugin);
        }
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            MapdustShowAction action = new ShowCommentBugAction(mapdustPlugin);
            this.menuAddComment = ComponentUtil.createJMenuItem(action, "Add comment/additional info", "dialogs/comment.png");
            this.menu.add(this.menuAddComment);
            action = new ShowCloseBugAction(mapdustPlugin);
            this.menuFixed = ComponentUtil.createJMenuItem(action, "Mark as fixed", "dialogs/fixed.png");
            this.menu.add(this.menuFixed);
            action = new ShowInvalidateBugAction(mapdustPlugin);
            this.menuInvalidate = ComponentUtil.createJMenuItem(action, "Non-reproducible/Software bug", "dialogs/invalid.png");
            this.menu.add(this.menuInvalidate);
            action = new ShowReOpenBugAction(mapdustPlugin);
            this.menuReopen = ComponentUtil.createJMenuItem(action, "Reopen bug", "dialogs/reopen.png");
            this.menu.add(this.menuReopen);
        }
        if (this.mapdustBugsList == null || this.mapdustBugsList.isEmpty()) {
            String text = " No bugs in the current view for the selected";
            text = text + " filters!";
            JList<String> textJList = new JList<String>(new String[]{text});
            textJList.setBorder(new LineBorder(Color.black, 1, false));
            textJList.setCellRenderer(new BugListCellRenderer());
            this.cmpMapdustBugs = ComponentUtil.createJScrollPane(textJList);
            this.add((Component)this.cmpMapdustBugs, "Center");
        } else {
            this.mapdustBugsJList = ComponentUtil.createJList(this.mapdustBugsList, this.menu);
            this.mapdustBugsJList.addListSelectionListener(this);
            DisplayMenu adapter = new DisplayMenu(this.mapdustBugsJList, this.menu);
            this.mapdustBugsJList.addMouseListener(adapter);
            this.cmpMapdustBugs = ComponentUtil.createJScrollPane(this.mapdustBugsJList);
            this.add((Component)this.cmpMapdustBugs, "Center");
        }
        this.add((Component)this.btnPanel, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponents(List<MapdustBug> mapdustBugsList) {
        this.mapdustBugsList = mapdustBugsList;
        if (mapdustBugsList == null || mapdustBugsList.isEmpty()) {
            String text = " No bugs in the current view for the selected";
            text = text + " filters!";
            JList<String> textJList = new JList<String>(new String[]{text});
            textJList.setBorder(new LineBorder(Color.black, 1, false));
            textJList.setCellRenderer(new BugListCellRenderer());
            this.cmpMapdustBugs.getViewport().setView(textJList);
        } else {
            JList jList = this.mapdustBugsJList;
            synchronized (jList) {
                if (this.mapdustBugsJList == null) {
                    this.mapdustBugsJList = ComponentUtil.createJList(mapdustBugsList, this.menu);
                    this.mapdustBugsJList.addListSelectionListener(this);
                    DisplayMenu adapter = new DisplayMenu(this.mapdustBugsJList, this.menu);
                    this.mapdustBugsJList.addMouseListener(adapter);
                } else {
                    this.mapdustBugsJList.setModel(new BugsListModel(mapdustBugsList));
                }
                this.cmpMapdustBugs.getViewport().setView(this.mapdustBugsJList);
            }
        }
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            MapdustBug selectedBug = (MapdustBug)this.mapdustBugsJList.getSelectedValue();
            if (selectedBug != null) {
                Main.pref.put("selectedBug.status", selectedBug.getStatus().getValue());
                if (selectedBug.getStatus().getKey().equals(1)) {
                    this.btnPanel.getBtnAddComment().setEnabled(true);
                    this.btnPanel.getBtnReOpenBugReport().setEnabled(false);
                    this.btnPanel.getBtnInvalidateBugReport().setEnabled(true);
                    this.btnPanel.getBtnFixBugReport().setEnabled(true);
                    this.getMenuReopen().setEnabled(false);
                    this.getMenuInvalidate().setEnabled(true);
                    this.getMenuFixed().setEnabled(true);
                }
                if (selectedBug.getStatus().getKey().equals(2)) {
                    this.btnPanel.getBtnAddComment().setEnabled(true);
                    this.btnPanel.getBtnReOpenBugReport().setEnabled(true);
                    this.btnPanel.getBtnInvalidateBugReport().setEnabled(false);
                    this.btnPanel.getBtnFixBugReport().setEnabled(false);
                    this.getMenuReopen().setEnabled(true);
                    this.getMenuInvalidate().setEnabled(false);
                    this.getMenuFixed().setEnabled(false);
                }
                if (selectedBug.getStatus().getKey().equals(3)) {
                    this.btnPanel.getBtnAddComment().setEnabled(true);
                    this.btnPanel.getBtnReOpenBugReport().setEnabled(true);
                    this.btnPanel.getBtnInvalidateBugReport().setEnabled(false);
                    this.btnPanel.getBtnFixBugReport().setEnabled(false);
                    this.getMenuReopen().setEnabled(true);
                    this.getMenuInvalidate().setEnabled(false);
                    this.getMenuFixed().setEnabled(false);
                }
                this.btnPanel.getBtnAddComment().setSelected(false);
                this.btnPanel.getBtnReOpenBugReport().setSelected(false);
                this.btnPanel.getBtnFixBugReport().setSelected(false);
                this.btnPanel.getBtnInvalidateBugReport().setSelected(false);
                this.notifyObservers(selectedBug);
            } else {
                this.btnPanel.getBtnWorkOffline().setSelected(false);
                this.btnPanel.getBtnWorkOffline().setFocusable(false);
                this.btnPanel.getBtnRefresh().setSelected(false);
                this.btnPanel.getBtnRefresh().setFocusable(false);
                this.btnPanel.getBtnFilter().setSelected(false);
                this.btnPanel.getBtnFilter().setFocusable(false);
                this.btnPanel.getBtnAddComment().setEnabled(false);
                this.btnPanel.getBtnFixBugReport().setEnabled(false);
                this.btnPanel.getBtnInvalidateBugReport().setEnabled(false);
                this.btnPanel.getBtnReOpenBugReport().setEnabled(false);
            }
        } else {
            return;
        }
        Main.map.mapView.repaint();
        this.mapdustGUI.repaint();
    }

    public MapdustBug getSelectedBug() {
        MapdustBug selectedBug = null;
        if (this.getMapdustBugsJList() != null) {
            selectedBug = (MapdustBug)this.getMapdustBugsJList().getSelectedValue();
        }
        return selectedBug;
    }

    public void setSelectedBug(MapdustBug mapdustBug) {
        this.mapdustBugsJList.setSelectedValue(mapdustBug, false);
        int index = this.mapdustBugsJList.getSelectedIndex();
        this.mapdustBugsJList.ensureIndexIsVisible(index);
    }

    public void resetSelectedBug(int index) {
        if (this.mapdustBugsJList != null) {
            this.mapdustBugsJList.setSelectedIndex(index);
        }
    }

    public int getSelectedBugIndex() {
        return this.mapdustBugsJList.getSelectedIndex();
    }

    public void disableBtnPanel() {
        this.btnPanel.disableComponents();
    }

    public void enableBtnPanel(boolean onlyBasic) {
        this.btnPanel.enableBasicComponents(onlyBasic);
    }

    public JList getMapdustBugsJList() {
        return this.mapdustBugsJList;
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public MapdustButtonPanel getBtnPanel() {
        return this.btnPanel;
    }

    public JMenuItem getMenuAddComment() {
        return this.menuAddComment;
    }

    public JMenuItem getMenuFixed() {
        return this.menuFixed;
    }

    public JMenuItem getMenuInvalidate() {
        return this.menuInvalidate;
    }

    public JMenuItem getMenuReopen() {
        return this.menuReopen;
    }

    public List<MapdustBug> getMapdustBugsList() {
        return this.mapdustBugsList;
    }

    @Override
    public void addObserver(MapdustBugDetailsObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    @Override
    public void removeObserver(MapdustBugDetailsObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notifyObservers(MapdustBug mapdustBug) {
        Iterator<MapdustBugDetailsObserver> elements = this.observers.iterator();
        while (elements.hasNext()) {
            elements.next().showDetails(mapdustBug);
        }
    }
}

