/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.slider;

import java.awt.Font;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.openstreetmap.josm.plugins.mapdust.gui.component.slider.RelevanceSliderUI;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustRelevanceValue;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustRelevance;

public class RelevanceSlider
extends JSlider {
    private static final long serialVersionUID = 3306976109770890966L;
    private int lowerValue;
    private int upperValue;

    public RelevanceSlider() {
        super(MapdustRelevanceValue.LOW.getSliderValue(), MapdustRelevanceValue.HIGH.getSliderValue());
        this.initSlider(MapdustRelevanceValue.LOW.getSliderValue(), MapdustRelevanceValue.HIGH.getSliderValue());
    }

    private void initSlider(int lowerValue, int upperValue) {
        this.setOrientation(0);
        this.setMajorTickSpacing(4);
        this.setLowerValue(lowerValue);
        this.setUpperValue(upperValue);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setSnapToTicks(true);
        this.setFocusable(false);
        Hashtable<Integer, JLabel> values = new Hashtable<Integer, JLabel>();
        Font font = new Font("Times New Roman", 1, 12);
        ((Dictionary)values).put(MapdustRelevanceValue.LOW.getSliderValue(), ComponentUtil.createJLabel(MapdustRelevance.LOW.getName(), font, null, null));
        ((Dictionary)values).put(MapdustRelevanceValue.MID_LOW.getSliderValue(), ComponentUtil.createJLabel(MapdustRelevance.MID_LOW.getName(), font, null, null));
        ((Dictionary)values).put(MapdustRelevanceValue.MEDIUM.getSliderValue(), ComponentUtil.createJLabel(MapdustRelevance.MEDIUM.getName(), font, null, null));
        ((Dictionary)values).put(MapdustRelevanceValue.MID_HIGH.getSliderValue(), ComponentUtil.createJLabel(MapdustRelevance.MID_HIGH.getName(), font, null, null));
        ((Dictionary)values).put(MapdustRelevanceValue.HIGH.getSliderValue(), ComponentUtil.createJLabel(MapdustRelevance.HIGH.getName(), font, null, null));
        this.setLabelTable(values);
    }

    public void updateUI() {
        this.setUI(new RelevanceSliderUI(this));
        this.updateLabelUIs();
    }

    public RelevanceSliderUI getUI() {
        return (RelevanceSliderUI)this.ui;
    }

    public int getLowerValue() {
        return this.lowerValue;
    }

    public void setLowerValue(int lowerValue) {
        int oldValue = this.getLowerValue();
        int oldExtent = this.getExtent();
        int newExtent = oldExtent + oldValue - lowerValue;
        this.getModel().setRangeProperties(lowerValue, newExtent, this.getMinimum(), this.getMaximum(), true);
        this.lowerValue = lowerValue;
    }

    public int getUpperValue() {
        if (this.upperValue < this.lowerValue) {
            this.upperValue = this.lowerValue;
        }
        return this.upperValue;
    }

    public void setUpperValue(int upperValue) {
        this.upperValue = upperValue;
        int newExtent = Math.min(Math.max(0, upperValue - this.getLowerValue()), this.getMaximum() - this.getLowerValue());
        this.setExtent(newExtent);
    }

    public void setExtent(int extent) {
        super.setExtent(extent);
        this.upperValue = this.getLowerValue() + this.getExtent();
    }
}

