/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import CommandLine.Parameter;
import CommandLine.Relay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    public String name;
    public String run;
    public String icon = "";
    public ArrayList<Parameter> parameters = new ArrayList();
    public ArrayList<Parameter> optParameters = new ArrayList();
    public int currentParameterNum = 0;
    public boolean tracks = false;

    public boolean loadObject(Object obj) {
        Parameter currentParameter = this.parameters.get(this.currentParameterNum);
        if (currentParameter.maxInstances == 1) {
            if (Command.isPair(obj, currentParameter)) {
                currentParameter.setValue(obj);
                return true;
            }
        } else {
            ArrayList<OsmPrimitive> multiValue = currentParameter.getValueList();
            if (obj instanceof Collection) {
                if (((Collection)obj).size() > currentParameter.maxInstances && currentParameter.maxInstances != 0) {
                    return false;
                }
                multiValue.clear();
                multiValue.addAll((Collection)obj);
                return true;
            }
            if (obj instanceof OsmPrimitive) {
                if (multiValue.size() < currentParameter.maxInstances || currentParameter.maxInstances == 0) {
                    if (Command.isPair(obj, currentParameter)) {
                        multiValue.add((OsmPrimitive)obj);
                        return true;
                    }
                    if (this.nextParameter() && multiValue.size() > 0) {
                        return this.loadObject(obj);
                    }
                } else if (this.nextParameter()) {
                    return this.loadObject(obj);
                }
            } else if (obj instanceof String && Command.isPair(obj, currentParameter)) {
                currentParameter.setValue(obj);
                return true;
            }
        }
        return false;
    }

    public boolean nextParameter() {
        ++this.currentParameterNum;
        return this.currentParameterNum < this.parameters.size();
    }

    public boolean hasNextParameter() {
        return this.currentParameterNum + 1 < this.parameters.size();
    }

    public void resetLoading() {
        this.currentParameterNum = 0;
        for (Parameter parameter : this.parameters) {
            if (parameter.maxInstances == 1) continue;
            parameter.getValueList().clear();
        }
    }

    private static boolean isPair(Object obj, Parameter parameter) {
        switch (parameter.type) {
            case POINT: {
                if (!(obj instanceof String)) break;
                Pattern p = Pattern.compile("(-?\\d*\\.?\\d*,-?\\d*\\.?\\d*;?)*");
                Matcher m = p.matcher((String)obj);
                return m.matches();
            }
            case NODE: {
                if (!(obj instanceof Node)) break;
                return true;
            }
            case WAY: {
                if (!(obj instanceof Way)) break;
                return true;
            }
            case RELATION: {
                if (!(obj instanceof Relation)) break;
                return true;
            }
            case ANY: {
                if (!(obj instanceof Node) && !(obj instanceof Way) && !(obj instanceof Relation)) break;
                return true;
            }
            case LENGTH: {
                Pattern p;
                Matcher m;
                if (!(obj instanceof String) || !(m = (p = Pattern.compile("\\d*\\.?\\d*")).matcher((String)obj)).matches()) break;
                Float value = Float.valueOf(Float.parseFloat((String)obj));
                if (parameter.minVal != 0.0f && value.floatValue() < parameter.minVal || parameter.maxVal != 0.0f && value.floatValue() > parameter.maxVal) break;
                return true;
            }
            case NATURAL: {
                Pattern p;
                Matcher m;
                if (!(obj instanceof String) || !(m = (p = Pattern.compile("\\d*")).matcher((String)obj)).matches()) break;
                Integer value = Integer.parseInt((String)obj);
                if (parameter.minVal != 0.0f && (float)value.intValue() < parameter.minVal || parameter.maxVal != 0.0f && (float)value.intValue() > parameter.maxVal) break;
                return true;
            }
            case STRING: {
                if (!(obj instanceof String)) break;
                return true;
            }
            case RELAY: {
                if (!(obj instanceof String) || !(parameter.getRawValue() instanceof Relay) || !((Relay)parameter.getRawValue()).isCorrectValue((String)obj)) break;
                return true;
            }
            case USERNAME: {
                if (!(obj instanceof String)) break;
                return true;
            }
            case IMAGERYURL: {
                if (!(obj instanceof String)) break;
                return true;
            }
            case IMAGERYOFFSET: {
                if (!(obj instanceof String)) break;
                return true;
            }
        }
        return false;
    }

    public Collection<OsmPrimitive> getDepsObjects() {
        ArrayList<OsmPrimitive> depsObjects = new ArrayList<OsmPrimitive>();
        for (Parameter parameter : this.parameters) {
            if (!parameter.isOsm()) continue;
            if (parameter.maxInstances == 1) {
                depsObjects.addAll(this.getDepsObjects(depsObjects, (OsmPrimitive)parameter.getRawValue()));
                continue;
            }
            for (OsmPrimitive primitive : parameter.getValueList()) {
                depsObjects.addAll(this.getDepsObjects(depsObjects, primitive));
            }
        }
        return depsObjects;
    }

    public Collection<OsmPrimitive> getDepsObjects(Collection<OsmPrimitive> currentObjects, OsmPrimitive primitive) {
        ArrayList<OsmPrimitive> depsObjects = new ArrayList<OsmPrimitive>();
        if (!currentObjects.contains(primitive)) {
            if (primitive instanceof Way) {
                depsObjects.addAll(((Way)primitive).getNodes());
            } else if (primitive instanceof Relation) {
                Set relationMembers = ((Relation)primitive).getMemberPrimitives();
                for (OsmPrimitive member : relationMembers) {
                    if (currentObjects.contains(member)) continue;
                    depsObjects.add(member);
                    depsObjects.addAll(this.getDepsObjects(currentObjects, member));
                }
            }
        }
        return depsObjects;
    }
}

