/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import utilsplugin2.NodeWayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdjacentWaysAction
extends JosmAction {
    public static final boolean treeMode = false;

    public AdjacentWaysAction() {
        super(I18n.tr((String)"Adjacent ways"), "adjways", I18n.tr((String)"Adjacent ways will be selected. Nodes wiil be deselected."), Shortcut.registerShortcut((String)"tools:adjways", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Adjacent ways"}), (int)69, (int)3, (int)1), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/AdjacentWays"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = AdjacentWaysAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet((Collection)AdjacentWaysAction.getCurrentDataSet().getSelected(), Way.class);
        LinkedHashSet<Way> newWays = new LinkedHashSet<Way>();
        newWays.addAll(selectedWays);
        for (Way w : selectedWays) {
            NodeWayUtils.addWaysConnectedToWay(w, newWays);
        }
        if (!selectedNodes.isEmpty()) {
            NodeWayUtils.addWaysConnectedToNodes(selectedNodes, newWays);
        }
        AdjacentWaysAction.getCurrentDataSet().setSelected(newWays);
    }

    protected void updateEnabledState() {
        if (AdjacentWaysAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(AdjacentWaysAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

