/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import livegps.ILiveGpsSuppressor;
import org.openstreetmap.josm.Main;

public class LiveGpsSuppressor
implements Runnable,
ILiveGpsSuppressor {
    private static final int DEFAULT_SLEEP_TIME = 500;
    private static final String oldConfigKey = "livegps.refreshinterval";
    private static final String ConfigKey = "livegps.refresh_interval_msec";
    private int sleepTime;
    private boolean allowUpdate = false;
    private boolean shutdownFlag = false;

    public void run() {
        this.initSleepTime();
        this.shutdownFlag = false;
        while (!this.shutdownFlag && this.isEnabled()) {
            this.setAllowUpdate(true);
            try {
                Thread.sleep(this.getSleepTime());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void initSleepTime() {
        this.sleepTime = Main.pref.getInteger(ConfigKey, 0);
        if (this.sleepTime == 0) {
            this.sleepTime = Main.pref.getInteger(oldConfigKey, 0);
            if (this.sleepTime != 0) {
                this.sleepTime *= 1000;
                Main.pref.put(oldConfigKey, null);
            } else {
                this.sleepTime = 500;
            }
        }
        Main.pref.putInteger(ConfigKey, Integer.valueOf(this.sleepTime));
    }

    private synchronized void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    public synchronized boolean isAllowUpdate() {
        if (!this.isEnabled()) {
            return true;
        }
        if (this.allowUpdate) {
            this.allowUpdate = false;
            return true;
        }
        return false;
    }

    private boolean isEnabled() {
        return this.sleepTime > 0;
    }

    public void shutdown() {
        this.shutdownFlag = true;
    }

    private int getSleepTime() {
        return this.sleepTime;
    }
}

