/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.CollectionUtils;
import org.openstreetmap.josm.plugins.turnlanes.model.Constants;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Turn;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lane {
    private final Road.End roadEnd;
    private final int index;
    private final Kind kind;
    private double length = -1.0;

    static List<Lane> load(Road.End roadEnd) {
        ArrayList<Lane> result = new ArrayList<Lane>();
        int i = 0;
        for (double l : CollectionUtils.reverse(roadEnd.getLengths(Kind.EXTRA_LEFT))) {
            result.add(new Lane(roadEnd, --i, Kind.EXTRA_LEFT, l));
        }
        int regulars = Lane.getRegularCount(roadEnd.getWay(), roadEnd.getJunction().getNode());
        for (i = 1; i <= regulars; ++i) {
            result.add(new Lane(roadEnd, i));
        }
        i = 0;
        for (double l : roadEnd.getLengths(Kind.EXTRA_RIGHT)) {
            result.add(new Lane(roadEnd, ++i, Kind.EXTRA_RIGHT, l));
        }
        return result;
    }

    static List<Double> loadLengths(Relation r, String key, double lengthBound) {
        ArrayList<Double> result = new ArrayList<Double>();
        if (r != null && r.get(key) != null) {
            for (String s : Constants.SPLIT_PATTERN.split(r.get(key))) {
                Double length = Double.parseDouble(s.trim());
                if (!(length > lengthBound)) continue;
                result.add(length);
            }
        }
        return result;
    }

    private static int getCount(Way w) {
        String countStr = w.get("lanes");
        if (countStr != null) {
            return Integer.parseInt(countStr);
        }
        return 2;
    }

    static int getRegularCount(Way w, Node end) {
        int count = Lane.getCount(w);
        if (w.hasDirectionKeys()) {
            if (w.lastNode().equals((Object)end)) {
                return count;
            }
            return 0;
        }
        if (w.lastNode().equals((Object)end)) {
            return (count + 1) / 2;
        }
        return count / 2;
    }

    public Lane(Road.End roadEnd, int index) {
        this.roadEnd = roadEnd;
        this.index = index;
        this.kind = Kind.REGULAR;
    }

    public Lane(Road.End roadEnd, int index, Kind kind, double length) {
        assert (kind == Kind.EXTRA_LEFT || kind == Kind.EXTRA_RIGHT);
        this.roadEnd = roadEnd;
        this.index = index;
        this.kind = kind;
        this.length = length;
        if (length <= 0.0) {
            throw new IllegalArgumentException("Length must be positive");
        }
    }

    public Road getRoad() {
        return this.roadEnd.getRoad();
    }

    public Kind getKind() {
        return this.kind;
    }

    public double getLength() {
        return this.isExtra() ? this.length : this.getRoad().getLength();
    }

    public void setLength(double length) {
        if (!this.isExtra()) {
            throw new UnsupportedOperationException("Length can only be set for extra lanes.");
        }
        if (length <= 0.0) {
            throw new IllegalArgumentException("Length must positive.");
        }
        this.getOutgoingRoadEnd().updateLengths();
        this.length = length;
    }

    public boolean isExtra() {
        return this.getKind() != Kind.REGULAR;
    }

    public int getIndex() {
        return this.index;
    }

    public Junction getOutgoingJunction() {
        return this.getOutgoingRoadEnd().getJunction();
    }

    public Junction getIncomingJunction() {
        return this.getIncomingRoadEnd().getJunction();
    }

    public Road.End getOutgoingRoadEnd() {
        return this.roadEnd;
    }

    public Road.End getIncomingRoadEnd() {
        return this.roadEnd.getOppositeEnd();
    }

    public ModelContainer getContainer() {
        return this.getRoad().getContainer();
    }

    public void addTurn(List<Road> via, Road.End to) {
        Relation r;
        assert (this.equals(to.getJunction()));
        Relation existing = null;
        for (Turn t : to.getTurns()) {
            if (!t.getFrom().getOutgoingRoadEnd().equals(this.getOutgoingRoadEnd()) || !((Object)t.getVia()).equals(via)) continue;
            if (t.getFrom().equals(this)) {
                return;
            }
            existing = t.getRelation();
        }
        if (existing == null) {
            r = new Relation();
            r.put("type", "turnlanes:turns");
            r.addMember(new RelationMember("from", (OsmPrimitive)this.getOutgoingRoadEnd().getWay()));
            if (via.isEmpty()) {
                r.addMember(new RelationMember("via", (OsmPrimitive)this.getOutgoingJunction().getNode()));
            } else {
                for (Way w : Utils.flattenVia(this.getOutgoingJunction().getNode(), via, to.getJunction().getNode())) {
                    r.addMember(new RelationMember("via", (OsmPrimitive)w));
                }
            }
            r.addMember(new RelationMember("to", (OsmPrimitive)to.getWay()));
            this.getOutgoingJunction().getNode().getDataSet().addPrimitive((OsmPrimitive)r);
        } else {
            r = existing;
        }
        String key = this.isExtra() ? "lanes:extra" : "lanes";
        List<Integer> lanes = Turn.indices(r, key);
        lanes.add(this.getIndex());
        r.put(key, Turn.join(lanes));
    }

    public Set<Turn> getTurns() {
        return Turn.load(this.getContainer(), "from", (OsmPrimitive)this.getOutgoingRoadEnd().getWay());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        EXTRA_LEFT,
        EXTRA_RIGHT,
        REGULAR;


        public boolean isExtra() {
            return this == EXTRA_LEFT || this == EXTRA_RIGHT;
        }
    }
}

