/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.show;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.MapdustShowAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.ChangeIssueStatusDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;

public class ShowInvalidateBugAction
extends MapdustShowAction {
    private static final long serialVersionUID = 5163950675223273862L;

    public ShowInvalidateBugAction() {
    }

    public ShowInvalidateBugAction(MapdustPlugin mapdustPlugin) {
        this.setMapdustPlugin(mapdustPlugin);
        this.setTitle("Invalidate bug report");
        this.setIconName("dialogs/invalid.png");
        String text = "In order to invalidate the bug report, please provide ";
        text = text + "your nickname and your reason of invalidating the bug report.";
        this.setMessageText(text);
    }

    public void actionPerformed(ActionEvent event) {
        if (event != null) {
            JToggleButton btn = null;
            if (event.getSource() instanceof JToggleButton) {
                btn = (JToggleButton)event.getSource();
            } else if (event.getSource() instanceof JMenuItem) {
                this.getButtonPanel().getBtnInvalidateBugReport().setSelected(true);
            }
            this.disableButtons(this.getButtonPanel());
            ChangeIssueStatusDialog dialog = new ChangeIssueStatusDialog(this.getTitle(), this.getIconName(), this.getMessageText(), "invalidate", btn, this.getMapdustPlugin());
            dialog.setLocationRelativeTo(null);
            dialog.getContentPane().setPreferredSize(dialog.getSize());
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    void disableButtons(MapdustButtonPanel buttonPanel) {
        buttonPanel.getBtnWorkOffline().setEnabled(false);
        buttonPanel.getBtnWorkOffline().setSelected(false);
        buttonPanel.getBtnWorkOffline().setFocusable(false);
        buttonPanel.getBtnRefresh().setEnabled(false);
        buttonPanel.getBtnRefresh().setSelected(false);
        buttonPanel.getBtnRefresh().setFocusable(false);
        buttonPanel.getBtnFilter().setEnabled(false);
        buttonPanel.getBtnFilter().setSelected(false);
        buttonPanel.getBtnFilter().setFocusable(false);
        buttonPanel.getBtnAddComment().setEnabled(false);
        buttonPanel.getBtnAddComment().setSelected(false);
        buttonPanel.getBtnAddComment().setFocusable(false);
        buttonPanel.getBtnReOpenBugReport().setEnabled(false);
        buttonPanel.getBtnReOpenBugReport().setSelected(false);
        buttonPanel.getBtnReOpenBugReport().setFocusable(false);
        buttonPanel.getBtnFixBugReport().setEnabled(false);
        buttonPanel.getBtnFixBugReport().setSelected(false);
        buttonPanel.getBtnFixBugReport().setFocusable(false);
    }
}

