/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.execute;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.MapdustExecuteAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.FilterBugDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustUpdateObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustUpdateObserver;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBugFilter;

public class ExecuteFilterBug
extends MapdustExecuteAction
implements MapdustUpdateObservable {
    private static final long serialVersionUID = -2724396161610512502L;
    private final ArrayList<MapdustUpdateObserver> observers = new ArrayList();

    public ExecuteFilterBug() {
    }

    public ExecuteFilterBug(FilterBugDialog dialog, MapdustGUI mapdustGUI) {
        this.setDialog(dialog);
        this.setMapdustGUI(mapdustGUI);
    }

    public void actionPerformed(ActionEvent event) {
        JButton btn;
        if (event.getSource() instanceof JButton && (btn = (JButton)event.getSource()).getText().equals("Apply")) {
            FilterBugDialog dialog = (FilterBugDialog)this.getDialog();
            List<String> types = dialog.getCheckedTypes();
            List<Integer> statuses = dialog.getCheckedStatuses();
            boolean descr = dialog.isDescrFilterChecked();
            this.notifyObservers(new MapdustBugFilter(statuses, types, descr), false);
            this.enableFiredButton(dialog.getFiredButton());
            this.mapdustGUI.enableBtnPanel(false);
            dialog.dispose();
        }
    }

    public void addObserver(MapdustUpdateObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public void removeObserver(MapdustUpdateObserver observer) {
        this.observers.remove(observer);
    }

    public void notifyObservers(MapdustBugFilter filter, boolean first) {
        Iterator<MapdustUpdateObserver> elements = this.observers.iterator();
        while (elements.hasNext()) {
            elements.next().update(filter, false);
        }
    }
}

