/*
 * Decompiled with CFR 0.152.
 */
package relcontext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeRelationMemberRoleCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationComponent;
import relcontext.ChosenRelationListener;
import relcontext.StaticChosenRelation;
import relcontext.actions.AddRemoveMemberAction;
import relcontext.actions.ClearChosenRelationAction;
import relcontext.actions.CreateMultipolygonAction;
import relcontext.actions.CreateRelationAction;
import relcontext.actions.DeleteChosenRelationAction;
import relcontext.actions.DownloadChosenRelationAction;
import relcontext.actions.DownloadParentsAction;
import relcontext.actions.EditChosenRelationAction;
import relcontext.actions.FindRelationAction;
import relcontext.actions.RelationHelpAction;
import relcontext.actions.SelectInRelationPanelAction;
import relcontext.actions.SelectMembersAction;
import relcontext.actions.SelectRelationAction;
import relcontext.actions.SortAndFixAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelContextDialog
extends ToggleDialog
implements MapView.EditLayerChangeListener,
ChosenRelationListener,
SelectionChangedListener {
    public static final String PREF_PREFIX = "reltoolbox";
    private final DefaultTableModel relationsData;
    private ChosenRelation chosenRelation = new ChosenRelation();
    private JPanel chosenRelationPanel;
    private ChosenRelationPopupMenu popupMenu;
    private MultipolygonSettingsPopup multiPopupMenu;
    private RoleComboBoxModel roleBoxModel;
    private SortAndFixAction sortAndFixAction;
    private static final Color CHOSEN_RELATION_COLOR = new Color(255, 255, 128);
    private static final String POSSIBLE_ROLES_FILE = "relcontext/possible_roles.txt";
    private static final Map<String, List<String>> possibleRoles = RelContextDialog.loadRoles();

    public RelContextDialog() {
        super(I18n.tr((String)"Relation Toolbox"), PREF_PREFIX, I18n.tr((String)"Open relation/multipolygon editor panel"), null, 150, true);
        this.chosenRelation.addChosenRelationListener(this);
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this.chosenRelation);
        this.popupMenu = new ChosenRelationPopupMenu(this.chosenRelation);
        this.multiPopupMenu = new MultipolygonSettingsPopup();
        JPanel rcPanel = new JPanel(new BorderLayout());
        this.relationsData = new RelationTableModel();
        this.relationsData.setColumnIdentifiers(new String[]{I18n.tr((String)"Member Of"), I18n.tr((String)"Role")});
        JTable relationsTable = new JTable(this.relationsData);
        this.configureRelationsTable(relationsTable);
        rcPanel.add((Component)new JScrollPane(relationsTable, 20, 31), "Center");
        ChosenRelationMouseAdapter relationMouseAdapter = new ChosenRelationMouseAdapter();
        final JComboBox roleBox = new JComboBox();
        this.roleBoxModel = new RoleComboBoxModel(roleBox);
        roleBox.setModel(this.roleBoxModel);
        roleBox.addMouseListener(relationMouseAdapter);
        roleBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String selectedRole;
                if (e.getStateChange() == 2) {
                    return;
                }
                String memberRole = RelContextDialog.this.roleBoxModel.getSelectedMembersRole();
                String string = selectedRole = RelContextDialog.this.roleBoxModel.isAnotherRoleSelected() ? RelContextDialog.this.askForRoleName() : RelContextDialog.this.roleBoxModel.getSelectedRole();
                if (memberRole != null && selectedRole != null && !memberRole.equals(selectedRole)) {
                    RelContextDialog.this.applyRoleToSelection(selectedRole.trim());
                }
            }
        });
        roleBox.setVisible(false);
        EnterRoleAction enterRoleAction = new EnterRoleAction();
        this.chosenRelationPanel = new JPanel(new GridBagLayout());
        this.chosenRelationPanel.add((Component)new JButton((Action)((Object)new AddRemoveMemberAction(this.chosenRelation))), GBC.std());
        this.chosenRelationPanel.add((Component)this.sizeButton(new JButton(new ClearChosenRelationAction(this.chosenRelation)), 32, 0), GBC.std());
        final ChosenRelationComponent chosenRelationComponent = new ChosenRelationComponent(this.chosenRelation);
        chosenRelationComponent.addMouseListener(relationMouseAdapter);
        this.chosenRelationPanel.add((Component)chosenRelationComponent, GBC.std().fill().insets(5, 0, 5, 0));
        this.chosenRelationPanel.add(roleBox, GBC.std().fill().insets(5, 0, 5, 0));
        this.sortAndFixAction = new SortAndFixAction(this.chosenRelation);
        final JButton sortAndFixButton = (JButton)this.sizeButton(new JButton(this.sortAndFixAction), 32, 0);
        this.chosenRelationPanel.add((Component)sortAndFixButton, GBC.std().fill(3));
        final DownloadChosenRelationAction downloadChosenRelationAction = new DownloadChosenRelationAction(this.chosenRelation);
        final JButton downloadButton = (JButton)this.sizeButton(new JButton(downloadChosenRelationAction), 32, 0);
        this.chosenRelationPanel.add((Component)downloadButton, GBC.std().fill(3));
        this.chosenRelationPanel.add((Component)new JButton(new EditChosenRelationAction(this.chosenRelation)), GBC.eol().fill(3));
        rcPanel.add((Component)this.chosenRelationPanel, "North");
        roleBox.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean showRoleBox = roleBox.isEnabled();
                roleBox.setVisible(showRoleBox);
                chosenRelationComponent.setVisible(!showRoleBox);
            }
        });
        this.sortAndFixAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                sortAndFixButton.setVisible(RelContextDialog.this.sortAndFixAction.isEnabled());
            }
        });
        sortAndFixButton.setVisible(false);
        downloadChosenRelationAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                downloadButton.setVisible(downloadChosenRelationAction.isEnabled());
            }
        });
        downloadButton.setVisible(false);
        if (Main.pref.getBoolean("reltoolbox.hidetopline", false)) {
            this.chosenRelationPanel.setVisible(false);
        }
        JPanel bottomLine = new JPanel(new GridBagLayout());
        bottomLine.add((Component)new JButton((Action)((Object)new CreateRelationAction(this.chosenRelation))), GBC.std());
        JButton multipolygonButton = new JButton((Action)((Object)new CreateMultipolygonAction(this.chosenRelation)));
        bottomLine.add((Component)multipolygonButton, GBC.std());
        bottomLine.add(Box.createHorizontalGlue(), GBC.std().fill());
        bottomLine.add((Component)new JButton((Action)((Object)new FindRelationAction(this.chosenRelation))), GBC.eol());
        rcPanel.add((Component)this.sizeButton(bottomLine, 0, 24), "South");
        multipolygonButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            private void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RelContextDialog.this.multiPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.add(rcPanel, "Center");
    }

    private void configureRelationsTable(final JTable relationsTable) {
        relationsTable.setSelectionMode(0);
        relationsTable.setTableHeader(null);
        relationsTable.addMouseListener((MouseListener)new PopupMenuLauncher(){

            public void launch(MouseEvent evt) {
                Point p = evt.getPoint();
                int row = relationsTable.rowAtPoint(p);
                if (row > -1) {
                    Relation relation = (Relation)RelContextDialog.this.relationsData.getValueAt(row, 0);
                    ChosenRelationPopupMenu menu = new ChosenRelationPopupMenu(new StaticChosenRelation(relation));
                    menu.show(relationsTable, p.x, p.y - 5);
                }
            }
        });
        TableColumnModel columns = relationsTable.getColumnModel();
        columns.getColumn(0).setCellRenderer((TableCellRenderer)new OsmPrimitivRenderer(){

            protected String getComponentToolTipText(OsmPrimitive value) {
                return null;
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected && value instanceof Relation && RelContextDialog.this.chosenRelation.get() != null && value.equals(RelContextDialog.this.chosenRelation.get())) {
                    c.setBackground(CHOSEN_RELATION_COLOR);
                } else {
                    c.setBackground(table.getBackground());
                }
                return c;
            }
        });
        columns.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected && RelContextDialog.this.chosenRelation.get() != null && table.getValueAt(row, 0).equals(RelContextDialog.this.chosenRelation.get())) {
                    c.setBackground(CHOSEN_RELATION_COLOR);
                } else {
                    c.setBackground(table.getBackground());
                }
                return c;
            }
        });
        columns.getColumn(1).setPreferredWidth(40);
        columns.getColumn(0).setPreferredWidth(220);
        relationsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = relationsTable.getSelectedRow();
                if (selectedRow >= 0) {
                    RelContextDialog.this.chosenRelation.set((Relation)RelContextDialog.this.relationsData.getValueAt(selectedRow, 0));
                    relationsTable.clearSelection();
                }
            }
        });
    }

    private JComponent sizeButton(JComponent b, int width, int height) {
        Dimension pref = b.getPreferredSize();
        b.setPreferredSize(new Dimension(width <= 0 ? pref.width : width, height <= 0 ? pref.height : height));
        return b;
    }

    public void hideNotify() {
        SelectionEventManager.getInstance().removeSelectionListener((SelectionChangedListener)this);
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this.chosenRelation);
        this.chosenRelation.clear();
    }

    public void showNotify() {
        SelectionEventManager.getInstance().addSelectionListener((SelectionChangedListener)this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.chosenRelation, DatasetEventManager.FireMode.IN_EDT);
    }

    public ChosenRelation getChosenRelation() {
        return this.chosenRelation;
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        if (this.chosenRelationPanel != null && Main.pref.getBoolean("reltoolbox.hidetopline", false)) {
            this.chosenRelationPanel.setVisible(newRelation != null);
        }
        if (Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
        this.roleBoxModel.update();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (!this.isVisible() || this.relationsData == null) {
            return;
        }
        this.roleBoxModel.update();
        this.relationsData.setRowCount(0);
        this.sortAndFixAction.chosenRelationChanged(this.chosenRelation.get(), this.chosenRelation.get());
        if (newSelection == null) {
            return;
        }
        DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();
        TreeSet<Relation> relations = new TreeSet<Relation>(new Comparator<Relation>((NameFormatter)formatter){
            final /* synthetic */ NameFormatter val$formatter;
            {
                this.val$formatter = nameFormatter;
            }

            @Override
            public int compare(Relation r1, Relation r2) {
                return r1.getDisplayName(this.val$formatter).compareTo(r2.getDisplayName(this.val$formatter));
            }
        });
        for (OsmPrimitive osmPrimitive : newSelection) {
            for (OsmPrimitive ref : osmPrimitive.getReferrers()) {
                if (!(ref instanceof Relation) || ref.isIncomplete() || ref.isDeleted()) continue;
                relations.add((Relation)ref);
            }
        }
        for (Relation relation : relations) {
            String role = null;
            block3: for (RelationMember m : relation.getMembers()) {
                for (OsmPrimitive osmPrimitive : newSelection) {
                    if (!m.getMember().equals((Object)osmPrimitive)) continue;
                    if (role == null) {
                        role = m.getRole();
                        continue;
                    }
                    if (role.equals(m.getRole())) continue;
                    role = I18n.tr((String)"<different>");
                    continue block3;
                }
            }
            this.relationsData.addRow(new Object[]{relation, role == null ? "" : role});
        }
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (!(osmPrimitive instanceof Relation) || this.chosenRelation.get() != null && this.chosenRelation.get().equals((Object)osmPrimitive)) continue;
            this.relationsData.addRow(new Object[]{osmPrimitive, ""});
        }
    }

    private void updateSelection() {
        if (Main.main.getCurrentDataSet() == null) {
            this.selectionChanged(Collections.emptyList());
        } else {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        this.updateSelection();
    }

    private static Map<String, List<String>> loadRoles() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            ClassLoader classLoader = RelContextDialog.class.getClassLoader();
            InputStream possibleRolesStream = classLoader.getResourceAsStream(POSSIBLE_ROLES_FILE);
            BufferedReader r = new BufferedReader(new InputStreamReader(possibleRolesStream));
            while (r.ready()) {
                String line = r.readLine();
                StringTokenizer t = new StringTokenizer(line, " ,;:\"");
                if (!t.hasMoreTokens()) continue;
                String type = t.nextToken();
                ArrayList<String> roles = new ArrayList<String>();
                while (t.hasMoreTokens()) {
                    roles.add(t.nextToken());
                }
                result.put(type, roles);
            }
            r.close();
        }
        catch (Exception e) {
            System.err.println("[RelToolbox] Error reading possible roles file.");
            e.printStackTrace();
        }
        return result;
    }

    private String askForRoleName() {
        JPanel panel = new JPanel(new GridBagLayout());
        ArrayList<String> items = new ArrayList<String>();
        for (String role : this.roleBoxModel.getRoles()) {
            if (role.length() <= 1) continue;
            items.add(role);
        }
        final AutoCompletingComboBox role = new AutoCompletingComboBox();
        role.setPossibleItems(items);
        role.setEditable(true);
        panel.add((Component)new JLabel(I18n.tr((String)"Role")), GBC.std());
        panel.add(Box.createHorizontalStrut(10), GBC.std());
        panel.add((Component)role, GBC.eol().fill(2));
        final JOptionPane optionPane = new JOptionPane(panel, 3, 2){

            public void selectInitialValue() {
                role.requestFocusInWindow();
                role.getEditor().selectAll();
            }
        };
        final JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr((String)"Specify role"));
        dlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        role.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                optionPane.setValue(0);
            }
        });
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            return null;
        }
        return role.getEditor().getItem().toString().trim();
    }

    protected void applyRoleToSelection(String role) {
        if (this.chosenRelation != null && this.chosenRelation.get() != null && Main.main.getCurrentDataSet() != null && !Main.main.getCurrentDataSet().selectionEmpty()) {
            Collection selected = Main.main.getCurrentDataSet().getSelected();
            Relation r = this.chosenRelation.get();
            ArrayList<ChangeRelationMemberRoleCommand> commands = new ArrayList<ChangeRelationMemberRoleCommand>();
            for (int i = 0; i < r.getMembersCount(); ++i) {
                RelationMember m = r.getMember(i);
                if (!selected.contains(m.getMember()) || role.equals(m.getRole())) continue;
                commands.add(new ChangeRelationMemberRoleCommand(r, i, role));
            }
            if (!commands.isEmpty()) {
                Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Change relation member roles to {0}", (Object[])new Object[]{role}), commands));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RoleComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List<String> roles = new ArrayList<String>();
        private int selectedIndex = -1;
        private JComboBox combobox;
        private String membersRole;
        private final String EMPTY_ROLE = I18n.tr((String)"<empty>");
        private final String ANOTHER_ROLE = I18n.tr((String)"another...");

        public RoleComboBoxModel(JComboBox combobox) {
            this.combobox = combobox;
            this.update();
        }

        public void update() {
            this.membersRole = this.getSelectedMembersRoleIntl();
            if (this.membersRole == null) {
                if (this.combobox.isEnabled()) {
                    this.combobox.setEnabled(false);
                }
                return;
            }
            if (!this.combobox.isEnabled()) {
                this.combobox.setEnabled(true);
            }
            ArrayList<String> items = new ArrayList<String>();
            if (RelContextDialog.this.chosenRelation != null && RelContextDialog.this.chosenRelation.get() != null) {
                List values;
                if (RelContextDialog.this.chosenRelation.isMultipolygon()) {
                    items.add("outer");
                    items.add("inner");
                }
                if (RelContextDialog.this.chosenRelation.get().get("type") != null && (values = (List)possibleRoles.get(RelContextDialog.this.chosenRelation.get().get("type"))) != null) {
                    items.addAll(values);
                }
                for (RelationMember m : RelContextDialog.this.chosenRelation.get().getMembers()) {
                    if (m.getRole().length() <= 0 || items.contains(m.getRole())) continue;
                    items.add(m.getRole());
                }
            }
            items.add(this.EMPTY_ROLE);
            if (!items.contains(this.membersRole)) {
                items.add(0, this.membersRole);
            }
            items.add(this.ANOTHER_ROLE);
            this.roles = Collections.unmodifiableList(items);
            if (this.membersRole != null) {
                this.setSelectedItem(this.membersRole);
            } else {
                this.fireContentsChanged(this, -1, -1);
            }
            this.combobox.repaint();
        }

        public String getSelectedMembersRole() {
            return this.membersRole == this.EMPTY_ROLE ? "" : this.membersRole;
        }

        public boolean isAnotherRoleSelected() {
            return this.getSelectedRole() != null && this.getSelectedRole().equals(this.ANOTHER_ROLE);
        }

        private String getSelectedMembersRoleIntl() {
            String role = null;
            if (RelContextDialog.this.chosenRelation != null && RelContextDialog.this.chosenRelation.get() != null && Main.main.getCurrentDataSet() != null && !Main.main.getCurrentDataSet().selectionEmpty()) {
                Collection selected = Main.main.getCurrentDataSet().getSelected();
                for (RelationMember m : RelContextDialog.this.chosenRelation.get().getMembers()) {
                    if (!selected.contains(m.getMember())) continue;
                    if (role == null) {
                        role = m.getRole();
                        continue;
                    }
                    if (m.getRole() == null || role.equals(m.getRole())) continue;
                    role = I18n.tr((String)"<different>");
                    break;
                }
            }
            return role == null ? null : (role.length() == 0 ? this.EMPTY_ROLE : role);
        }

        public List<String> getRoles() {
            return this.roles;
        }

        @Override
        public int getSize() {
            return this.roles.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.getRole(index);
        }

        public String getRole(int index) {
            return this.roles.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int newIndex;
            int n = newIndex = anItem == null ? -1 : this.roles.indexOf(anItem);
            if (newIndex != this.selectedIndex) {
                this.selectedIndex = newIndex;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedIndex < 0 || this.selectedIndex >= this.getSize() ? null : this.getRole(this.selectedIndex);
        }

        public String getSelectedRole() {
            String role = this.selectedIndex < 0 || this.selectedIndex >= this.getSize() ? null : this.getRole(this.selectedIndex);
            return role != null && role.equals(this.EMPTY_ROLE) ? "" : role;
        }
    }

    private class EnterRoleAction
    extends JosmAction
    implements ChosenRelationListener {
        public EnterRoleAction() {
            super("\u0432\u0402\u00a6", null, I18n.tr((String)"Enter role for selected members"), Shortcut.registerShortcut((String)"reltoolbox:changerole", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Enter role for selected members")}), (int)82, (int)3, (int)1), true);
            RelContextDialog.this.chosenRelation.addChosenRelationListener(this);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            String role;
            if (RelContextDialog.this.roleBoxModel.membersRole != null && (role = RelContextDialog.this.askForRoleName()) != null) {
                RelContextDialog.this.applyRoleToSelection(role);
            }
        }

        public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
            this.setEnabled(newRelation != null);
        }
    }

    private class MultipolygonSettingsPopup
    extends JPopupMenu
    implements ActionListener {
        public MultipolygonSettingsPopup() {
            this.addMenuItem("boundary", "Create administrative boundary relations");
            this.addMenuItem("boundaryways", "Add tags boundary and admin_level to boundary relation ways");
            this.addMenuItem("tags", "Move area tags from contour to relation");
            this.addMenuItem("single", "Create a single multipolygon for multiple outer contours").setEnabled(false);
        }

        protected final JCheckBoxMenuItem addMenuItem(String property, String title) {
            String fullProperty = "reltoolbox.multipolygon." + property;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(I18n.tr((String)title));
            item.setSelected(Main.pref.getBoolean(fullProperty, CreateMultipolygonAction.getDefaultPropertyValue(property)));
            item.setActionCommand(fullProperty);
            item.addActionListener(this);
            this.add(item);
            return item;
        }

        public void actionPerformed(ActionEvent e) {
            String property = e.getActionCommand();
            if (property != null && property.length() > 0 && e.getSource() instanceof JCheckBoxMenuItem) {
                boolean value = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                Main.pref.put(property, value);
                this.show(this.getInvoker(), this.getX(), this.getY());
            }
        }
    }

    private class MultipolygonSettingsAction
    extends AbstractAction {
        public MultipolygonSettingsAction() {
            this.putValue("SmallIcon", ImageProvider.get((String)"svpRight"));
            this.putValue("ShortDescription", I18n.tr((String)"Change multipolygon creation settings"));
        }

        public void actionPerformed(ActionEvent e) {
            Component c = e.getSource() instanceof Component ? (Component)e.getSource() : Main.parent;
            Point p = RelContextDialog.this.getMousePosition();
            RelContextDialog.this.multiPopupMenu.show(c, 0, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelationTableModel
    extends DefaultTableModel {
        private RelationTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Relation.class : String.class;
        }
    }

    private class ChosenRelationPopupMenu
    extends JPopupMenu {
        public ChosenRelationPopupMenu(ChosenRelation chosenRelation) {
            this.add(new SelectMembersAction(chosenRelation));
            this.add(new SelectRelationAction(chosenRelation));
            this.add(new DeleteChosenRelationAction(chosenRelation));
            this.add(new DownloadParentsAction(chosenRelation));
            this.addSeparator();
            this.add(new SelectInRelationPanelAction(chosenRelation));
            this.add(new RelationHelpAction(chosenRelation));
        }
    }

    private class ChosenRelationMouseAdapter
    extends MouseAdapter {
        private ChosenRelationMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.isControlDown() || !(e.getComponent() instanceof JComboBox)) && SwingUtilities.isLeftMouseButton(e) && RelContextDialog.this.chosenRelation.get() != null && Main.map.mapView.getEditLayer() != null) {
                Main.map.mapView.getEditLayer().data.setSelected(new PrimitiveId[]{RelContextDialog.this.chosenRelation.get()});
            }
        }

        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger() && RelContextDialog.this.chosenRelation.get() != null) {
                RelContextDialog.this.popupMenu.show(e.getComponent(), e.getX(), e.getY() - 5);
            }
        }
    }
}

