/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;

public class FindRelationAction
extends JosmAction {
    protected ChosenRelation chRel;

    public FindRelationAction(ChosenRelation chRel) {
        super("Find", "relcontext/find", I18n.tr((String)"Find a relation"), Shortcut.registerShortcut((String)"reltoolbox:find", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Find a relation")}), (int)70, (int)3), true);
        this.chRel = chRel;
    }

    public void actionPerformed(ActionEvent e) {
        JPanel panel = new JPanel(new BorderLayout());
        final JTextField searchField = new JTextField();
        panel.add((Component)searchField, "North");
        final FindRelationListModel relationsData = new FindRelationListModel();
        final JList relationsList = new JList(relationsData);
        relationsList.setSelectionModel(relationsData.getSelectionModel());
        relationsList.setSelectionMode(0);
        relationsList.setCellRenderer(new OsmPrimitivRenderer());
        panel.add((Component)new JScrollPane(relationsList, 20, 31), "Center");
        panel.setPreferredSize(new Dimension(400, 400));
        final JOptionPane optionPane = new JOptionPane(panel, -1, 2){

            public void selectInitialValue() {
                searchField.requestFocusInWindow();
            }
        };
        final JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr((String)"Find a relation"));
        dlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        relationsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !relationsList.isSelectionEmpty()) {
                    dlg.setVisible(false);
                    optionPane.setValue(0);
                }
            }
        });
        searchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!relationsList.isSelectionEmpty()) {
                    dlg.setVisible(false);
                    optionPane.setValue(0);
                }
            }
        });
        searchField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FindRelationAction.this.updateRelationData(relationsData, searchField.getText());
                    }
                });
            }

            public void keyPressed(KeyEvent e) {
                if (this.shouldForward(e)) {
                    relationsList.dispatchEvent(e);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (this.shouldForward(e)) {
                    relationsList.dispatchEvent(e);
                }
            }

            private boolean shouldForward(KeyEvent e) {
                return e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 34 || e.getKeyCode() == 33 || e.getKeyCode() == 36 || e.getKeyCode() == 35;
            }
        });
        this.updateRelationData(relationsData, null);
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            return;
        }
        Relation r = (Relation)relationsList.getSelectedValue();
        if (r != null) {
            this.chRel.set(r);
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(FindRelationAction.getCurrentDataSet() != null);
    }

    protected void updateRelationData(FindRelationListModel data, String filter) {
        String[] keywords;
        String[] stringArray = keywords = filter == null ? new String[]{} : filter.split("\\s+");
        if (keywords.length > 0) {
            ArrayList<String> filteredKeywords = new ArrayList<String>(keywords.length);
            for (String s : keywords) {
                if (s.length() <= 0) continue;
                filteredKeywords.add(s.trim().toLowerCase());
            }
            keywords = filteredKeywords.toArray(new String[0]);
        }
        System.out.println("keywords.length = " + keywords.length);
        for (int i = 0; i < keywords.length; ++i) {
            System.out.println("keyword[" + i + "] = " + keywords[i]);
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        if (FindRelationAction.getEditLayer() != null) {
            for (Relation r : FindRelationAction.getEditLayer().data.getRelations()) {
                if (r.isDeleted() || !r.isVisible() || r.isIncomplete()) continue;
                boolean add = true;
                for (int i = 0; i < keywords.length && add; ++i) {
                    boolean ok = false;
                    if (String.valueOf(r.getPrimitiveId().getUniqueId()).contains(keywords[i])) {
                        ok = true;
                    } else {
                        for (String key : r.keySet()) {
                            if (!key.contains(keywords[i]) && !r.get(key).toLowerCase().contains(keywords[i]) && !I18n.tr((String)r.get(key)).toLowerCase().contains(keywords[i])) continue;
                            ok = true;
                            break;
                        }
                    }
                    if (ok) continue;
                    add = false;
                }
                if (!add) continue;
                relations.add(r);
            }
        }
        DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();
        Collections.sort(relations, new Comparator<Relation>((NameFormatter)formatter){
            final /* synthetic */ NameFormatter val$formatter;
            {
                this.val$formatter = nameFormatter;
            }

            @Override
            public int compare(Relation r1, Relation r2) {
                return r1.getDisplayName(this.val$formatter).compareTo(r2.getDisplayName(this.val$formatter));
            }
        });
        data.setRelations(relations);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FindRelationListModel
    extends AbstractListModel {
        private final ArrayList<Relation> relations = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public FindRelationListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public FindRelationListModel() {
            this(new DefaultListSelectionModel());
        }

        public DefaultListSelectionModel getSelectionModel() {
            return this.selectionModel;
        }

        public Relation getRelation(int idx) {
            return this.relations.get(idx);
        }

        @Override
        public int getSize() {
            return this.relations.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.getRelation(index);
        }

        public void setRelations(Collection<Relation> relations) {
            int selectedIndex = this.selectionModel.getMinSelectionIndex();
            Relation sel = selectedIndex < 0 ? null : this.getRelation(selectedIndex);
            this.relations.clear();
            this.selectionModel.clearSelection();
            if (relations != null) {
                this.relations.addAll(relations);
            }
            this.fireIntervalAdded(this, 0, this.getSize());
            if (sel != null && (selectedIndex = this.relations.indexOf(sel)) >= 0) {
                this.selectionModel.addSelectionInterval(selectedIndex, selectedIndex);
            }
            if (this.selectionModel.isSelectionEmpty() && !this.relations.isEmpty()) {
                this.selectionModel.addSelectionInterval(0, 0);
            }
        }
    }
}

